/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.assistance.agent.filter;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.domain.assistance.agent.AgentResponseStatus;
import org.thingsboard.trendz.domain.assistance.agent.AiAgentType;
import org.thingsboard.trendz.domain.assistance.agent.lite.LiteBusinessEntityField;
import org.thingsboard.trendz.domain.assistance.agent.lite.LiteDataField;
import org.thingsboard.trendz.domain.assistance.agent.lite.LiteViewField;
import org.thingsboard.trendz.domain.assistance.agent.lite.LiteViewFieldType;
import org.thingsboard.trendz.domain.assistance.agent.lite.filter.LiteNumberFilterConfig;
import org.thingsboard.trendz.domain.assistance.agent.lite.filter.LiteOneOfFilterConfig;
import org.thingsboard.trendz.domain.assistance.agent.lite.filter.LiteRuntimeFilter;
import org.thingsboard.trendz.domain.assistance.agent.lite.filter.LiteStringFilterConfig;
import org.thingsboard.trendz.domain.definition.entity.BusinessEntity;
import org.thingsboard.trendz.domain.definition.view.FieldAggregation;
import org.thingsboard.trendz.domain.definition.view.config.FilterCondition;
import org.thingsboard.trendz.domain.definition.view.config.RuntimeFilterField;
import org.thingsboard.trendz.domain.definition.view.config.ViewField;
import org.thingsboard.trendz.service.assistance.agent.AgentService;
import org.thingsboard.trendz.service.assistance.agent.filter.FilterExpertAgent;
import org.thingsboard.trendz.service.assistance.agent.filter.FilterExpertAgentImpl;
import org.thingsboard.trendz.service.assistance.agent.filter.domain.FilterExpertRequest;
import org.thingsboard.trendz.service.assistance.agent.filter.domain.FilterExpertResponse;
import org.thingsboard.trendz.service.assistance.agent.filter.domain.FilterExpertResult;
import org.thingsboard.trendz.service.assistance.domain.ViewAssistanceContext;
import org.thingsboard.trendz.service.assistance.domain.ViewAssistanceState;
import org.thingsboard.trendz.service.assistance.view.ViewMapper;

@Service
public class FilterExpertAgentImpl
implements FilterExpertAgent {
    private final AgentService agentService;
    private final ViewMapper viewMapper;

    @Autowired
    public FilterExpertAgentImpl(AgentService agentService, ViewMapper viewMapper) {
        this.agentService = agentService;
        this.viewMapper = viewMapper;
    }

    public FilterExpertResult findAllFilters(ViewAssistanceContext context, Set<LiteDataField> fieldsForFilters, List<BusinessEntity> reducedTopology) {
        ViewAssistanceState state = context.getViewAssistanceState();
        if (state.getFilter() == null) {
            state.setFilter(this.process(context, fieldsForFilters, reducedTopology));
        }
        return state.getFilter();
    }

    private FilterExpertResult process(ViewAssistanceContext context, Set<LiteDataField> fieldsForFilters, List<BusinessEntity> reducedTopology) {
        if (fieldsForFilters.isEmpty()) {
            return ((FilterExpertResult.FilterExpertResultBuilder)((FilterExpertResult.FilterExpertResultBuilder)FilterExpertResult.builder().viewFields(Collections.emptyList()).runtimeFilterFields(Collections.emptyList()).comment("No AI")).status(AgentResponseStatus.SUCCESS)).build();
        }
        FilterExpertRequest filterExpertRequest = FilterExpertRequest.builder().question(context.getQuestion()).myPreviousResponseWas(this.agentService.preparePreviousAnswerInfo(context, AiAgentType.FILTER_EXPERT)).fieldsForFilters(fieldsForFilters).build();
        FilterExpertResponse filterExpertResponse = (FilterExpertResponse)this.agentService.processAiRequest(context.getUser(), context.getAgentMetadataContainer(), (Object)filterExpertRequest, AiAgentType.FILTER_EXPERT);
        List filterFields = this.mapLiteRuntimeFilterFieldToRuntimeFilterField(filterExpertResponse.get_2_1_filters(), reducedTopology);
        return ((FilterExpertResult.FilterExpertResultBuilder)((FilterExpertResult.FilterExpertResultBuilder)FilterExpertResult.builder().viewFields(filterFields.stream().map(Pair::getLeft).toList()).runtimeFilterFields(filterFields.stream().map(Pair::getRight).toList()).comment(filterExpertResponse.get_1_1_comment())).status(filterExpertResponse.get_1_2_status())).build();
    }

    private List<Pair<ViewField, RuntimeFilterField>> mapLiteRuntimeFilterFieldToRuntimeFilterField(List<LiteRuntimeFilter> filters, List<BusinessEntity> reducedTopology) {
        return filters.stream().map(liteRuntimeFilter -> {
            ViewField viewField = this.viewMapper.mapLiteViewFieldToViewField(LiteViewField.builder().dataField(LiteDataField.builder().field(LiteBusinessEntityField.builder().name(liteRuntimeFilter.get_1_1_field().getName()).build()).aggregation(FieldAggregation.UNIQ).x_businessEntityName(liteRuntimeFilter.get_1_1_x_businessEntityField()).build())._type(LiteViewFieldType.DATA).x_fieldName(liteRuntimeFilter.get_1_1_field().getName()).build(), reducedTopology);
            RuntimeFilterField runtimeFilterField = new RuntimeFilterField();
            runtimeFilterField.setViewFieldId(viewField.getId());
            runtimeFilterField.setName(viewField.getLabel());
            runtimeFilterField.setSelection(Collections.emptySet());
            runtimeFilterField.setOptions(Collections.emptySet());
            switch (1.$SwitchMap$org$thingsboard$trendz$domain$assistance$agent$lite$filter$LiteFilterType[liteRuntimeFilter.get_1_2_filterType().ordinal()]) {
                case 1: {
                    LiteStringFilterConfig stringFilterConfig = liteRuntimeFilter.get_2_1_stringFilterConfig();
                    FilterCondition filterCondition = switch (1.$SwitchMap$org$thingsboard$trendz$domain$assistance$agent$lite$filter$LiteStringFilterType[stringFilterConfig.getType().ordinal()]) {
                        default -> throw new IncompatibleClassChangeError();
                        case 1 -> FilterCondition.START_WITH;
                        case 2 -> FilterCondition.END_WITH;
                        case 3 -> FilterCondition.CONTAINS;
                    };
                    runtimeFilterField.setStrParam(stringFilterConfig.getTemplate());
                    runtimeFilterField.setCondition(filterCondition);
                    break;
                }
                case 2: {
                    LiteNumberFilterConfig numberFilterConfig = liteRuntimeFilter.get_2_2_numberFilterConfig();
                    FilterCondition filterCondition = switch (1.$SwitchMap$org$thingsboard$trendz$domain$assistance$agent$lite$filter$LiteNumberFilterType[numberFilterConfig.getNumberFilterType().ordinal()]) {
                        default -> throw new IncompatibleClassChangeError();
                        case 1 -> FilterCondition.GREATER;
                        case 2 -> FilterCondition.LOWER_EQUALS;
                        case 3 -> FilterCondition.GREATER_EQUALS;
                        case 4 -> FilterCondition.LOWER;
                    };
                    runtimeFilterField.setNumericParam(numberFilterConfig.getPoint());
                    runtimeFilterField.setCondition(filterCondition);
                    break;
                }
                case 3: {
                    LiteOneOfFilterConfig liteOneOfFilterConfig = liteRuntimeFilter.get_2_3_oneOfFilterConfig();
                    runtimeFilterField.setCondition(FilterCondition.ONE_OF);
                    runtimeFilterField.setSelection(liteOneOfFilterConfig.getVariants());
                }
            }
            return Pair.of((Object)viewField, (Object)runtimeFilterField);
        }).toList();
    }
}

