/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.security.service;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.ExpiredJwtException;
import io.jsonwebtoken.Jwt;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.impl.DefaultClaims;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Base64;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.stereotype.Component;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.security.Authority;
import org.thingsboard.trendz.security.TrendzApiKeyAuthData;
import org.thingsboard.trendz.security.entity.AuthToken;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.security.entity.SecurityUser;
import org.thingsboard.trendz.tools.UUIDUtils;
import org.thingsboard.trendz.tools.json.JsonUtils;

@Component
public class TokenExtractor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TokenExtractor.class);
    public static final List<String> AUTH_TOKEN__PROPERTY_NAMES = List.of("jwt", "x-authorization", "authorization");
    public static final List<String> TRENDZ_API_KEY_HEADER_NAMES = List.of("x-trendz-api-key");
    public static final List<String> TRENDZ_TENANT_ID_HEADER_NAMES = List.of("x-trendz-tenant-id");
    public static final List<String> TRENDZ_CUSTOMER_ID_HEADER_NAMES = List.of("x-trendz-customer-id");
    public static final List<String> TRENDZ_USER_ID_HEADER_NAMES = List.of("x-trendz-user-id");

    public String extractJwtToken(HttpServletRequest request) {
        return this.extractFromRequest(AUTH_TOKEN__PROPERTY_NAMES, request).map(header -> header.replaceFirst("^Bearer\\s+", "")).orElse(null);
    }

    public TrendzApiKeyAuthData extractApiKey(HttpServletRequest request) {
        UUID userId;
        UUID customerId;
        Optional apiKeyOptional = this.extractFromRequest(TRENDZ_API_KEY_HEADER_NAMES, request);
        if (apiKeyOptional.isEmpty()) {
            return null;
        }
        String apiKey = (String)apiKeyOptional.get();
        UUID tenantId = this.extractFromRequest(TRENDZ_TENANT_ID_HEADER_NAMES, request).map(UUIDUtils::parse).orElse(EntityId.NULL_UUID);
        JwtSecurityUser user = new JwtSecurityUser(tenantId, customerId = this.extractFromRequest(TRENDZ_CUSTOMER_ID_HEADER_NAMES, request).map(UUIDUtils::parse).orElse(EntityId.NULL_UUID), userId = this.extractFromRequest(TRENDZ_USER_ID_HEADER_NAMES, request).map(UUIDUtils::parse).orElse(EntityId.NULL_UUID));
        if (JwtSecurityUser.NOT_USER.equals((Object)user)) {
            return new TrendzApiKeyAuthData(apiKey, Authority.SYS_ADMIN, user);
        }
        Authority authority = this.extractFromUser(user);
        this.validateUserDefinition(user);
        return new TrendzApiKeyAuthData(apiKey, authority, user);
    }

    public JwtSecurityUser extractUser(String rawToken) {
        try {
            String[] splitToken = rawToken.split("\\.");
            String bodyString = new String(Base64.getUrlDecoder().decode(splitToken[1]));
            Claims body = (Claims)JsonUtils.getObjectMapper().readValue(bodyString, DefaultClaims.class);
            String tenantIdRaw = (String)body.get("tenantId", String.class);
            String customerIdRaw = (String)body.get("customerId", String.class);
            String userIdRaw = (String)body.get("userId", String.class);
            UUID tenantId = StringUtils.isNotBlank((CharSequence)tenantIdRaw) ? UUID.fromString(tenantIdRaw) : EntityId.NULL_UUID;
            UUID customerId = StringUtils.isNotBlank((CharSequence)customerIdRaw) ? UUID.fromString(customerIdRaw) : EntityId.NULL_UUID;
            UUID userId = StringUtils.isNotBlank((CharSequence)userIdRaw) ? UUID.fromString(userIdRaw) : EntityId.NULL_UUID;
            JwtSecurityUser user = new JwtSecurityUser(tenantId, customerId, userId);
            this.validateUserDefinition(user);
            return user;
        }
        catch (Exception ex) {
            log.error("Invalid JWT Token", (Throwable)ex);
            throw new BadCredentialsException("Invalid JWT token: ", (Throwable)ex);
        }
    }

    public SecurityUser parseAccessJwtToken(AuthToken authToken) {
        try {
            String userId;
            String customerId;
            String[] splitToken = authToken.getToken().split("\\.");
            String unsignedToken = splitToken[0] + "." + splitToken[1] + ".";
            Jwt jwtClaims = Jwts.parser().parseClaimsJwt(unsignedToken);
            Claims claims = (Claims)jwtClaims.getBody();
            List scopes = (List)claims.get("scopes", List.class);
            if (scopes == null || scopes.isEmpty()) {
                throw new IllegalArgumentException("JWT Token doesn't have any scopes");
            }
            SecurityUser securityUser = new SecurityUser();
            securityUser.setAuthToken(authToken);
            securityUser.setAuthority(Authority.parse((String)((String)scopes.get(0))));
            String tenantId = (String)claims.get("tenantId", String.class);
            if (tenantId != null) {
                securityUser.setTenantId(UUID.fromString(tenantId));
            }
            if ((customerId = (String)claims.get("customerId", String.class)) != null) {
                securityUser.setCustomerId(UUID.fromString(customerId));
            }
            if ((userId = (String)claims.get("userId", String.class)) != null) {
                securityUser.setUserId(UUID.fromString(userId));
            }
            this.validateSysAdminAuthority(securityUser.getAuthority());
            return securityUser;
        }
        catch (ExpiredJwtException ex) {
            throw new BadCredentialsException("Token expired");
        }
        catch (IllegalArgumentException iae) {
            throw new BadCredentialsException("Illegal arguments: %s".formatted(iae.getMessage()), (Throwable)iae);
        }
        catch (Exception ex) {
            throw new BadCredentialsException("Unexpected jwt token", (Throwable)ex);
        }
    }

    private void validateUserDefinition(JwtSecurityUser user) {
        if (!this.isValidUserDefinition(user)) {
            throw new BadCredentialsException("User definition is invalid.");
        }
    }

    private boolean isValidUserDefinition(JwtSecurityUser user) {
        if (EntityId.NULL_UUID.equals(user.getTenantId())) {
            if (EntityId.NULL_UUID.equals(user.getCustomerId())) {
                return !EntityId.NULL_UUID.equals(user.getUserId());
            }
            return false;
        }
        if (EntityId.NULL_UUID.equals(user.getCustomerId())) {
            return !EntityId.NULL_UUID.equals(user.getUserId());
        }
        return true;
    }

    private void validateSysAdminAuthority(Authority authority) {
        if (Authority.SYS_ADMIN.equals((Object)authority)) {
            throw new BadCredentialsException("Please use Tenant or Customer user credentials instead of System Administrator");
        }
    }

    private Authority extractFromUser(JwtSecurityUser user) {
        if (user.isSysadmin()) {
            return Authority.SYS_ADMIN;
        }
        if (user.isTenantUser()) {
            return Authority.TENANT_ADMIN;
        }
        return Authority.CUSTOMER_USER;
    }

    private Optional<String> extractFromRequest(List<String> headerNames, HttpServletRequest request) {
        return this.extractFromHeader(headerNames, request).or(() -> this.extractFromQuery(headerNames, request));
    }

    private Optional<String> extractFromHeader(List<String> headerNames, HttpServletRequest request) {
        return headerNames.stream().map(arg_0 -> ((HttpServletRequest)request).getHeader(arg_0)).filter(StringUtils::isNotBlank).findFirst();
    }

    private Optional<String> extractFromQuery(List<String> headerNames, HttpServletRequest request) {
        return Optional.of(request).map(ServletRequest::getParameterMap).stream().flatMap(map -> headerNames.stream().map(map::get).filter(value -> value != null && ((String[])value).length == 1).map(value -> value[0])).filter(StringUtils::isNotBlank).findFirst();
    }
}

