/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.security.service;

import com.fasterxml.jackson.databind.JsonNode;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jwt;
import io.jsonwebtoken.JwtException;
import io.jsonwebtoken.Jwts;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.Cache;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.stereotype.Service;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.id.UserId;
import org.thingsboard.trendz.domain.tb.configuration.TbConfiguration;
import org.thingsboard.trendz.domain.tb.provider.RequestPriority;
import org.thingsboard.trendz.exception.TrendzException;
import org.thingsboard.trendz.security.entity.AuthToken;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.security.entity.UserValidationResult;
import org.thingsboard.trendz.security.jwt.JwtTokenBuilder;
import org.thingsboard.trendz.service.provider.TbWebClient;
import org.thingsboard.trendz.service.provider.TbWebRequest;
import org.thingsboard.trendz.service.provider.cache.CacheConfigurationName;
import org.thingsboard.trendz.service.provider.cache.CacheService;
import org.thingsboard.trendz.service.tb.configuration.TbConfigurationStorage;
import org.thingsboard.trendz.tools.DonReactive;
import org.thingsboard.trendz.tools.json.JsonUtils;
import reactor.core.publisher.Mono;

@Service
public class AuthenticationService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AuthenticationService.class);
    private static final String AUTHORIZATION_HEADER = "X-Authorization";
    private static final String USER_ID_HEADER = "X-User-Id";
    private static final String CUSTOMER_ID_HEADER = "X-Customer-Id";
    private static final Duration MARGIN = Duration.ofSeconds(30L);
    private final Cache jwtTokenCache;
    private final Cache tokenValidationCache;
    private final Cache userValidationCache;
    private final JwtTokenBuilder jwtTokenBuilder;
    private final TbWebClient tbWebClient;
    private final TbConfigurationStorage tbConfigurationStorage;

    @Autowired
    public AuthenticationService(CacheService cacheService, JwtTokenBuilder jwtTokenBuilder, TbWebClient tbWebClient, TbConfigurationStorage tbConfigurationStorage) {
        this.jwtTokenCache = cacheService.getCache(CacheConfigurationName.jwtTokenCacheName);
        this.tokenValidationCache = cacheService.getCache(CacheConfigurationName.jwtTokenValidationCacheName);
        this.userValidationCache = cacheService.getCache(CacheConfigurationName.userValidationCacheName);
        this.jwtTokenBuilder = jwtTokenBuilder;
        this.tbWebClient = tbWebClient;
        this.tbConfigurationStorage = tbConfigurationStorage;
    }

    public UserValidationResult validateToken(String jwtToken, JwtSecurityUser user) {
        UserValidationResult validationResult = (UserValidationResult)this.tokenValidationCache.get((Object)jwtToken, UserValidationResult.class);
        if (validationResult != null) {
            return validationResult;
        }
        validationResult = (UserValidationResult)DonReactive.block((Mono)this.checkUserIsValid(jwtToken, user), (Duration)Duration.of(1L, ChronoUnit.MINUTES));
        if (validationResult.isValid()) {
            this.jwtTokenCache.put((Object)user, (Object)jwtToken);
            this.tokenValidationCache.put((Object)jwtToken, (Object)validationResult);
        }
        return validationResult;
    }

    public UserValidationResult validateUser(JwtSecurityUser user) {
        UserValidationResult validationResult = (UserValidationResult)this.userValidationCache.get((Object)user, UserValidationResult.class);
        if (validationResult != null) {
            return validationResult;
        }
        validationResult = (UserValidationResult)DonReactive.block((Mono)this.checkUserIsValid(user), (Duration)Duration.of(1L, ChronoUnit.MINUTES));
        if (validationResult.isValid()) {
            this.userValidationCache.put((Object)user, (Object)validationResult);
        }
        return validationResult;
    }

    public String getJwtToken(JwtSecurityUser user) {
        String jwtToken = (String)this.jwtTokenCache.get((Object)user, () -> this.jwtTokenBuilder.buildToken(user));
        if (jwtToken == null || !this.validateJwtTokenUnsigned(jwtToken)) {
            String newToken = this.jwtTokenBuilder.buildToken(user);
            this.jwtTokenCache.put((Object)user, (Object)newToken);
            return newToken;
        }
        return jwtToken;
    }

    public HttpHeaders getAuthHeaders(JwtSecurityUser user) {
        if (user == null) {
            return new HttpHeaders();
        }
        TbConfiguration tbConfiguration = this.tbConfigurationStorage.getTbConfiguration();
        if (tbConfiguration.isEnabled()) {
            return this.getTrendzApiTokenHeader(user);
        }
        String jwtToken = this.getJwtToken(user);
        return this.getJwtHeader(jwtToken);
    }

    public HttpHeaders getJwtHeader(String jwtToken) {
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.add(AUTHORIZATION_HEADER, "Bearer " + jwtToken);
        return httpHeaders;
    }

    public HttpHeaders getTrendzApiTokenHeader() {
        String accessToken = this.tbConfigurationStorage.getTbConfiguration().getAccessToken();
        if (accessToken == null) {
            throw new IllegalStateException("Trendz api token cannot be null.");
        }
        return this.getTrendzApiTokenHeader(accessToken);
    }

    public HttpHeaders getTrendzApiTokenHeader(JwtSecurityUser user) {
        HttpHeaders httpHeaders = this.getTrendzApiTokenHeader();
        if (!user.isSysadminOrNotUser()) {
            httpHeaders.add(USER_ID_HEADER, user.getUserId().toString());
            httpHeaders.add(CUSTOMER_ID_HEADER, user.getCustomerId().toString());
        }
        return httpHeaders;
    }

    public HttpHeaders getTrendzApiTokenHeader(String accessToken) {
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.add(AUTHORIZATION_HEADER, "ApiKey " + accessToken);
        return httpHeaders;
    }

    private boolean validateJwtTokenUnsigned(String jwtToken) {
        try {
            String[] parts = jwtToken.split("\\.");
            if (parts.length < 2) {
                return false;
            }
            String unsigned = parts[0] + "." + parts[1] + ".";
            Jwt jwt = Jwts.parser().parseClaimsJwt(unsigned);
            Instant exp = ((Claims)jwt.getBody()).getExpiration().toInstant();
            return Instant.now().plus(MARGIN).isBefore(exp);
        }
        catch (JwtException | IllegalArgumentException e) {
            return false;
        }
    }

    private Mono<UserValidationResult> checkUserIsValid(String jwtToken, JwtSecurityUser user) {
        return this.checkTokenIsValid(this.getJwtHeader(jwtToken), user);
    }

    private Mono<UserValidationResult> checkUserIsValid(JwtSecurityUser user) {
        return this.checkTokenIsValid(this.getAuthHeaders(user), user);
    }

    private Mono<UserValidationResult> checkTokenIsValid(HttpHeaders authHeaders, JwtSecurityUser user) {
        if (user.isPublicUser()) {
            Map<String, String> body = Map.of("publicId", user.getCustomerId().toString());
            return this.tbWebClient.post(new TbWebRequest("/api/auth/login/public", RequestPriority.HIGH, new HttpHeaders(), body, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */)).map(response -> {
                JsonNode responseBody = (JsonNode)response.getResponse().orElseThrow();
                AuthToken authToken = (AuthToken)JsonUtils.fromNodeToObject((JsonNode)responseBody, AuthToken.class);
                boolean valid = Objects.nonNull(authToken) && Objects.nonNull(authToken.getToken()) && Objects.nonNull(authToken.getRefreshToken());
                log.trace("Checking public customer user with public id {}, result = {}", (Object)user.getCustomerId(), (Object)valid);
                return new UserValidationResult(valid, "Public");
            }).onErrorResume(throwable -> this.processThrowable(throwable, "Error during parsing loaded user during the public customer user record validation"));
        }
        return this.tbWebClient.get(new TbWebRequest("/api/user/" + String.valueOf(user.getUserId()), RequestPriority.HIGH, authHeaders, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */)).map(response -> {
            JsonNode responseBody = (JsonNode)response.getResponse().orElseThrow();
            TenantId tenantId = (TenantId)JsonUtils.fromNodeToObject((JsonNode)responseBody.get("tenantId"), TenantId.class);
            CustomerId customerId = (CustomerId)JsonUtils.fromNodeToObject((JsonNode)responseBody.get("customerId"), CustomerId.class);
            UserId userId = (UserId)JsonUtils.fromNodeToObject((JsonNode)responseBody.get("id"), UserId.class);
            String username = responseBody.get("email").asText();
            JwtSecurityUser loadedUser = new JwtSecurityUser(tenantId.getId(), customerId.getId(), userId.getId());
            boolean valid = loadedUser.equals((Object)user);
            if (log.isTraceEnabled()) {
                String email = responseBody.get("email").asText();
                log.trace("Checking user with email {}, result = {}", (Object)email, (Object)valid);
            }
            return new UserValidationResult(valid, username);
        }).onErrorResume(throwable -> this.processThrowable(throwable, "Error during parsing loaded user during the simple user record validation"));
    }

    private Mono<UserValidationResult> processThrowable(Throwable throwable, String message) {
        if (throwable.getCause() instanceof WebClientResponseException.Unauthorized || throwable.getCause() instanceof WebClientResponseException.Forbidden) {
            return Mono.just((Object)new UserValidationResult(false, null));
        }
        return Mono.error((Throwable)new TrendzException(message, throwable));
    }
}

