/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.security.provider;

import java.util.Objects;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.stereotype.Component;
import org.thingsboard.trendz.domain.tb.configuration.TbConfiguration;
import org.thingsboard.trendz.security.token.TrendzApiKeyAuthentificationToken;
import org.thingsboard.trendz.service.tb.configuration.TbConfigurationStorage;

@Component
public class TrendzApiKeyAuthenticationProvider
implements AuthenticationProvider {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TrendzApiKeyAuthenticationProvider.class);
    private final TbConfigurationStorage tbConfigurationStorage;

    @Autowired
    public TrendzApiKeyAuthenticationProvider(TbConfigurationStorage tbConfigurationStorage) {
        this.tbConfigurationStorage = tbConfigurationStorage;
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        String expectedKey;
        TbConfiguration tbConfiguration = this.tbConfigurationStorage.getTbConfiguration();
        if (!tbConfiguration.isEnabled()) {
            throw new AuthenticationServiceException("Trendz API key authorization is disabled.");
        }
        String actualKey = (String)authentication.getCredentials();
        if (!Objects.equals(actualKey, expectedKey = tbConfiguration.getAccessToken())) {
            throw new AuthenticationServiceException("Trendz API key is invalid.");
        }
        authentication.setAuthenticated(true);
        return authentication;
    }

    public boolean supports(Class<?> authentication) {
        return TrendzApiKeyAuthentificationToken.class.isAssignableFrom(authentication);
    }
}

