/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.security.provider;

import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.thingsboard.trendz.security.entity.AuthToken;
import org.thingsboard.trendz.security.entity.SecurityUser;
import org.thingsboard.trendz.security.service.TokenExtractor;
import org.thingsboard.trendz.service.provider.TbRestDataSource;
import org.thingsboard.trendz.tools.DonReactive;
import reactor.core.publisher.Mono;

@Component
public class TbAuthenticationProvider
implements AuthenticationProvider {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TbAuthenticationProvider.class);
    private final TbRestDataSource tbApi;
    private final TokenExtractor tokenExtractor;

    @Autowired
    public TbAuthenticationProvider(TbRestDataSource tbApi, TokenExtractor tokenExtractor) {
        this.tbApi = tbApi;
        this.tokenExtractor = tokenExtractor;
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        Assert.notNull((Object)authentication, (String)"No authentication data provided");
        Object principal = authentication.getPrincipal();
        return this.authenticateByUsernameAndPassword(authentication, principal);
    }

    public boolean supports(Class<?> authentication) {
        return UsernamePasswordAuthenticationToken.class.isAssignableFrom(authentication);
    }

    private Authentication authenticateByUsernameAndPassword(Authentication authentication, Object principal) {
        try {
            AuthToken authToken = (AuthToken)DonReactive.block((Mono)this.tbApi.login(authentication.getPrincipal().toString(), authentication.getCredentials().toString()).onErrorMap(throwable -> {
                if (throwable.getCause() instanceof WebClientResponseException.Unauthorized) {
                    return new BadCredentialsException("Bad Credentials");
                }
                return throwable;
            }));
            SecurityUser securityUser = this.tokenExtractor.parseAccessJwtToken(authToken);
            return new UsernamePasswordAuthenticationToken((Object)securityUser, null, securityUser.getAuthorities());
        }
        catch (Exception e) {
            Throwable cause = e.getCause();
            if (cause instanceof BadCredentialsException) {
                BadCredentialsException badCredentialsException = (BadCredentialsException)cause;
                throw badCredentialsException;
            }
            throw e;
        }
    }
}

