/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.security.provider;

import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;
import org.thingsboard.trendz.security.entity.AuthToken;
import org.thingsboard.trendz.security.entity.SecurityUser;
import org.thingsboard.trendz.security.service.TokenExtractor;
import org.thingsboard.trendz.security.token.RefreshAuthenticationToken;
import org.thingsboard.trendz.service.provider.TbRestDataSource;
import org.thingsboard.trendz.tools.DonReactive;
import reactor.core.publisher.Mono;

@Component
public class RefreshTokenAuthenticationProvider
implements AuthenticationProvider {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RefreshTokenAuthenticationProvider.class);
    private final TokenExtractor tokenExtractor;
    private final TbRestDataSource tbApi;

    @Autowired
    public RefreshTokenAuthenticationProvider(TokenExtractor tokenExtractor, TbRestDataSource tbApi) {
        this.tokenExtractor = tokenExtractor;
        this.tbApi = tbApi;
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        try {
            Assert.notNull((Object)authentication, (String)"No authentication data provided");
            AuthToken credentials = (AuthToken)authentication.getCredentials();
            AuthToken authToken = (AuthToken)DonReactive.block((Mono)this.tbApi.refreshToken(credentials.getRefreshToken()));
            SecurityUser securityUser = this.tokenExtractor.parseAccessJwtToken(authToken);
            return new RefreshAuthenticationToken(securityUser);
        }
        catch (Throwable th) {
            throw new BadCredentialsException("Could not refresh token", th);
        }
    }

    public boolean supports(Class<?> authentication) {
        return RefreshAuthenticationToken.class.isAssignableFrom(authentication);
    }
}

