/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.security.jwt;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.domain.definition.ApplicationProperty;
import org.thingsboard.trendz.exception.security.JwtTokenException;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.security.jwt.JwtSettings;
import org.thingsboard.trendz.service.definition.ApplicationPropertyService;

@Service
public class JwtTokenBuilder {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JwtTokenBuilder.class);
    private static final String SCOPES = "scopes";
    private static final String USER_ID = "userId";
    private static final String ENABLED = "enabled";
    private static final String IS_PUBLIC = "isPublic";
    private static final String TENANT_ID = "tenantId";
    private static final String CUSTOMER_ID = "customerId";
    private final ApplicationPropertyService applicationPropertyService;
    private final JwtSettings jwtSettings;

    @Autowired
    public JwtTokenBuilder(ApplicationPropertyService applicationPropertyService, JwtSettings jwtSettings) {
        this.applicationPropertyService = applicationPropertyService;
        this.jwtSettings = jwtSettings;
    }

    public String buildToken(JwtSecurityUser user) {
        if (user == null) {
            throw new JwtTokenException("User is null");
        }
        String signingKey = this.applicationPropertyService.getProperty(ApplicationProperty.Key.SIGNING_KEY).orElse(this.jwtSettings.getTokenSigningKey());
        JwtSettings settings = new JwtSettings(this.jwtSettings);
        settings.setTokenSigningKey(signingKey);
        return this.buildToken(user, settings);
    }

    private String buildToken(JwtSecurityUser user, JwtSettings settings) {
        ZonedDateTime currentTime = ZonedDateTime.now();
        String issuer = settings.getTokenIssuer();
        String tokenSigningKey = settings.getTokenSigningKey();
        long tokenExpirationTimeSec = TimeUnit.SECONDS.toSeconds(settings.getTokenExpirationTime().intValue());
        String subject = "trendzJob";
        Claims claims = Jwts.claims().setSubject(subject);
        claims.put((Object)SCOPES, Collections.singletonList(this.getTokenScope(user)));
        claims.put((Object)ENABLED, (Object)true);
        claims.put((Object)IS_PUBLIC, (Object)false);
        claims.put((Object)TENANT_ID, (Object)user.getTenantId().toString());
        if (user.getCustomerId() != null) {
            claims.put((Object)CUSTOMER_ID, (Object)user.getCustomerId().toString());
        }
        if (user.getUserId() != null) {
            claims.put((Object)USER_ID, (Object)user.getUserId().toString());
        }
        String token = Jwts.builder().setClaims(claims).setIssuer(issuer).setIssuedAt(Date.from(currentTime.toInstant())).setExpiration(Date.from(currentTime.plusSeconds(tokenExpirationTimeSec).toInstant())).signWith(SignatureAlgorithm.HS512, tokenSigningKey).compact();
        log.debug("Build jwt-token for {}, token: {}", (Object)user, (Object)token);
        return token;
    }

    private String getTokenScope(JwtSecurityUser user) {
        if (user.isCustomerUser()) {
            return "CUSTOMER_USER";
        }
        if (user.isTenantUser()) {
            return "TENANT_ADMIN";
        }
        if (user.isSysadmin()) {
            return "SYS_ADMIN";
        }
        throw new JwtTokenException("Invalid security user for token building");
    }
}

