/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.security.handler;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.Writer;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.access.AccessDeniedHandler;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.stereotype.Component;
import org.thingsboard.trendz.security.entity.TrendzErrorCode;
import org.thingsboard.trendz.security.entity.TrendzErrorResponse;
import org.thingsboard.trendz.tools.json.JsonUtils;

@Component
public class TrendzErrorResponseHandler
implements AccessDeniedHandler,
AuthenticationFailureHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TrendzErrorResponseHandler.class);

    public void handle(HttpServletRequest request, HttpServletResponse response, AccessDeniedException accessDeniedException) throws IOException {
        if (!response.isCommitted()) {
            response.setContentType("application/json");
            response.setStatus(HttpStatus.FORBIDDEN.value());
            String message = "You aren't authorized to perform this operation!";
            TrendzErrorResponse resp = TrendzErrorResponse.of((String)message, (TrendzErrorCode)TrendzErrorCode.PERMISSION_DENIED, (HttpStatus)HttpStatus.FORBIDDEN);
            JsonUtils.getObjectMapper().writeValue((Writer)response.getWriter(), (Object)resp);
        }
    }

    public void onAuthenticationFailure(HttpServletRequest request, HttpServletResponse response, AuthenticationException exception) throws IOException {
        if (!response.isCommitted()) {
            response.setContentType("application/json");
            response.setStatus(HttpStatus.FORBIDDEN.value());
            if (exception instanceof BadCredentialsException) {
                TrendzErrorResponse resp = TrendzErrorResponse.of((String)exception.getMessage(), (TrendzErrorCode)TrendzErrorCode.PERMISSION_DENIED, (HttpStatus)HttpStatus.FORBIDDEN);
                JsonUtils.getObjectMapper().writeValue((Writer)response.getWriter(), (Object)resp);
                return;
            }
            String message = "You aren't authorized to perform this operation!";
            TrendzErrorResponse resp = TrendzErrorResponse.of((String)message, (TrendzErrorCode)TrendzErrorCode.PERMISSION_DENIED, (HttpStatus)HttpStatus.FORBIDDEN);
            JsonUtils.getObjectMapper().writeValue((Writer)response.getWriter(), (Object)resp);
        }
    }
}

