/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.security.filter;

import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.authentication.AbstractAuthenticationProcessingFilter;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.thingsboard.trendz.security.TrendzApiKeyAuthData;
import org.thingsboard.trendz.security.entity.AuthToken;
import org.thingsboard.trendz.security.service.TokenExtractor;
import org.thingsboard.trendz.security.token.JwtAuthenticationToken;
import org.thingsboard.trendz.security.token.TrendzApiKeyAuthentificationToken;

public class TokenAuthenticationProcessingFilter
extends AbstractAuthenticationProcessingFilter {
    private final AuthenticationFailureHandler failureHandler;
    private final TokenExtractor tokenExtractor;

    public TokenAuthenticationProcessingFilter(AuthenticationFailureHandler failureHandler, TokenExtractor tokenExtractor, RequestMatcher matcher) {
        super(matcher);
        this.failureHandler = failureHandler;
        this.tokenExtractor = tokenExtractor;
    }

    public Authentication attemptAuthentication(HttpServletRequest request, HttpServletResponse response) throws AuthenticationException {
        String jwtToken = this.tokenExtractor.extractJwtToken(request);
        if (!StringUtils.isBlank((CharSequence)jwtToken)) {
            JwtAuthenticationToken authToken = new JwtAuthenticationToken(new AuthToken(jwtToken, null));
            return this.getAuthenticationManager().authenticate((Authentication)authToken);
        }
        TrendzApiKeyAuthData trendzApiKeyAuthData = this.tokenExtractor.extractApiKey(request);
        if (trendzApiKeyAuthData != null) {
            TrendzApiKeyAuthentificationToken authToken = new TrendzApiKeyAuthentificationToken(trendzApiKeyAuthData);
            return this.getAuthenticationManager().authenticate((Authentication)authToken);
        }
        throw new AuthenticationServiceException("Authorization query parameter cannot be blank!");
    }

    protected void successfulAuthentication(HttpServletRequest request, HttpServletResponse response, FilterChain chain, Authentication authResult) throws IOException, ServletException {
        SecurityContext context = SecurityContextHolder.createEmptyContext();
        context.setAuthentication(authResult);
        SecurityContextHolder.setContext((SecurityContext)context);
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    protected void unsuccessfulAuthentication(HttpServletRequest request, HttpServletResponse response, AuthenticationException failed) throws IOException, ServletException {
        SecurityContextHolder.clearContext();
        this.failureHandler.onAuthenticationFailure(request, response, failed);
    }
}

