/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.interceptor;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.Writer;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.Cache;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.HandlerInterceptor;
import org.thingsboard.trendz.controller.BaseController;
import org.thingsboard.trendz.interceptor.TrackingInterceptor;
import org.thingsboard.trendz.security.entity.AuthType;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.security.entity.TrendzErrorCode;
import org.thingsboard.trendz.security.entity.TrendzErrorResponse;
import org.thingsboard.trendz.security.entity.UserValidationResult;
import org.thingsboard.trendz.security.service.AuthenticationService;
import org.thingsboard.trendz.service.customize.CustomizationService;
import org.thingsboard.trendz.service.customize.UserManagementService;
import org.thingsboard.trendz.service.executor.ExecutorManagementService;
import org.thingsboard.trendz.service.executor.ExecutorName;
import org.thingsboard.trendz.service.provider.cache.CacheConfigurationName;
import org.thingsboard.trendz.service.provider.cache.CacheService;
import org.thingsboard.trendz.service.task.TaskInitializationService;
import org.thingsboard.trendz.tools.json.JsonUtils;

@Component
@Order(value=2)
public class TrackingInterceptor
extends BaseController
implements HandlerInterceptor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TrackingInterceptor.class);
    private final AuthenticationService authenticationService;
    private final UserManagementService userManagementService;
    private final CustomizationService customizationService;
    private final TaskInitializationService taskInitializationService;
    private final ExecutorService trackingExecutor;
    private final Cache userTrackCache;

    public TrackingInterceptor(AuthenticationService authenticationService, UserManagementService userManagementService, CustomizationService customizationService, TaskInitializationService taskInitializationService, ExecutorManagementService executorManagementService, CacheService cacheService) {
        this.authenticationService = authenticationService;
        this.userManagementService = userManagementService;
        this.customizationService = customizationService;
        this.taskInitializationService = taskInitializationService;
        this.trackingExecutor = executorManagementService.getExecutorByName(ExecutorName.TRACKING);
        this.userTrackCache = cacheService.getCache(CacheConfigurationName.userTrackCacheName);
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) {
        AuthType authType = this.getAuthType();
        if (authType == null) {
            return true;
        }
        return switch (1.$SwitchMap$org$thingsboard$trendz$security$entity$AuthType[authType.ordinal()]) {
            default -> throw new IncompatibleClassChangeError();
            case 1 -> this.preHandleJwtToken(request, response);
            case 2 -> this.preHandleTrendzApiKey(request, response);
        };
    }

    private boolean preHandleJwtToken(HttpServletRequest request, HttpServletResponse response) {
        try {
            String jwtToken = this.getJwtToken();
            JwtSecurityUser user = this.getSecurityUser();
            String domain = request.getServerName();
            UserValidationResult result = this.authenticationService.validateToken(jwtToken, user);
            if (!result.isValid()) {
                response.setStatus(401);
                response.setContentType(MediaType.APPLICATION_JSON.toString());
                response.setCharacterEncoding("UTF-8");
                String message = "Jwt token is invalid.";
                TrendzErrorResponse resp = TrendzErrorResponse.of((String)message, (TrendzErrorCode)TrendzErrorCode.PERMISSION_DENIED, (HttpStatus)HttpStatus.UNAUTHORIZED);
                JsonUtils.getObjectMapper().writeValue((Writer)response.getWriter(), (Object)resp);
                return false;
            }
            Future<?> future = this.trackingExecutor.submit(() -> this.trackUser(result.getUsername(), user, domain));
        }
        catch (Exception e) {
            log.error("Error during tracking interceptor job", (Throwable)e);
        }
        return true;
    }

    private boolean preHandleTrendzApiKey(HttpServletRequest request, HttpServletResponse response) {
        try {
            JwtSecurityUser user = this.getSecurityUser();
            String domain = request.getServerName();
            UserValidationResult result = this.authenticationService.validateUser(user);
            if (!result.isValid()) {
                response.setStatus(401);
                response.setContentType(MediaType.APPLICATION_JSON.toString());
                response.setCharacterEncoding("UTF-8");
                String message = "User is invalid.";
                TrendzErrorResponse resp = TrendzErrorResponse.of((String)message, (TrendzErrorCode)TrendzErrorCode.PERMISSION_DENIED, (HttpStatus)HttpStatus.UNAUTHORIZED);
                JsonUtils.getObjectMapper().writeValue((Writer)response.getWriter(), (Object)resp);
                return false;
            }
            Future<?> future = this.trackingExecutor.submit(() -> this.trackUser(result.getUsername(), user, domain));
        }
        catch (Exception e) {
            log.error("Error during tracking interceptor job", (Throwable)e);
        }
        return true;
    }

    private void trackUser(String username, JwtSecurityUser user, String domain) {
        try {
            this.userTrackCache.get((Object)user, () -> {
                this.userManagementService.trackUser(username, user);
                this.customizationService.trackDomain(user, domain);
                this.taskInitializationService.proceedInitialization(user);
                return true;
            });
        }
        catch (Exception e) {
            this.userTrackCache.evict((Object)user);
            log.error("Error during user tracking!", (Throwable)e);
        }
    }
}

