/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.exception.task;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.thingsboard.trendz.exception.measurement.MeasurementException;
import org.thingsboard.trendz.exception.task.TrendzTaskException;
import org.thingsboard.trendz.tools.json.JsonUtils;

public class TaskExecutionException
extends TrendzTaskException {
    public TaskExecutionException(Throwable cause) {
        super("The task execution was finished with the error.", cause);
    }

    public String toString() {
        ArrayNode arrayNode = JsonUtils.getObjectMapper().createArrayNode();
        Throwable prevError = null;
        Throwable currentError = this.getCause();
        while (currentError != null && currentError != prevError) {
            if (currentError instanceof MeasurementException) continue;
            ObjectNode node = JsonUtils.getObjectMapper().createObjectNode();
            node.set("errorClass", JsonUtils.toNodeFromObject((Object)currentError.getClass().getName()));
            node.set("message", JsonUtils.toNodeFromObject((Object)currentError.getMessage()));
            arrayNode.add((JsonNode)node);
            prevError = currentError;
            currentError = currentError.getCause();
        }
        return JsonUtils.fromNodeToRaw((JsonNode)arrayNode);
    }
}

