/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.domain.runtime;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.thingsboard.trendz.domain.definition.entity.field.FieldType;
import org.thingsboard.trendz.domain.runtime.FieldValue;
import org.thingsboard.trendz.domain.runtime.Item;

/*
 * Exception performing whole class analysis ignored.
 */
public class FieldValue {
    private Set<Item> items;
    private FieldType fieldType;
    private Object innerValue;
    private long ts;
    private double avgSum;
    private long avgCount;
    private boolean isAnomaly;

    public FieldValue(FieldValue that) {
        this.items = that.items.stream().map(Item::new).collect(Collectors.toSet());
        this.fieldType = that.fieldType;
        this.innerValue = that.innerValue;
        this.ts = that.ts;
        this.avgSum = that.avgSum;
        this.avgCount = that.avgCount;
        this.isAnomaly = that.isAnomaly;
    }

    public FieldValue(Set<Item> items, FieldType fieldType, Object innerValue, long ts, double avgSum, long avgCount) {
        this.items = items;
        this.fieldType = fieldType;
        this.innerValue = innerValue;
        this.ts = ts;
        this.avgSum = avgSum;
        this.avgCount = avgCount;
    }

    public FieldValue(Set<Item> items, FieldType fieldType, Object innerValue, long ts) {
        this(items, fieldType, innerValue, ts, FieldValue.getNumeric((FieldType)fieldType, (Object)innerValue).orElse(0.0).doubleValue(), 1L);
    }

    public FieldValue(Set<Item> items, FieldType fieldType, Object innerValue) {
        this(items, fieldType, innerValue, 0L);
    }

    public FieldValue(Item item, FieldType fieldType, Object innerValue, long ts) {
        this(Collections.singleton(item), fieldType, innerValue, ts);
    }

    public FieldValue(Item item, FieldType fieldType, Object innerValue) {
        this(Collections.singleton(item), fieldType, innerValue, 0L);
    }

    public Optional<Double> getNumeric() {
        return FieldValue.getNumeric((FieldType)this.fieldType, (Object)this.innerValue);
    }

    public static Optional<Double> getNumeric(FieldType fieldType, Object innerValue) {
        if (fieldType.equals((Object)FieldType.NUMERIC) && innerValue instanceof Number) {
            Number number = (Number)innerValue;
            return Optional.of(number.doubleValue());
        }
        return Optional.empty();
    }

    public boolean fullEquals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FieldValue that = (FieldValue)o;
        return new EqualsBuilder().append((Object)this.items, (Object)that.items).append((Object)this.fieldType, (Object)that.fieldType).append(this.innerValue, that.innerValue).append(this.ts, that.ts).isEquals();
    }

    public static boolean fullEquals(List<FieldValue> l1, List<FieldValue> l2) {
        if (l1 == l2) {
            return true;
        }
        if (l1 == null || l2 == null) {
            return false;
        }
        if (l1.size() != l2.size()) {
            return false;
        }
        for (int i = 0; i < l1.size(); ++i) {
            FieldValue fv2;
            FieldValue fv1 = l1.get(i);
            if (fv1.fullEquals((Object)(fv2 = l2.get(i)))) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FieldValue that = (FieldValue)o;
        return new EqualsBuilder().append((Object)this.fieldType, (Object)that.fieldType).append(this.innerValue, that.innerValue).append(this.ts, that.ts).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.fieldType).append(this.innerValue).append(this.ts).toHashCode();
    }

    @Generated
    public static FieldValueBuilder builder() {
        return new FieldValueBuilder();
    }

    @Generated
    public Set<Item> getItems() {
        return this.items;
    }

    @Generated
    public FieldType getFieldType() {
        return this.fieldType;
    }

    @Generated
    public Object getInnerValue() {
        return this.innerValue;
    }

    @Generated
    public long getTs() {
        return this.ts;
    }

    @Generated
    public double getAvgSum() {
        return this.avgSum;
    }

    @Generated
    public long getAvgCount() {
        return this.avgCount;
    }

    @Generated
    public boolean isAnomaly() {
        return this.isAnomaly;
    }

    @Generated
    public void setItems(Set<Item> items) {
        this.items = items;
    }

    @Generated
    public void setFieldType(FieldType fieldType) {
        this.fieldType = fieldType;
    }

    @Generated
    public void setInnerValue(Object innerValue) {
        this.innerValue = innerValue;
    }

    @Generated
    public void setTs(long ts) {
        this.ts = ts;
    }

    @Generated
    public void setAvgSum(double avgSum) {
        this.avgSum = avgSum;
    }

    @Generated
    public void setAvgCount(long avgCount) {
        this.avgCount = avgCount;
    }

    @Generated
    public void setAnomaly(boolean isAnomaly) {
        this.isAnomaly = isAnomaly;
    }

    @Generated
    public String toString() {
        return "FieldValue(items=" + String.valueOf(this.getItems()) + ", fieldType=" + String.valueOf(this.getFieldType()) + ", innerValue=" + String.valueOf(this.getInnerValue()) + ", ts=" + this.getTs() + ", avgSum=" + this.getAvgSum() + ", avgCount=" + this.getAvgCount() + ", isAnomaly=" + this.isAnomaly() + ")";
    }

    @Generated
    public FieldValue() {
    }

    @Generated
    public FieldValue(Set<Item> items, FieldType fieldType, Object innerValue, long ts, double avgSum, long avgCount, boolean isAnomaly) {
        this.items = items;
        this.fieldType = fieldType;
        this.innerValue = innerValue;
        this.ts = ts;
        this.avgSum = avgSum;
        this.avgCount = avgCount;
        this.isAnomaly = isAnomaly;
    }
}

