/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.domain.definition.view.config;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Sets;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import lombok.Generated;
import org.thingsboard.trendz.domain.definition.migration.TrendzEntity;
import org.thingsboard.trendz.domain.definition.view.config.CacheSettings;
import org.thingsboard.trendz.domain.definition.view.config.DatePickerConfig;
import org.thingsboard.trendz.domain.definition.view.config.RuntimeFilterField;
import org.thingsboard.trendz.domain.definition.view.config.SavingCalculatedTelemetrySettings;
import org.thingsboard.trendz.domain.definition.view.config.ViewConfigDefinition;
import org.thingsboard.trendz.domain.definition.view.config.ViewConfigLite;
import org.thingsboard.trendz.domain.definition.view.config.ViewField;
import org.thingsboard.trendz.domain.definition.view.config.ViewType;
import org.thingsboard.trendz.domain.manual.ManualDataset;
import org.thingsboard.trendz.domain.runtime.Item;
import org.thingsboard.trendz.domain.tb.provider.RequestPriority;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.tools.DateTimeUtils;
import org.thingsboard.trendz.tools.json.JsonUtils;

public class ViewConfig
implements TrendzEntity {
    private UUID id;
    private UUID tenantId;
    private UUID customerId;
    private UUID collectionId;
    private String parentPath;
    private boolean favorite;
    private String name;
    private ViewType viewType;
    private ViewConfigDefinition configDefinition;
    private UUID rootEntityId;
    private UUID rowClickEntityId;
    private UUID selectedFilterViewFieldId;
    private boolean previewRequest;
    private int previewItemCount;
    private CacheSettings cacheSettings;
    private SavingCalculatedTelemetrySettings savingCalculatedTelemetrySettings;
    private long createdAt;
    private long updatedAt;
    @JsonProperty(value="xAxis")
    private List<ViewField> xAxis;
    @JsonProperty(value="yAxis")
    private List<ViewField> yAxis;
    private List<ViewField> series;
    private List<ViewField> hiddenFields;
    private List<RuntimeFilterField> runtimeFilters;
    private JsonNode settings;
    private DatePickerConfig datePickerConfig;
    private String tzName;
    private Map<UUID, Boolean> datasetEnableMap;
    private Map<UUID, Item> datasetItemMap;
    private Map<UUID, ManualDataset> datasetDataMap;
    @JsonIgnore
    private RequestPriority requestPriority;

    public ViewConfig() {
        this.xAxis = new ArrayList();
        this.yAxis = new ArrayList();
        this.series = new ArrayList();
        this.hiddenFields = new ArrayList();
        this.runtimeFilters = new ArrayList();
        this.cacheSettings = CacheSettings.getDefaultSettings();
        this.savingCalculatedTelemetrySettings = SavingCalculatedTelemetrySettings.getDefaultSettings();
        this.settings = new ObjectMapper().createObjectNode();
    }

    public ViewConfig(ViewConfig that) {
        this.id = that.id;
        this.tenantId = that.tenantId;
        this.customerId = that.customerId;
        this.collectionId = that.collectionId;
        this.parentPath = that.parentPath;
        this.favorite = false;
        this.name = that.name;
        this.viewType = that.viewType;
        this.configDefinition = that.configDefinition != null ? new ViewConfigDefinition(that.configDefinition) : null;
        this.rootEntityId = that.rootEntityId;
        this.rowClickEntityId = that.rowClickEntityId;
        this.selectedFilterViewFieldId = that.selectedFilterViewFieldId;
        this.previewRequest = that.previewRequest;
        this.previewItemCount = that.previewItemCount;
        if (that.cacheSettings != null) {
            this.cacheSettings = new CacheSettings(that.cacheSettings);
            this.cacheSettings.setAutoRefreshCache(false);
        }
        if (that.savingCalculatedTelemetrySettings != null) {
            this.savingCalculatedTelemetrySettings = new SavingCalculatedTelemetrySettings(that.savingCalculatedTelemetrySettings);
            this.savingCalculatedTelemetrySettings.setEnable(false);
        }
        this.createdAt = that.createdAt;
        this.updatedAt = that.updatedAt;
        this.datePickerConfig = that.datePickerConfig != null ? new DatePickerConfig(that.datePickerConfig) : null;
        this.tzName = that.tzName;
        this.settings = JsonUtils.toNodeFromRaw((String)JsonUtils.toJson((Object)that.settings));
        this.xAxis = new ArrayList();
        this.yAxis = new ArrayList();
        this.series = new ArrayList();
        this.hiddenFields = new ArrayList();
        this.runtimeFilters = new ArrayList();
        that.xAxis.forEach(viewField -> this.xAxis.add(new ViewField(viewField)));
        that.yAxis.forEach(viewField -> this.yAxis.add(new ViewField(viewField)));
        that.series.forEach(viewField -> this.series.add(new ViewField(viewField)));
        that.hiddenFields.forEach(viewField -> this.hiddenFields.add(new ViewField(viewField)));
        that.runtimeFilters.forEach(filterField -> this.runtimeFilters.add(new RuntimeFilterField(filterField)));
        this.datasetEnableMap = that.datasetEnableMap;
        this.datasetItemMap = that.datasetItemMap;
        this.datasetDataMap = that.datasetDataMap;
        this.requestPriority = that.requestPriority;
    }

    @JsonIgnore
    public Set<UUID> getAllowedEntityIds() {
        HashSet ids = Sets.newHashSet();
        JsonNode settings = this.getSettings();
        JsonNode missedGraphEntities = settings.get("missedGraphEntities");
        if (missedGraphEntities != null && !missedGraphEntities.isMissingNode()) {
            for (JsonNode node : missedGraphEntities) {
                UUID uuid = UUID.fromString(node.textValue());
                ids.add(uuid);
            }
        }
        return ids;
    }

    @JsonIgnore
    public List<ViewField> getAllFields() {
        ArrayList<ViewField> allFields = new ArrayList<ViewField>();
        allFields.addAll(this.getXAxis());
        allFields.addAll(this.getYAxis());
        allFields.addAll(this.getSeries());
        allFields.addAll(this.getHiddenFields());
        return allFields;
    }

    @JsonIgnore
    public ZoneId getZoneId() {
        return DateTimeUtils.fromTzName((String)this.getTzName());
    }

    public static boolean checkUserOwnership(ViewConfig config, JwtSecurityUser user) {
        boolean sameTenant = config.getTenantId().equals(user.getTenantId());
        boolean sameCustomer = config.getCustomerId().equals(user.getCustomerId());
        return sameTenant && sameCustomer;
    }

    public static boolean checkUserOwnership(ViewConfigLite config, JwtSecurityUser user) {
        boolean sameTenant = config.getTenantId().equals(user.getTenantId());
        boolean sameCustomer = config.getCustomerId().equals(user.getCustomerId());
        return sameTenant && sameCustomer;
    }

    @Generated
    public UUID getId() {
        return this.id;
    }

    @Generated
    public UUID getTenantId() {
        return this.tenantId;
    }

    @Generated
    public UUID getCustomerId() {
        return this.customerId;
    }

    @Generated
    public UUID getCollectionId() {
        return this.collectionId;
    }

    @Generated
    public String getParentPath() {
        return this.parentPath;
    }

    @Generated
    public boolean isFavorite() {
        return this.favorite;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public ViewType getViewType() {
        return this.viewType;
    }

    @Generated
    public ViewConfigDefinition getConfigDefinition() {
        return this.configDefinition;
    }

    @Generated
    public UUID getRootEntityId() {
        return this.rootEntityId;
    }

    @Generated
    public UUID getRowClickEntityId() {
        return this.rowClickEntityId;
    }

    @Generated
    public UUID getSelectedFilterViewFieldId() {
        return this.selectedFilterViewFieldId;
    }

    @Generated
    public boolean isPreviewRequest() {
        return this.previewRequest;
    }

    @Generated
    public int getPreviewItemCount() {
        return this.previewItemCount;
    }

    @Generated
    public CacheSettings getCacheSettings() {
        return this.cacheSettings;
    }

    @Generated
    public SavingCalculatedTelemetrySettings getSavingCalculatedTelemetrySettings() {
        return this.savingCalculatedTelemetrySettings;
    }

    @Generated
    public long getCreatedAt() {
        return this.createdAt;
    }

    @Generated
    public long getUpdatedAt() {
        return this.updatedAt;
    }

    @Generated
    public List<ViewField> getXAxis() {
        return this.xAxis;
    }

    @Generated
    public List<ViewField> getYAxis() {
        return this.yAxis;
    }

    @Generated
    public List<ViewField> getSeries() {
        return this.series;
    }

    @Generated
    public List<ViewField> getHiddenFields() {
        return this.hiddenFields;
    }

    @Generated
    public List<RuntimeFilterField> getRuntimeFilters() {
        return this.runtimeFilters;
    }

    @Generated
    public JsonNode getSettings() {
        return this.settings;
    }

    @Generated
    public DatePickerConfig getDatePickerConfig() {
        return this.datePickerConfig;
    }

    @Generated
    public String getTzName() {
        return this.tzName;
    }

    @Generated
    public Map<UUID, Boolean> getDatasetEnableMap() {
        return this.datasetEnableMap;
    }

    @Generated
    public Map<UUID, Item> getDatasetItemMap() {
        return this.datasetItemMap;
    }

    @Generated
    public Map<UUID, ManualDataset> getDatasetDataMap() {
        return this.datasetDataMap;
    }

    @Generated
    public RequestPriority getRequestPriority() {
        return this.requestPriority;
    }

    @Generated
    public void setId(UUID id) {
        this.id = id;
    }

    @Generated
    public void setTenantId(UUID tenantId) {
        this.tenantId = tenantId;
    }

    @Generated
    public void setCustomerId(UUID customerId) {
        this.customerId = customerId;
    }

    @Generated
    public void setCollectionId(UUID collectionId) {
        this.collectionId = collectionId;
    }

    @Generated
    public void setParentPath(String parentPath) {
        this.parentPath = parentPath;
    }

    @Generated
    public void setFavorite(boolean favorite) {
        this.favorite = favorite;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setViewType(ViewType viewType) {
        this.viewType = viewType;
    }

    @Generated
    public void setConfigDefinition(ViewConfigDefinition configDefinition) {
        this.configDefinition = configDefinition;
    }

    @Generated
    public void setRootEntityId(UUID rootEntityId) {
        this.rootEntityId = rootEntityId;
    }

    @Generated
    public void setRowClickEntityId(UUID rowClickEntityId) {
        this.rowClickEntityId = rowClickEntityId;
    }

    @Generated
    public void setSelectedFilterViewFieldId(UUID selectedFilterViewFieldId) {
        this.selectedFilterViewFieldId = selectedFilterViewFieldId;
    }

    @Generated
    public void setPreviewRequest(boolean previewRequest) {
        this.previewRequest = previewRequest;
    }

    @Generated
    public void setPreviewItemCount(int previewItemCount) {
        this.previewItemCount = previewItemCount;
    }

    @Generated
    public void setCacheSettings(CacheSettings cacheSettings) {
        this.cacheSettings = cacheSettings;
    }

    @Generated
    public void setSavingCalculatedTelemetrySettings(SavingCalculatedTelemetrySettings savingCalculatedTelemetrySettings) {
        this.savingCalculatedTelemetrySettings = savingCalculatedTelemetrySettings;
    }

    @Generated
    public void setCreatedAt(long createdAt) {
        this.createdAt = createdAt;
    }

    @Generated
    public void setUpdatedAt(long updatedAt) {
        this.updatedAt = updatedAt;
    }

    @Generated
    public void setXAxis(List<ViewField> xAxis) {
        this.xAxis = xAxis;
    }

    @Generated
    public void setYAxis(List<ViewField> yAxis) {
        this.yAxis = yAxis;
    }

    @Generated
    public void setSeries(List<ViewField> series) {
        this.series = series;
    }

    @Generated
    public void setHiddenFields(List<ViewField> hiddenFields) {
        this.hiddenFields = hiddenFields;
    }

    @Generated
    public void setRuntimeFilters(List<RuntimeFilterField> runtimeFilters) {
        this.runtimeFilters = runtimeFilters;
    }

    @Generated
    public void setSettings(JsonNode settings) {
        this.settings = settings;
    }

    @Generated
    public void setDatePickerConfig(DatePickerConfig datePickerConfig) {
        this.datePickerConfig = datePickerConfig;
    }

    @Generated
    public void setTzName(String tzName) {
        this.tzName = tzName;
    }

    @Generated
    public void setDatasetEnableMap(Map<UUID, Boolean> datasetEnableMap) {
        this.datasetEnableMap = datasetEnableMap;
    }

    @Generated
    public void setDatasetItemMap(Map<UUID, Item> datasetItemMap) {
        this.datasetItemMap = datasetItemMap;
    }

    @Generated
    public void setDatasetDataMap(Map<UUID, ManualDataset> datasetDataMap) {
        this.datasetDataMap = datasetDataMap;
    }

    @Generated
    public void setRequestPriority(RequestPriority requestPriority) {
        this.requestPriority = requestPriority;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ViewConfig)) {
            return false;
        }
        ViewConfig other = (ViewConfig)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.isFavorite() != other.isFavorite()) {
            return false;
        }
        if (this.isPreviewRequest() != other.isPreviewRequest()) {
            return false;
        }
        if (this.getPreviewItemCount() != other.getPreviewItemCount()) {
            return false;
        }
        if (this.getCreatedAt() != other.getCreatedAt()) {
            return false;
        }
        if (this.getUpdatedAt() != other.getUpdatedAt()) {
            return false;
        }
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        UUID this$tenantId = this.getTenantId();
        UUID other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !((Object)this$tenantId).equals(other$tenantId)) {
            return false;
        }
        UUID this$customerId = this.getCustomerId();
        UUID other$customerId = other.getCustomerId();
        if (this$customerId == null ? other$customerId != null : !((Object)this$customerId).equals(other$customerId)) {
            return false;
        }
        UUID this$collectionId = this.getCollectionId();
        UUID other$collectionId = other.getCollectionId();
        if (this$collectionId == null ? other$collectionId != null : !((Object)this$collectionId).equals(other$collectionId)) {
            return false;
        }
        String this$parentPath = this.getParentPath();
        String other$parentPath = other.getParentPath();
        if (this$parentPath == null ? other$parentPath != null : !this$parentPath.equals(other$parentPath)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        ViewType this$viewType = this.getViewType();
        ViewType other$viewType = other.getViewType();
        if (this$viewType == null ? other$viewType != null : !this$viewType.equals(other$viewType)) {
            return false;
        }
        ViewConfigDefinition this$configDefinition = this.getConfigDefinition();
        ViewConfigDefinition other$configDefinition = other.getConfigDefinition();
        if (this$configDefinition == null ? other$configDefinition != null : !this$configDefinition.equals(other$configDefinition)) {
            return false;
        }
        UUID this$rootEntityId = this.getRootEntityId();
        UUID other$rootEntityId = other.getRootEntityId();
        if (this$rootEntityId == null ? other$rootEntityId != null : !((Object)this$rootEntityId).equals(other$rootEntityId)) {
            return false;
        }
        UUID this$rowClickEntityId = this.getRowClickEntityId();
        UUID other$rowClickEntityId = other.getRowClickEntityId();
        if (this$rowClickEntityId == null ? other$rowClickEntityId != null : !((Object)this$rowClickEntityId).equals(other$rowClickEntityId)) {
            return false;
        }
        UUID this$selectedFilterViewFieldId = this.getSelectedFilterViewFieldId();
        UUID other$selectedFilterViewFieldId = other.getSelectedFilterViewFieldId();
        if (this$selectedFilterViewFieldId == null ? other$selectedFilterViewFieldId != null : !((Object)this$selectedFilterViewFieldId).equals(other$selectedFilterViewFieldId)) {
            return false;
        }
        CacheSettings this$cacheSettings = this.getCacheSettings();
        CacheSettings other$cacheSettings = other.getCacheSettings();
        if (this$cacheSettings == null ? other$cacheSettings != null : !this$cacheSettings.equals(other$cacheSettings)) {
            return false;
        }
        SavingCalculatedTelemetrySettings this$savingCalculatedTelemetrySettings = this.getSavingCalculatedTelemetrySettings();
        SavingCalculatedTelemetrySettings other$savingCalculatedTelemetrySettings = other.getSavingCalculatedTelemetrySettings();
        if (this$savingCalculatedTelemetrySettings == null ? other$savingCalculatedTelemetrySettings != null : !this$savingCalculatedTelemetrySettings.equals(other$savingCalculatedTelemetrySettings)) {
            return false;
        }
        List this$xAxis = this.getXAxis();
        List other$xAxis = other.getXAxis();
        if (this$xAxis == null ? other$xAxis != null : !((Object)this$xAxis).equals(other$xAxis)) {
            return false;
        }
        List this$yAxis = this.getYAxis();
        List other$yAxis = other.getYAxis();
        if (this$yAxis == null ? other$yAxis != null : !((Object)this$yAxis).equals(other$yAxis)) {
            return false;
        }
        List this$series = this.getSeries();
        List other$series = other.getSeries();
        if (this$series == null ? other$series != null : !((Object)this$series).equals(other$series)) {
            return false;
        }
        List this$hiddenFields = this.getHiddenFields();
        List other$hiddenFields = other.getHiddenFields();
        if (this$hiddenFields == null ? other$hiddenFields != null : !((Object)this$hiddenFields).equals(other$hiddenFields)) {
            return false;
        }
        List this$runtimeFilters = this.getRuntimeFilters();
        List other$runtimeFilters = other.getRuntimeFilters();
        if (this$runtimeFilters == null ? other$runtimeFilters != null : !((Object)this$runtimeFilters).equals(other$runtimeFilters)) {
            return false;
        }
        JsonNode this$settings = this.getSettings();
        JsonNode other$settings = other.getSettings();
        if (this$settings == null ? other$settings != null : !this$settings.equals(other$settings)) {
            return false;
        }
        DatePickerConfig this$datePickerConfig = this.getDatePickerConfig();
        DatePickerConfig other$datePickerConfig = other.getDatePickerConfig();
        if (this$datePickerConfig == null ? other$datePickerConfig != null : !this$datePickerConfig.equals(other$datePickerConfig)) {
            return false;
        }
        String this$tzName = this.getTzName();
        String other$tzName = other.getTzName();
        if (this$tzName == null ? other$tzName != null : !this$tzName.equals(other$tzName)) {
            return false;
        }
        Map this$datasetEnableMap = this.getDatasetEnableMap();
        Map other$datasetEnableMap = other.getDatasetEnableMap();
        if (this$datasetEnableMap == null ? other$datasetEnableMap != null : !((Object)this$datasetEnableMap).equals(other$datasetEnableMap)) {
            return false;
        }
        Map this$datasetItemMap = this.getDatasetItemMap();
        Map other$datasetItemMap = other.getDatasetItemMap();
        if (this$datasetItemMap == null ? other$datasetItemMap != null : !((Object)this$datasetItemMap).equals(other$datasetItemMap)) {
            return false;
        }
        Map this$datasetDataMap = this.getDatasetDataMap();
        Map other$datasetDataMap = other.getDatasetDataMap();
        if (this$datasetDataMap == null ? other$datasetDataMap != null : !((Object)this$datasetDataMap).equals(other$datasetDataMap)) {
            return false;
        }
        RequestPriority this$requestPriority = this.getRequestPriority();
        RequestPriority other$requestPriority = other.getRequestPriority();
        return !(this$requestPriority == null ? other$requestPriority != null : !this$requestPriority.equals(other$requestPriority));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ViewConfig;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isFavorite() ? 79 : 97);
        result = result * 59 + (this.isPreviewRequest() ? 79 : 97);
        result = result * 59 + this.getPreviewItemCount();
        long $createdAt = this.getCreatedAt();
        result = result * 59 + (int)($createdAt >>> 32 ^ $createdAt);
        long $updatedAt = this.getUpdatedAt();
        result = result * 59 + (int)($updatedAt >>> 32 ^ $updatedAt);
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        UUID $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : ((Object)$tenantId).hashCode());
        UUID $customerId = this.getCustomerId();
        result = result * 59 + ($customerId == null ? 43 : ((Object)$customerId).hashCode());
        UUID $collectionId = this.getCollectionId();
        result = result * 59 + ($collectionId == null ? 43 : ((Object)$collectionId).hashCode());
        String $parentPath = this.getParentPath();
        result = result * 59 + ($parentPath == null ? 43 : $parentPath.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        ViewType $viewType = this.getViewType();
        result = result * 59 + ($viewType == null ? 43 : $viewType.hashCode());
        ViewConfigDefinition $configDefinition = this.getConfigDefinition();
        result = result * 59 + ($configDefinition == null ? 43 : $configDefinition.hashCode());
        UUID $rootEntityId = this.getRootEntityId();
        result = result * 59 + ($rootEntityId == null ? 43 : ((Object)$rootEntityId).hashCode());
        UUID $rowClickEntityId = this.getRowClickEntityId();
        result = result * 59 + ($rowClickEntityId == null ? 43 : ((Object)$rowClickEntityId).hashCode());
        UUID $selectedFilterViewFieldId = this.getSelectedFilterViewFieldId();
        result = result * 59 + ($selectedFilterViewFieldId == null ? 43 : ((Object)$selectedFilterViewFieldId).hashCode());
        CacheSettings $cacheSettings = this.getCacheSettings();
        result = result * 59 + ($cacheSettings == null ? 43 : $cacheSettings.hashCode());
        SavingCalculatedTelemetrySettings $savingCalculatedTelemetrySettings = this.getSavingCalculatedTelemetrySettings();
        result = result * 59 + ($savingCalculatedTelemetrySettings == null ? 43 : $savingCalculatedTelemetrySettings.hashCode());
        List $xAxis = this.getXAxis();
        result = result * 59 + ($xAxis == null ? 43 : ((Object)$xAxis).hashCode());
        List $yAxis = this.getYAxis();
        result = result * 59 + ($yAxis == null ? 43 : ((Object)$yAxis).hashCode());
        List $series = this.getSeries();
        result = result * 59 + ($series == null ? 43 : ((Object)$series).hashCode());
        List $hiddenFields = this.getHiddenFields();
        result = result * 59 + ($hiddenFields == null ? 43 : ((Object)$hiddenFields).hashCode());
        List $runtimeFilters = this.getRuntimeFilters();
        result = result * 59 + ($runtimeFilters == null ? 43 : ((Object)$runtimeFilters).hashCode());
        JsonNode $settings = this.getSettings();
        result = result * 59 + ($settings == null ? 43 : $settings.hashCode());
        DatePickerConfig $datePickerConfig = this.getDatePickerConfig();
        result = result * 59 + ($datePickerConfig == null ? 43 : $datePickerConfig.hashCode());
        String $tzName = this.getTzName();
        result = result * 59 + ($tzName == null ? 43 : $tzName.hashCode());
        Map $datasetEnableMap = this.getDatasetEnableMap();
        result = result * 59 + ($datasetEnableMap == null ? 43 : ((Object)$datasetEnableMap).hashCode());
        Map $datasetItemMap = this.getDatasetItemMap();
        result = result * 59 + ($datasetItemMap == null ? 43 : ((Object)$datasetItemMap).hashCode());
        Map $datasetDataMap = this.getDatasetDataMap();
        result = result * 59 + ($datasetDataMap == null ? 43 : ((Object)$datasetDataMap).hashCode());
        RequestPriority $requestPriority = this.getRequestPriority();
        result = result * 59 + ($requestPriority == null ? 43 : $requestPriority.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ViewConfig(id=" + String.valueOf(this.getId()) + ", tenantId=" + String.valueOf(this.getTenantId()) + ", customerId=" + String.valueOf(this.getCustomerId()) + ", collectionId=" + String.valueOf(this.getCollectionId()) + ", parentPath=" + this.getParentPath() + ", favorite=" + this.isFavorite() + ", name=" + this.getName() + ", viewType=" + String.valueOf(this.getViewType()) + ", configDefinition=" + String.valueOf(this.getConfigDefinition()) + ", rootEntityId=" + String.valueOf(this.getRootEntityId()) + ", rowClickEntityId=" + String.valueOf(this.getRowClickEntityId()) + ", selectedFilterViewFieldId=" + String.valueOf(this.getSelectedFilterViewFieldId()) + ", previewRequest=" + this.isPreviewRequest() + ", previewItemCount=" + this.getPreviewItemCount() + ", cacheSettings=" + String.valueOf(this.getCacheSettings()) + ", savingCalculatedTelemetrySettings=" + String.valueOf(this.getSavingCalculatedTelemetrySettings()) + ", createdAt=" + this.getCreatedAt() + ", updatedAt=" + this.getUpdatedAt() + ", xAxis=" + String.valueOf(this.getXAxis()) + ", yAxis=" + String.valueOf(this.getYAxis()) + ", series=" + String.valueOf(this.getSeries()) + ", hiddenFields=" + String.valueOf(this.getHiddenFields()) + ", runtimeFilters=" + String.valueOf(this.getRuntimeFilters()) + ", settings=" + String.valueOf(this.getSettings()) + ", datePickerConfig=" + String.valueOf(this.getDatePickerConfig()) + ", tzName=" + this.getTzName() + ", datasetEnableMap=" + String.valueOf(this.getDatasetEnableMap()) + ", datasetItemMap=" + String.valueOf(this.getDatasetItemMap()) + ", datasetDataMap=" + String.valueOf(this.getDatasetDataMap()) + ", requestPriority=" + String.valueOf(this.getRequestPriority()) + ")";
    }
}

