/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.domain.definition.view.config;

import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.WeekFields;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.trendz.domain.definition.view.config.DateAggregationType;
import org.thingsboard.trendz.domain.definition.view.config.DateAggregationUnit;
import org.thingsboard.trendz.domain.definition.view.config.ViewField;
import org.thingsboard.trendz.exception.TrendzInternalException;
import org.thingsboard.trendz.tools.DateTimeUtils;

public enum DateAggregationType {
    RAW("H"),
    FULL_MINUTE("yyyy-MM-dd HH:mm"),
    MINUTE("mm"),
    FULL_HOUR("yyyy-MM-dd HH"),
    HOUR("HH"),
    FULL_DATE("yyyy-MM-dd"),
    DAY("e"),
    DATE("dd"),
    START_OF_WEEK("yyyy-MM-dd"),
    WEEK_OF_YEAR("ww"),
    WEEK_OF_MONTH("W"),
    MONTH("MM"),
    YEARMONTH("yyyy-MMM"),
    QUARTER("'Q'Q"),
    FULL_QUARTER("yyyy-'Q'Q"),
    YEAR("yyyy");

    @Generated
    private static final Logger log;
    private static final Set<DateAggregationType> notLoadableAggregations;
    private static final Set<DateAggregationType> dateTimeSet;
    private final DateTimeFormatter formatter;

    private DateAggregationType(String pattern) {
        this.formatter = new DateTimeFormatterBuilder().appendPattern(pattern).parseDefaulting(ChronoField.DAY_OF_MONTH, 1L).parseDefaulting(ChronoField.MONTH_OF_YEAR, 1L).toFormatter(Locale.getDefault());
    }

    public boolean isCyclic() {
        return switch (1.$SwitchMap$org$thingsboard$trendz$domain$definition$view$config$DateAggregationType[this.ordinal()]) {
            case 1, 2, 3, 4, 5, 6, 7, 8 -> true;
            default -> false;
        };
    }

    public String apply(long ts, ZoneId zoneId) {
        if (this == RAW) {
            return "" + ts;
        }
        ZonedDateTime date = DateTimeUtils.fromTs((long)ts, (ZoneId)zoneId);
        Object formatted = switch (1.$SwitchMap$org$thingsboard$trendz$domain$definition$view$config$DateAggregationType[this.ordinal()]) {
            case 9 -> DateTimeUtils.extendedTruncateTo((ZonedDateTime)date, (ChronoUnit)ChronoUnit.WEEKS).format(this.formatter);
            case 5 -> "" + date.get(WeekFields.of(DayOfWeek.MONDAY, 1).weekOfYear());
            case 6 -> "" + date.get(WeekFields.of(DayOfWeek.MONDAY, 1).weekOfMonth());
            case 3 -> "" + date.get(ChronoField.DAY_OF_WEEK);
            default -> date.format(this.formatter);
        };
        log.trace("Input date = {}, formatted = {}", (Object)date, formatted);
        return formatted;
    }

    public long apply(String date, ZoneId zoneId) {
        LocalDateTime result;
        if (FULL_QUARTER.equals((Object)this)) {
            String[] parts = date.split("-Q");
            int year = Integer.parseInt(parts[0]);
            int quarter = Integer.parseInt(parts[1]);
            int month = (quarter - 1) * 3 + 1;
            result = LocalDateTime.of(year, month, 1, 0, 0);
        } else {
            result = dateTimeSet.contains(this) ? LocalDateTime.parse(date, this.formatter) : LocalDate.parse(date, this.formatter).atStartOfDay();
        }
        return result.atZone(zoneId).toInstant().toEpochMilli();
    }

    public DateAggregationUnit mapToUnit() {
        return switch (1.$SwitchMap$org$thingsboard$trendz$domain$definition$view$config$DateAggregationType[this.ordinal()]) {
            default -> throw new IncompatibleClassChangeError();
            case 1, 10 -> DateAggregationUnit.MINUTE;
            case 2, 11 -> DateAggregationUnit.HOUR;
            case 3, 4, 5, 6, 12 -> DateAggregationUnit.DAY;
            case 9 -> DateAggregationUnit.WEEK;
            case 7, 13 -> DateAggregationUnit.MONTH;
            case 8, 14 -> DateAggregationUnit.QUARTER;
            case 15 -> DateAggregationUnit.YEAR;
            case 16 -> throw new IllegalArgumentException("Unsupported DateAggregationType: " + String.valueOf(this));
        };
    }

    public List<ViewField> getCachingDateAggregationFieldList() {
        ViewField viewField = new ViewField();
        viewField.setVirtualDateField(true);
        viewField.setDateGrouping(this);
        return Collections.singletonList(viewField);
    }

    public static DateAggregationType getAggregationTypeForRange(long startTs, long endTs) {
        long deltaMillis = endTs - startTs;
        if (deltaMillis < ChronoUnit.HOURS.getDuration().toMillis()) {
            return MINUTE;
        }
        if (deltaMillis < ChronoUnit.DAYS.getDuration().toMillis()) {
            return HOUR;
        }
        if (deltaMillis < ChronoUnit.WEEKS.getDuration().toMillis()) {
            return DAY;
        }
        if (deltaMillis < ChronoUnit.MONTHS.getDuration().toMillis()) {
            return WEEK_OF_MONTH;
        }
        return MONTH;
    }

    public static DateAggregationType getDateGroupingFromPicker(String rangeBy) {
        if (StringUtils.isNotBlank((CharSequence)rangeBy)) {
            return switch (rangeBy) {
                case "minute" -> FULL_MINUTE;
                case "hour" -> FULL_HOUR;
                case "day" -> FULL_DATE;
                case "week" -> START_OF_WEEK;
                case "month" -> YEARMONTH;
                case "year" -> YEAR;
                default -> throw new IllegalArgumentException("Can't define date grouping");
            };
        }
        throw new IllegalArgumentException("Can't define date grouping");
    }

    public static String getPickerFromGrouping(DateAggregationType type) {
        if (type != null) {
            return switch (1.$SwitchMap$org$thingsboard$trendz$domain$definition$view$config$DateAggregationType[type.ordinal()]) {
                case 1, 10 -> "minute";
                case 2, 11 -> "hour";
                case 3, 4, 5, 6, 12 -> "day";
                case 9 -> "week";
                case 7, 8, 13, 14 -> "month";
                case 15 -> "year";
                default -> throw new IllegalArgumentException("Can't define date grouping");
            };
        }
        throw new IllegalArgumentException("Can't define date grouping");
    }

    public static ChronoUnit mapDateAggregationToChronoUnit(DateAggregationType dateAggregationType) {
        return switch (1.$SwitchMap$org$thingsboard$trendz$domain$definition$view$config$DateAggregationType[dateAggregationType.ordinal()]) {
            default -> throw new IncompatibleClassChangeError();
            case 1, 10 -> ChronoUnit.MINUTES;
            case 2, 11 -> ChronoUnit.HOURS;
            case 3, 4, 5, 6, 12 -> ChronoUnit.DAYS;
            case 9 -> ChronoUnit.WEEKS;
            case 7, 8, 13, 14 -> ChronoUnit.MONTHS;
            case 15 -> ChronoUnit.YEARS;
            case 16 -> throw new IllegalArgumentException("DateAggregationType is not supported: " + String.valueOf(dateAggregationType));
        };
    }

    public static DateAggregationType getFullType(DateAggregationType type) {
        if (type == null) {
            return null;
        }
        return switch (1.$SwitchMap$org$thingsboard$trendz$domain$definition$view$config$DateAggregationType[type.ordinal()]) {
            case 1, 10 -> FULL_MINUTE;
            case 2, 11 -> FULL_HOUR;
            case 3, 4, 5, 6, 12 -> FULL_DATE;
            case 9 -> START_OF_WEEK;
            case 7, 13 -> YEARMONTH;
            case 8, 14 -> FULL_QUARTER;
            case 15 -> YEAR;
            default -> throw new IllegalArgumentException("Unsupported DateAggregationType: " + String.valueOf(type));
        };
    }

    public static boolean isNotLoadableAggregationType(DateAggregationType type) {
        if (type == null) {
            return false;
        }
        return notLoadableAggregations.contains(type);
    }

    public static DateAggregationType mapUnitToType(DateAggregationUnit unit, boolean isCyclic) {
        if (isCyclic) {
            return switch (1.$SwitchMap$org$thingsboard$trendz$domain$definition$view$config$DateAggregationUnit[unit.ordinal()]) {
                case 1 -> MINUTE;
                case 2 -> HOUR;
                case 3 -> DAY;
                case 4 -> WEEK_OF_MONTH;
                case 5 -> MONTH;
                case 6 -> QUARTER;
                default -> throw new TrendzInternalException("Unsupported time unit: " + String.valueOf(unit));
            };
        }
        return switch (1.$SwitchMap$org$thingsboard$trendz$domain$definition$view$config$DateAggregationUnit[unit.ordinal()]) {
            case 1 -> FULL_MINUTE;
            case 2 -> FULL_HOUR;
            case 3 -> FULL_DATE;
            case 4 -> START_OF_WEEK;
            case 5 -> YEARMONTH;
            case 6 -> FULL_QUARTER;
            case 7 -> YEAR;
            default -> throw new TrendzInternalException("Unsupported time unit: " + String.valueOf(unit));
        };
    }

    static {
        log = LoggerFactory.getLogger(DateAggregationType.class);
        notLoadableAggregations = Set.of(RAW, MINUTE);
        dateTimeSet = Set.of(FULL_MINUTE, MINUTE, FULL_HOUR, HOUR);
    }
}

