/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.domain.definition.calculation;

import java.time.temporal.ChronoUnit;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Stream;
import lombok.Generated;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.trendz.domain.definition.calculation.CalculationField;
import org.thingsboard.trendz.domain.definition.calculation.CalculationFieldTimeRangeStrategy;
import org.thingsboard.trendz.domain.definition.calculation.CalculationFieldType;
import org.thingsboard.trendz.domain.definition.entity.field.FieldType;
import org.thingsboard.trendz.domain.definition.migration.TrendzEntity;
import org.thingsboard.trendz.domain.definition.view.FieldAggregation;
import org.thingsboard.trendz.domain.definition.view.config.DateAggregationType;
import org.thingsboard.trendz.domain.definition.view.config.DateAggregationUnit;
import org.thingsboard.trendz.domain.definition.view.config.DatePickerConfig;
import org.thingsboard.trendz.domain.definition.view.config.ScriptLanguage;
import org.thingsboard.trendz.domain.manual.ManualDataset;
import org.thingsboard.trendz.exception.calculation.TrendzCalculationFieldException;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.service.view.proto.FillGapSettings;

public class CalculationField
implements TrendzEntity {
    private UUID id;
    private UUID tenantId;
    private UUID customerId;
    private boolean enabled;
    private String name;
    private long creationTime;
    private long updateTime;
    private UUID businessEntityId;
    private UUID associatedEntityFieldId;
    private ScriptLanguage language;
    private CalculationFieldType calculationFieldType;
    private FieldType returnDataType;
    private String groupingInterval;
    private FieldAggregation fieldAggregation;
    private FillGapSettings fillGapSettings;
    private String tbTelemetryKey;
    private String script;
    private CalculationFieldTimeRangeStrategy timeRangeStrategy;
    private DatePickerConfig fixedStrategyDatePicker;
    private ManualDataset manualDataset;
    private boolean splitTimeRange;
    private DateAggregationUnit splitTimeRangeTimeUnit;

    public CalculationField(CalculationField that) {
        this.id = that.id;
        this.tenantId = that.tenantId;
        this.customerId = that.customerId;
        this.enabled = that.enabled;
        this.name = that.name;
        this.creationTime = that.creationTime;
        this.updateTime = that.updateTime;
        this.businessEntityId = that.businessEntityId;
        this.associatedEntityFieldId = that.associatedEntityFieldId;
        this.language = that.language;
        this.calculationFieldType = that.calculationFieldType;
        this.returnDataType = that.returnDataType;
        this.groupingInterval = that.groupingInterval;
        this.fieldAggregation = that.fieldAggregation;
        this.fillGapSettings = that.fillGapSettings == null ? null : new FillGapSettings(that.fillGapSettings);
        this.tbTelemetryKey = that.tbTelemetryKey;
        this.script = that.script;
        this.timeRangeStrategy = that.timeRangeStrategy;
        this.fixedStrategyDatePicker = that.fixedStrategyDatePicker == null ? null : new DatePickerConfig(that.fixedStrategyDatePicker);
        this.manualDataset = that.manualDataset == null ? null : new ManualDataset(that.manualDataset);
        this.splitTimeRange = that.splitTimeRange;
        this.splitTimeRangeTimeUnit = that.splitTimeRangeTimeUnit;
    }

    public static boolean checkUserOwnership(CalculationField field, JwtSecurityUser user) {
        boolean sameTenant = field.getTenantId().equals(user.getTenantId());
        boolean sameCustomer = field.getCustomerId().equals(user.getCustomerId());
        return sameTenant && sameCustomer;
    }

    public static boolean checkUserAccess(CalculationField field, JwtSecurityUser user) {
        boolean sameTenant = field.getTenantId().equals(user.getTenantId());
        boolean sameCustomer = field.getCustomerId().equals(user.getCustomerId());
        if (user.isCustomerUser()) {
            return sameTenant && sameCustomer;
        }
        return sameTenant;
    }

    public static boolean checkSameOwnership(CalculationField o1, CalculationField o2) {
        boolean sameTenant = o1.getTenantId().equals(o2.getTenantId());
        boolean sameCustomer = o1.getCustomerId().equals(o2.getCustomerId());
        return sameTenant && sameCustomer;
    }

    public void validateField() {
        String errOrNull = Stream.of(this.errorMsgOrNull(this.getTenantId() != null && !EntityId.NULL_UUID.equals(this.getTenantId()), "access error"), this.errorMsgOrNull(this.getCustomerId() != null, "access error"), this.errorMsgOrNull(this.getName() != null, "empty name"), this.errorMsgOrNull(this.getBusinessEntityId() != null, "empty business entity id"), this.errorMsgOrNull(this.getLanguage() != null, "no script language"), this.errorMsgOrNull(this.getCalculationFieldType() != null, "no field type"), this.errorMsgOrNull(this.getReturnDataType() != null, "no return date type"), this.errorMsgOrNull(this.getGroupingInterval() != null, "no grouping interval"), this.errorMsgOrNull(this.getFieldAggregation() != null, "no field aggregation"), this.errorMsgOrNull(this.getFillGapSettings() != null, "no fill gap settings"), this.errorMsgOrNull(this.getTbTelemetryKey() != null, "no tb telemetry key"), this.errorMsgOrNull(this.getScript() != null, "no script"), this.errorMsgOrNull(this.getManualDataset() != null, "no manual dataset"), this.errorMsgOrNull(this.getManualDataset().getData() != null, "no manual dataset data")).filter(Objects::nonNull).findFirst().orElse(null);
        if (errOrNull != null && this.calculationFieldType == CalculationFieldType.NATIVE) {
            if (this.timeRangeStrategy == CalculationFieldTimeRangeStrategy.DYNAMIC) {
                errOrNull = "DYNAMIC time range strategy is not supported by native calculation fields";
            } else if (this.language == ScriptLanguage.JS) {
                errOrNull = "JS language is not supported by native calculation fields";
            }
        }
        if (Objects.nonNull(errOrNull)) {
            throw new TrendzCalculationFieldException("Given calculation field is not valid: " + errOrNull);
        }
        if (this.splitTimeRange) {
            boolean less;
            if (this.splitTimeRangeTimeUnit == null) {
                throw new TrendzCalculationFieldException("Split Time-range unit field is not valid");
            }
            ChronoUnit splitUnit = this.splitTimeRangeTimeUnit.mapToChronoUnit();
            ChronoUnit groupingUnit = DateAggregationType.mapDateAggregationToChronoUnit((DateAggregationType)DateAggregationType.getDateGroupingFromPicker((String)this.groupingInterval));
            boolean bl = less = splitUnit.getDuration().compareTo(groupingUnit.getDuration()) < 0;
            if (less) {
                throw new TrendzCalculationFieldException("Split Time-range can not be less than grouping Time-range unit");
            }
        }
    }

    private String errorMsgOrNull(boolean isOk, String errMsg) {
        return isOk ? null : errMsg;
    }

    @Generated
    public static CalculationFieldBuilder builder() {
        return new CalculationFieldBuilder();
    }

    @Generated
    public UUID getId() {
        return this.id;
    }

    @Generated
    public UUID getTenantId() {
        return this.tenantId;
    }

    @Generated
    public UUID getCustomerId() {
        return this.customerId;
    }

    @Generated
    public boolean isEnabled() {
        return this.enabled;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public long getCreationTime() {
        return this.creationTime;
    }

    @Generated
    public long getUpdateTime() {
        return this.updateTime;
    }

    @Generated
    public UUID getBusinessEntityId() {
        return this.businessEntityId;
    }

    @Generated
    public UUID getAssociatedEntityFieldId() {
        return this.associatedEntityFieldId;
    }

    @Generated
    public ScriptLanguage getLanguage() {
        return this.language;
    }

    @Generated
    public CalculationFieldType getCalculationFieldType() {
        return this.calculationFieldType;
    }

    @Generated
    public FieldType getReturnDataType() {
        return this.returnDataType;
    }

    @Generated
    public String getGroupingInterval() {
        return this.groupingInterval;
    }

    @Generated
    public FieldAggregation getFieldAggregation() {
        return this.fieldAggregation;
    }

    @Generated
    public FillGapSettings getFillGapSettings() {
        return this.fillGapSettings;
    }

    @Generated
    public String getTbTelemetryKey() {
        return this.tbTelemetryKey;
    }

    @Generated
    public String getScript() {
        return this.script;
    }

    @Generated
    public CalculationFieldTimeRangeStrategy getTimeRangeStrategy() {
        return this.timeRangeStrategy;
    }

    @Generated
    public DatePickerConfig getFixedStrategyDatePicker() {
        return this.fixedStrategyDatePicker;
    }

    @Generated
    public ManualDataset getManualDataset() {
        return this.manualDataset;
    }

    @Generated
    public boolean isSplitTimeRange() {
        return this.splitTimeRange;
    }

    @Generated
    public DateAggregationUnit getSplitTimeRangeTimeUnit() {
        return this.splitTimeRangeTimeUnit;
    }

    @Generated
    public void setId(UUID id) {
        this.id = id;
    }

    @Generated
    public void setTenantId(UUID tenantId) {
        this.tenantId = tenantId;
    }

    @Generated
    public void setCustomerId(UUID customerId) {
        this.customerId = customerId;
    }

    @Generated
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setCreationTime(long creationTime) {
        this.creationTime = creationTime;
    }

    @Generated
    public void setUpdateTime(long updateTime) {
        this.updateTime = updateTime;
    }

    @Generated
    public void setBusinessEntityId(UUID businessEntityId) {
        this.businessEntityId = businessEntityId;
    }

    @Generated
    public void setAssociatedEntityFieldId(UUID associatedEntityFieldId) {
        this.associatedEntityFieldId = associatedEntityFieldId;
    }

    @Generated
    public void setLanguage(ScriptLanguage language) {
        this.language = language;
    }

    @Generated
    public void setCalculationFieldType(CalculationFieldType calculationFieldType) {
        this.calculationFieldType = calculationFieldType;
    }

    @Generated
    public void setReturnDataType(FieldType returnDataType) {
        this.returnDataType = returnDataType;
    }

    @Generated
    public void setGroupingInterval(String groupingInterval) {
        this.groupingInterval = groupingInterval;
    }

    @Generated
    public void setFieldAggregation(FieldAggregation fieldAggregation) {
        this.fieldAggregation = fieldAggregation;
    }

    @Generated
    public void setFillGapSettings(FillGapSettings fillGapSettings) {
        this.fillGapSettings = fillGapSettings;
    }

    @Generated
    public void setTbTelemetryKey(String tbTelemetryKey) {
        this.tbTelemetryKey = tbTelemetryKey;
    }

    @Generated
    public void setScript(String script) {
        this.script = script;
    }

    @Generated
    public void setTimeRangeStrategy(CalculationFieldTimeRangeStrategy timeRangeStrategy) {
        this.timeRangeStrategy = timeRangeStrategy;
    }

    @Generated
    public void setFixedStrategyDatePicker(DatePickerConfig fixedStrategyDatePicker) {
        this.fixedStrategyDatePicker = fixedStrategyDatePicker;
    }

    @Generated
    public void setManualDataset(ManualDataset manualDataset) {
        this.manualDataset = manualDataset;
    }

    @Generated
    public void setSplitTimeRange(boolean splitTimeRange) {
        this.splitTimeRange = splitTimeRange;
    }

    @Generated
    public void setSplitTimeRangeTimeUnit(DateAggregationUnit splitTimeRangeTimeUnit) {
        this.splitTimeRangeTimeUnit = splitTimeRangeTimeUnit;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CalculationField)) {
            return false;
        }
        CalculationField other = (CalculationField)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.isEnabled() != other.isEnabled()) {
            return false;
        }
        if (this.getCreationTime() != other.getCreationTime()) {
            return false;
        }
        if (this.getUpdateTime() != other.getUpdateTime()) {
            return false;
        }
        if (this.isSplitTimeRange() != other.isSplitTimeRange()) {
            return false;
        }
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        UUID this$tenantId = this.getTenantId();
        UUID other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !((Object)this$tenantId).equals(other$tenantId)) {
            return false;
        }
        UUID this$customerId = this.getCustomerId();
        UUID other$customerId = other.getCustomerId();
        if (this$customerId == null ? other$customerId != null : !((Object)this$customerId).equals(other$customerId)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        UUID this$businessEntityId = this.getBusinessEntityId();
        UUID other$businessEntityId = other.getBusinessEntityId();
        if (this$businessEntityId == null ? other$businessEntityId != null : !((Object)this$businessEntityId).equals(other$businessEntityId)) {
            return false;
        }
        UUID this$associatedEntityFieldId = this.getAssociatedEntityFieldId();
        UUID other$associatedEntityFieldId = other.getAssociatedEntityFieldId();
        if (this$associatedEntityFieldId == null ? other$associatedEntityFieldId != null : !((Object)this$associatedEntityFieldId).equals(other$associatedEntityFieldId)) {
            return false;
        }
        ScriptLanguage this$language = this.getLanguage();
        ScriptLanguage other$language = other.getLanguage();
        if (this$language == null ? other$language != null : !this$language.equals(other$language)) {
            return false;
        }
        CalculationFieldType this$calculationFieldType = this.getCalculationFieldType();
        CalculationFieldType other$calculationFieldType = other.getCalculationFieldType();
        if (this$calculationFieldType == null ? other$calculationFieldType != null : !this$calculationFieldType.equals(other$calculationFieldType)) {
            return false;
        }
        FieldType this$returnDataType = this.getReturnDataType();
        FieldType other$returnDataType = other.getReturnDataType();
        if (this$returnDataType == null ? other$returnDataType != null : !this$returnDataType.equals(other$returnDataType)) {
            return false;
        }
        String this$groupingInterval = this.getGroupingInterval();
        String other$groupingInterval = other.getGroupingInterval();
        if (this$groupingInterval == null ? other$groupingInterval != null : !this$groupingInterval.equals(other$groupingInterval)) {
            return false;
        }
        FieldAggregation this$fieldAggregation = this.getFieldAggregation();
        FieldAggregation other$fieldAggregation = other.getFieldAggregation();
        if (this$fieldAggregation == null ? other$fieldAggregation != null : !this$fieldAggregation.equals(other$fieldAggregation)) {
            return false;
        }
        FillGapSettings this$fillGapSettings = this.getFillGapSettings();
        FillGapSettings other$fillGapSettings = other.getFillGapSettings();
        if (this$fillGapSettings == null ? other$fillGapSettings != null : !this$fillGapSettings.equals(other$fillGapSettings)) {
            return false;
        }
        String this$tbTelemetryKey = this.getTbTelemetryKey();
        String other$tbTelemetryKey = other.getTbTelemetryKey();
        if (this$tbTelemetryKey == null ? other$tbTelemetryKey != null : !this$tbTelemetryKey.equals(other$tbTelemetryKey)) {
            return false;
        }
        String this$script = this.getScript();
        String other$script = other.getScript();
        if (this$script == null ? other$script != null : !this$script.equals(other$script)) {
            return false;
        }
        CalculationFieldTimeRangeStrategy this$timeRangeStrategy = this.getTimeRangeStrategy();
        CalculationFieldTimeRangeStrategy other$timeRangeStrategy = other.getTimeRangeStrategy();
        if (this$timeRangeStrategy == null ? other$timeRangeStrategy != null : !this$timeRangeStrategy.equals(other$timeRangeStrategy)) {
            return false;
        }
        DatePickerConfig this$fixedStrategyDatePicker = this.getFixedStrategyDatePicker();
        DatePickerConfig other$fixedStrategyDatePicker = other.getFixedStrategyDatePicker();
        if (this$fixedStrategyDatePicker == null ? other$fixedStrategyDatePicker != null : !this$fixedStrategyDatePicker.equals(other$fixedStrategyDatePicker)) {
            return false;
        }
        ManualDataset this$manualDataset = this.getManualDataset();
        ManualDataset other$manualDataset = other.getManualDataset();
        if (this$manualDataset == null ? other$manualDataset != null : !this$manualDataset.equals(other$manualDataset)) {
            return false;
        }
        DateAggregationUnit this$splitTimeRangeTimeUnit = this.getSplitTimeRangeTimeUnit();
        DateAggregationUnit other$splitTimeRangeTimeUnit = other.getSplitTimeRangeTimeUnit();
        return !(this$splitTimeRangeTimeUnit == null ? other$splitTimeRangeTimeUnit != null : !this$splitTimeRangeTimeUnit.equals(other$splitTimeRangeTimeUnit));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CalculationField;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEnabled() ? 79 : 97);
        long $creationTime = this.getCreationTime();
        result = result * 59 + (int)($creationTime >>> 32 ^ $creationTime);
        long $updateTime = this.getUpdateTime();
        result = result * 59 + (int)($updateTime >>> 32 ^ $updateTime);
        result = result * 59 + (this.isSplitTimeRange() ? 79 : 97);
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        UUID $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : ((Object)$tenantId).hashCode());
        UUID $customerId = this.getCustomerId();
        result = result * 59 + ($customerId == null ? 43 : ((Object)$customerId).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        UUID $businessEntityId = this.getBusinessEntityId();
        result = result * 59 + ($businessEntityId == null ? 43 : ((Object)$businessEntityId).hashCode());
        UUID $associatedEntityFieldId = this.getAssociatedEntityFieldId();
        result = result * 59 + ($associatedEntityFieldId == null ? 43 : ((Object)$associatedEntityFieldId).hashCode());
        ScriptLanguage $language = this.getLanguage();
        result = result * 59 + ($language == null ? 43 : $language.hashCode());
        CalculationFieldType $calculationFieldType = this.getCalculationFieldType();
        result = result * 59 + ($calculationFieldType == null ? 43 : $calculationFieldType.hashCode());
        FieldType $returnDataType = this.getReturnDataType();
        result = result * 59 + ($returnDataType == null ? 43 : $returnDataType.hashCode());
        String $groupingInterval = this.getGroupingInterval();
        result = result * 59 + ($groupingInterval == null ? 43 : $groupingInterval.hashCode());
        FieldAggregation $fieldAggregation = this.getFieldAggregation();
        result = result * 59 + ($fieldAggregation == null ? 43 : $fieldAggregation.hashCode());
        FillGapSettings $fillGapSettings = this.getFillGapSettings();
        result = result * 59 + ($fillGapSettings == null ? 43 : $fillGapSettings.hashCode());
        String $tbTelemetryKey = this.getTbTelemetryKey();
        result = result * 59 + ($tbTelemetryKey == null ? 43 : $tbTelemetryKey.hashCode());
        String $script = this.getScript();
        result = result * 59 + ($script == null ? 43 : $script.hashCode());
        CalculationFieldTimeRangeStrategy $timeRangeStrategy = this.getTimeRangeStrategy();
        result = result * 59 + ($timeRangeStrategy == null ? 43 : $timeRangeStrategy.hashCode());
        DatePickerConfig $fixedStrategyDatePicker = this.getFixedStrategyDatePicker();
        result = result * 59 + ($fixedStrategyDatePicker == null ? 43 : $fixedStrategyDatePicker.hashCode());
        ManualDataset $manualDataset = this.getManualDataset();
        result = result * 59 + ($manualDataset == null ? 43 : $manualDataset.hashCode());
        DateAggregationUnit $splitTimeRangeTimeUnit = this.getSplitTimeRangeTimeUnit();
        result = result * 59 + ($splitTimeRangeTimeUnit == null ? 43 : $splitTimeRangeTimeUnit.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "CalculationField(id=" + String.valueOf(this.getId()) + ", tenantId=" + String.valueOf(this.getTenantId()) + ", customerId=" + String.valueOf(this.getCustomerId()) + ", enabled=" + this.isEnabled() + ", name=" + this.getName() + ", creationTime=" + this.getCreationTime() + ", updateTime=" + this.getUpdateTime() + ", businessEntityId=" + String.valueOf(this.getBusinessEntityId()) + ", associatedEntityFieldId=" + String.valueOf(this.getAssociatedEntityFieldId()) + ", language=" + String.valueOf(this.getLanguage()) + ", calculationFieldType=" + String.valueOf(this.getCalculationFieldType()) + ", returnDataType=" + String.valueOf(this.getReturnDataType()) + ", groupingInterval=" + this.getGroupingInterval() + ", fieldAggregation=" + String.valueOf(this.getFieldAggregation()) + ", fillGapSettings=" + String.valueOf(this.getFillGapSettings()) + ", tbTelemetryKey=" + this.getTbTelemetryKey() + ", script=" + this.getScript() + ", timeRangeStrategy=" + String.valueOf(this.getTimeRangeStrategy()) + ", fixedStrategyDatePicker=" + String.valueOf(this.getFixedStrategyDatePicker()) + ", manualDataset=" + String.valueOf(this.getManualDataset()) + ", splitTimeRange=" + this.isSplitTimeRange() + ", splitTimeRangeTimeUnit=" + String.valueOf(this.getSplitTimeRangeTimeUnit()) + ")";
    }

    @Generated
    public CalculationField() {
    }

    @Generated
    public CalculationField(UUID id, UUID tenantId, UUID customerId, boolean enabled, String name, long creationTime, long updateTime, UUID businessEntityId, UUID associatedEntityFieldId, ScriptLanguage language, CalculationFieldType calculationFieldType, FieldType returnDataType, String groupingInterval, FieldAggregation fieldAggregation, FillGapSettings fillGapSettings, String tbTelemetryKey, String script, CalculationFieldTimeRangeStrategy timeRangeStrategy, DatePickerConfig fixedStrategyDatePicker, ManualDataset manualDataset, boolean splitTimeRange, DateAggregationUnit splitTimeRangeTimeUnit) {
        this.id = id;
        this.tenantId = tenantId;
        this.customerId = customerId;
        this.enabled = enabled;
        this.name = name;
        this.creationTime = creationTime;
        this.updateTime = updateTime;
        this.businessEntityId = businessEntityId;
        this.associatedEntityFieldId = associatedEntityFieldId;
        this.language = language;
        this.calculationFieldType = calculationFieldType;
        this.returnDataType = returnDataType;
        this.groupingInterval = groupingInterval;
        this.fieldAggregation = fieldAggregation;
        this.fillGapSettings = fillGapSettings;
        this.tbTelemetryKey = tbTelemetryKey;
        this.script = script;
        this.timeRangeStrategy = timeRangeStrategy;
        this.fixedStrategyDatePicker = fixedStrategyDatePicker;
        this.manualDataset = manualDataset;
        this.splitTimeRange = splitTimeRange;
        this.splitTimeRangeTimeUnit = splitTimeRangeTimeUnit;
    }
}

