/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.domain.base;

import java.time.Duration;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.thingsboard.trendz.domain.base.Point;
import org.thingsboard.trendz.domain.base.TimeRange;
import org.thingsboard.trendz.domain.definition.view.config.DateAggregationUnit;
import org.thingsboard.trendz.tools.DateTimeUtils;

public class TimeRange
implements Comparable<TimeRange> {
    private static final TimeRange ZERO = new TimeRange(0L, 0L);
    private long startTs;
    private long endTs;

    public TimeRange() {
        this(0L, 0L);
    }

    public TimeRange(long startTs, long endTs) {
        if (endTs < startTs) {
            throw new IllegalArgumentException("Invalid arguments: startTs = %s, endTs = %s".formatted(DateTimeUtils.fromTs((long)startTs), DateTimeUtils.fromTs((long)endTs)));
        }
        this.startTs = startTs;
        this.endTs = endTs;
    }

    public TimeRange(TimeRange that) {
        this.startTs = that.startTs;
        this.endTs = that.endTs;
    }

    public String toString() {
        return this.toString(ZoneId.systemDefault());
    }

    public String toString(ZoneId zoneId) {
        return "TimeRange(startTs= %s [%s], endTs= %s [%s])".formatted(this.startTs, DateTimeUtils.fromTs((long)this.startTs, (ZoneId)zoneId), this.endTs, DateTimeUtils.fromTs((long)this.endTs, (ZoneId)zoneId));
    }

    @Override
    public int compareTo(TimeRange that) {
        return Long.compare(this.startTs, that.startTs);
    }

    public boolean contains(long ts) {
        return this.startTs <= ts && ts < this.endTs;
    }

    public boolean contains(Point point) {
        return this.contains(point.getTs());
    }

    public List<Long> makeTsList(DateAggregationUnit unit) {
        return this.makeTsList(unit, ZoneId.systemDefault());
    }

    public List<Long> makeTsList(DateAggregationUnit unit, ZoneId zoneId) {
        return this.splitTimeRange(unit, zoneId).stream().map(TimeRange::getStartTs).collect(Collectors.toList());
    }

    public List<TimeRange> splitTimeRange(DateAggregationUnit unit) {
        return this.splitTimeRange(unit, ZoneId.systemDefault());
    }

    public List<TimeRange> splitTimeRange(DateAggregationUnit unit, ZoneId zoneId) {
        ZonedDateTime endDate;
        ArrayList<TimeRange> timeRanges = new ArrayList<TimeRange>();
        ChronoUnit chronoUnit = unit.mapToChronoUnit();
        ZonedDateTime startDate = DateTimeUtils.fromTs((long)this.startTs, (ZoneId)zoneId);
        if (!startDate.isBefore(endDate = DateTimeUtils.fromTs((long)this.endTs, (ZoneId)zoneId))) {
            return timeRanges;
        }
        ZonedDateTime currentDate = DateTimeUtils.extendedTruncateTo((ZonedDateTime)startDate, (ChronoUnit)chronoUnit);
        if (currentDate.isBefore(startDate)) {
            currentDate = currentDate.plus(1L, chronoUnit);
            timeRanges.add(new TimeRange(this.startTs, Math.min(DateTimeUtils.toTs((ZonedDateTime)currentDate), this.endTs)));
        }
        if (!currentDate.isBefore(endDate)) {
            return timeRanges;
        }
        while (currentDate.isBefore(endDate)) {
            ZonedDateTime nextDate = DateTimeUtils.min((ZonedDateTime)DateTimeUtils.extendedTruncateTo((ZonedDateTime)currentDate.plus(1L, chronoUnit), (ChronoUnit)chronoUnit), (ZonedDateTime)endDate);
            long currentTs = DateTimeUtils.toTs((ZonedDateTime)currentDate);
            long nextTs = DateTimeUtils.toTs((ZonedDateTime)nextDate);
            TimeRange timeRange = new TimeRange(currentTs, nextTs);
            timeRanges.add(timeRange);
            currentDate = nextDate;
        }
        return timeRanges;
    }

    public Duration duration() {
        return Duration.ofMillis(this.endTs - this.startTs);
    }

    public static TimeRange zero() {
        return ZERO;
    }

    @Generated
    public static TimeRangeBuilder builder() {
        return new TimeRangeBuilder();
    }

    @Generated
    public long getStartTs() {
        return this.startTs;
    }

    @Generated
    public long getEndTs() {
        return this.endTs;
    }

    @Generated
    public void setStartTs(long startTs) {
        this.startTs = startTs;
    }

    @Generated
    public void setEndTs(long endTs) {
        this.endTs = endTs;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TimeRange)) {
            return false;
        }
        TimeRange other = (TimeRange)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getStartTs() != other.getStartTs()) {
            return false;
        }
        return this.getEndTs() == other.getEndTs();
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TimeRange;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $startTs = this.getStartTs();
        result = result * 59 + (int)($startTs >>> 32 ^ $startTs);
        long $endTs = this.getEndTs();
        result = result * 59 + (int)($endTs >>> 32 ^ $endTs);
        return result;
    }
}

