/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.domain.assistance.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.UUID;
import lombok.Generated;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.trendz.domain.assistance.model.LlmConfig;
import org.thingsboard.trendz.domain.assistance.model.LlmName;
import org.thingsboard.trendz.domain.assistance.model.LlmProvider;
import org.thingsboard.trendz.domain.assistance.model.properties.LlmProviderProperties;

public class LlmConfig {
    private UUID id;
    private long createdTs;
    private long updatedTs;
    private UUID tenantId;
    private String name;
    private LlmProvider llmProvider;
    private LlmName llmName;
    private double temperature;
    private double topP;
    private LlmProviderProperties llmProviderProperties;

    public LlmConfig(LlmConfig that) {
        this.id = that.id;
        this.createdTs = that.createdTs;
        this.updatedTs = that.updatedTs;
        this.tenantId = that.tenantId;
        this.name = that.name;
        this.llmProvider = that.llmProvider;
        this.llmName = that.llmName;
        this.temperature = that.temperature;
        this.topP = that.topP;
        this.llmProviderProperties = that.llmProviderProperties == null ? null : that.llmProviderProperties.clone();
    }

    @JsonCreator
    public LlmConfig(@JsonProperty(value="id") UUID id, @JsonProperty(value="createdTs") long createdTs, @JsonProperty(value="updatedTs") long updatedTs, @JsonProperty(value="tenantId") UUID tenantId, @JsonProperty(value="name") String name, @JsonProperty(value="llmProvider") LlmProvider llmProvider, @JsonProperty(value="llmName") LlmName llmName, @JsonProperty(value="temperature") double temperature, @JsonProperty(value="topP") double topP, @JsonProperty(value="llmProviderProperties") JsonNode props) {
        this.id = id;
        this.createdTs = createdTs;
        this.updatedTs = updatedTs;
        this.tenantId = tenantId;
        this.name = name;
        this.llmProvider = llmProvider;
        this.llmName = llmName;
        this.temperature = temperature;
        this.topP = topP;
        this.llmProviderProperties = props == null ? null : LlmProviderProperties.fromJson((JsonNode)props, (LlmProvider)llmProvider);
    }

    @JsonIgnore
    public boolean isDefault() {
        return this.tenantId.equals(EntityId.NULL_UUID);
    }

    @Generated
    public static LlmConfigBuilder builder() {
        return new LlmConfigBuilder();
    }

    @Generated
    public UUID getId() {
        return this.id;
    }

    @Generated
    public long getCreatedTs() {
        return this.createdTs;
    }

    @Generated
    public long getUpdatedTs() {
        return this.updatedTs;
    }

    @Generated
    public UUID getTenantId() {
        return this.tenantId;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public LlmProvider getLlmProvider() {
        return this.llmProvider;
    }

    @Generated
    public LlmName getLlmName() {
        return this.llmName;
    }

    @Generated
    public double getTemperature() {
        return this.temperature;
    }

    @Generated
    public double getTopP() {
        return this.topP;
    }

    @Generated
    public LlmProviderProperties getLlmProviderProperties() {
        return this.llmProviderProperties;
    }

    @Generated
    public void setId(UUID id) {
        this.id = id;
    }

    @Generated
    public void setCreatedTs(long createdTs) {
        this.createdTs = createdTs;
    }

    @Generated
    public void setUpdatedTs(long updatedTs) {
        this.updatedTs = updatedTs;
    }

    @Generated
    public void setTenantId(UUID tenantId) {
        this.tenantId = tenantId;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setLlmProvider(LlmProvider llmProvider) {
        this.llmProvider = llmProvider;
    }

    @Generated
    public void setLlmName(LlmName llmName) {
        this.llmName = llmName;
    }

    @Generated
    public void setTemperature(double temperature) {
        this.temperature = temperature;
    }

    @Generated
    public void setTopP(double topP) {
        this.topP = topP;
    }

    @Generated
    public void setLlmProviderProperties(LlmProviderProperties llmProviderProperties) {
        this.llmProviderProperties = llmProviderProperties;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LlmConfig)) {
            return false;
        }
        LlmConfig other = (LlmConfig)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getCreatedTs() != other.getCreatedTs()) {
            return false;
        }
        if (this.getUpdatedTs() != other.getUpdatedTs()) {
            return false;
        }
        if (Double.compare(this.getTemperature(), other.getTemperature()) != 0) {
            return false;
        }
        if (Double.compare(this.getTopP(), other.getTopP()) != 0) {
            return false;
        }
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        UUID this$tenantId = this.getTenantId();
        UUID other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !((Object)this$tenantId).equals(other$tenantId)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        LlmProvider this$llmProvider = this.getLlmProvider();
        LlmProvider other$llmProvider = other.getLlmProvider();
        if (this$llmProvider == null ? other$llmProvider != null : !this$llmProvider.equals(other$llmProvider)) {
            return false;
        }
        LlmName this$llmName = this.getLlmName();
        LlmName other$llmName = other.getLlmName();
        if (this$llmName == null ? other$llmName != null : !this$llmName.equals(other$llmName)) {
            return false;
        }
        LlmProviderProperties this$llmProviderProperties = this.getLlmProviderProperties();
        LlmProviderProperties other$llmProviderProperties = other.getLlmProviderProperties();
        return !(this$llmProviderProperties == null ? other$llmProviderProperties != null : !this$llmProviderProperties.equals(other$llmProviderProperties));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof LlmConfig;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $createdTs = this.getCreatedTs();
        result = result * 59 + (int)($createdTs >>> 32 ^ $createdTs);
        long $updatedTs = this.getUpdatedTs();
        result = result * 59 + (int)($updatedTs >>> 32 ^ $updatedTs);
        long $temperature = Double.doubleToLongBits(this.getTemperature());
        result = result * 59 + (int)($temperature >>> 32 ^ $temperature);
        long $topP = Double.doubleToLongBits(this.getTopP());
        result = result * 59 + (int)($topP >>> 32 ^ $topP);
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        UUID $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : ((Object)$tenantId).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        LlmProvider $llmProvider = this.getLlmProvider();
        result = result * 59 + ($llmProvider == null ? 43 : $llmProvider.hashCode());
        LlmName $llmName = this.getLlmName();
        result = result * 59 + ($llmName == null ? 43 : $llmName.hashCode());
        LlmProviderProperties $llmProviderProperties = this.getLlmProviderProperties();
        result = result * 59 + ($llmProviderProperties == null ? 43 : $llmProviderProperties.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "LlmConfig(id=" + String.valueOf(this.getId()) + ", createdTs=" + this.getCreatedTs() + ", updatedTs=" + this.getUpdatedTs() + ", tenantId=" + String.valueOf(this.getTenantId()) + ", name=" + this.getName() + ", llmProvider=" + String.valueOf(this.getLlmProvider()) + ", llmName=" + String.valueOf(this.getLlmName()) + ", temperature=" + this.getTemperature() + ", topP=" + this.getTopP() + ", llmProviderProperties=" + String.valueOf(this.getLlmProviderProperties()) + ")";
    }

    @Generated
    public LlmConfig() {
    }

    @Generated
    public LlmConfig(UUID id, long createdTs, long updatedTs, UUID tenantId, String name, LlmProvider llmProvider, LlmName llmName, double temperature, double topP, LlmProviderProperties llmProviderProperties) {
        this.id = id;
        this.createdTs = createdTs;
        this.updatedTs = updatedTs;
        this.tenantId = tenantId;
        this.name = name;
        this.llmProvider = llmProvider;
        this.llmName = llmName;
        this.temperature = temperature;
        this.topP = topP;
        this.llmProviderProperties = llmProviderProperties;
    }
}

