/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.domain.anomaly;

import java.time.temporal.ChronoUnit;
import lombok.Generated;
import org.thingsboard.trendz.domain.anomaly.DatasetConfig;
import org.thingsboard.trendz.domain.anomaly.MlProperties;
import org.thingsboard.trendz.service.model.anomaly.util.AnomaliesUtil;

public final class CrossJobJoinTsConfig {
    private ChronoUnit chronoUnit;
    private long startTsOfDiscoveryArea;
    private long endTsOfDiscoveryArea;
    private long startTsOfSavingArea;
    private long endTsOfSavingArea;

    public static CrossJobJoinTsConfig getInstance(MlProperties properties, DatasetConfig datasetConfig, String unit) {
        ChronoUnit chronoUnit = AnomaliesUtil.unitToChronoUnit((String)unit);
        long originalStartTs = datasetConfig.getStartTs();
        long originalEndTs = datasetConfig.getEndTs();
        long startTsOfDiscoveryArea = originalStartTs - properties.getAnomalyExtractProperties().getMinAnomalyDurationMs() - properties.getSegmentSplitProperties().getWindowSizeMs();
        return new CrossJobJoinTsConfig(chronoUnit, startTsOfDiscoveryArea, originalEndTs, originalStartTs, originalEndTs);
    }

    @Generated
    public ChronoUnit getChronoUnit() {
        return this.chronoUnit;
    }

    @Generated
    public long getStartTsOfDiscoveryArea() {
        return this.startTsOfDiscoveryArea;
    }

    @Generated
    public long getEndTsOfDiscoveryArea() {
        return this.endTsOfDiscoveryArea;
    }

    @Generated
    public long getStartTsOfSavingArea() {
        return this.startTsOfSavingArea;
    }

    @Generated
    public long getEndTsOfSavingArea() {
        return this.endTsOfSavingArea;
    }

    @Generated
    public void setChronoUnit(ChronoUnit chronoUnit) {
        this.chronoUnit = chronoUnit;
    }

    @Generated
    public void setStartTsOfDiscoveryArea(long startTsOfDiscoveryArea) {
        this.startTsOfDiscoveryArea = startTsOfDiscoveryArea;
    }

    @Generated
    public void setEndTsOfDiscoveryArea(long endTsOfDiscoveryArea) {
        this.endTsOfDiscoveryArea = endTsOfDiscoveryArea;
    }

    @Generated
    public void setStartTsOfSavingArea(long startTsOfSavingArea) {
        this.startTsOfSavingArea = startTsOfSavingArea;
    }

    @Generated
    public void setEndTsOfSavingArea(long endTsOfSavingArea) {
        this.endTsOfSavingArea = endTsOfSavingArea;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CrossJobJoinTsConfig)) {
            return false;
        }
        CrossJobJoinTsConfig other = (CrossJobJoinTsConfig)o;
        if (this.getStartTsOfDiscoveryArea() != other.getStartTsOfDiscoveryArea()) {
            return false;
        }
        if (this.getEndTsOfDiscoveryArea() != other.getEndTsOfDiscoveryArea()) {
            return false;
        }
        if (this.getStartTsOfSavingArea() != other.getStartTsOfSavingArea()) {
            return false;
        }
        if (this.getEndTsOfSavingArea() != other.getEndTsOfSavingArea()) {
            return false;
        }
        ChronoUnit this$chronoUnit = this.getChronoUnit();
        ChronoUnit other$chronoUnit = other.getChronoUnit();
        return !(this$chronoUnit == null ? other$chronoUnit != null : !this$chronoUnit.equals(other$chronoUnit));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $startTsOfDiscoveryArea = this.getStartTsOfDiscoveryArea();
        result = result * 59 + (int)($startTsOfDiscoveryArea >>> 32 ^ $startTsOfDiscoveryArea);
        long $endTsOfDiscoveryArea = this.getEndTsOfDiscoveryArea();
        result = result * 59 + (int)($endTsOfDiscoveryArea >>> 32 ^ $endTsOfDiscoveryArea);
        long $startTsOfSavingArea = this.getStartTsOfSavingArea();
        result = result * 59 + (int)($startTsOfSavingArea >>> 32 ^ $startTsOfSavingArea);
        long $endTsOfSavingArea = this.getEndTsOfSavingArea();
        result = result * 59 + (int)($endTsOfSavingArea >>> 32 ^ $endTsOfSavingArea);
        ChronoUnit $chronoUnit = this.getChronoUnit();
        result = result * 59 + ($chronoUnit == null ? 43 : $chronoUnit.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "CrossJobJoinTsConfig(chronoUnit=" + String.valueOf(this.getChronoUnit()) + ", startTsOfDiscoveryArea=" + this.getStartTsOfDiscoveryArea() + ", endTsOfDiscoveryArea=" + this.getEndTsOfDiscoveryArea() + ", startTsOfSavingArea=" + this.getStartTsOfSavingArea() + ", endTsOfSavingArea=" + this.getEndTsOfSavingArea() + ")";
    }

    @Generated
    private CrossJobJoinTsConfig(ChronoUnit chronoUnit, long startTsOfDiscoveryArea, long endTsOfDiscoveryArea, long startTsOfSavingArea, long endTsOfSavingArea) {
        this.chronoUnit = chronoUnit;
        this.startTsOfDiscoveryArea = startTsOfDiscoveryArea;
        this.endTsOfDiscoveryArea = endTsOfDiscoveryArea;
        this.startTsOfSavingArea = startTsOfSavingArea;
        this.endTsOfSavingArea = endTsOfSavingArea;
    }
}

