/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.domain.anomaly;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import lombok.Generated;
import org.thingsboard.trendz.domain.anomaly.AnomalyAlarmConfig;
import org.thingsboard.trendz.domain.anomaly.AnomalyModel;
import org.thingsboard.trendz.domain.anomaly.AnomalyModelStatus;
import org.thingsboard.trendz.domain.anomaly.AnomalyModelTaskData;
import org.thingsboard.trendz.domain.anomaly.ClusterInfo;
import org.thingsboard.trendz.domain.anomaly.DatasetConfig;
import org.thingsboard.trendz.domain.anomaly.MlProperties;
import org.thingsboard.trendz.domain.anomaly.ModelType;
import org.thingsboard.trendz.domain.definition.migration.TrendzEntity;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;

public class AnomalyModel
implements TrendzEntity {
    private UUID id;
    private JwtSecurityUser user;
    private long createTs;
    private long updateTs;
    private String name;
    private AnomalyModelStatus status;
    private ModelType type;
    private MlProperties properties;
    private DatasetConfig datasetConfig;
    private AnomalyModelTaskData taskData;
    private AnomalyAlarmConfig anomalyAlarmConfig;
    private List<ClusterInfo> clusters = new ArrayList();
    private String tbTelemetryKey;
    private UUID anomalyScoreAssociatedFieldId;
    private UUID anomalyScoreIndexAssociatedFieldId;
    private String telemetrySavePeriodUnit;
    private String alarmType;
    private boolean enabledAlarmDeletion;

    public AnomalyModel(AnomalyModel that) {
        this.id = that.id;
        this.user = that.user == null ? null : new JwtSecurityUser(that.user);
        this.createTs = that.createTs;
        this.updateTs = that.updateTs;
        this.name = that.name;
        this.status = that.status;
        this.type = that.type;
        this.properties = that.properties == null ? null : new MlProperties(that.properties);
        this.datasetConfig = that.datasetConfig == null ? null : new DatasetConfig(that.datasetConfig);
        this.taskData = that.taskData == null ? null : new AnomalyModelTaskData(that.taskData);
        this.anomalyAlarmConfig = that.anomalyAlarmConfig == null ? null : new AnomalyAlarmConfig(that.anomalyAlarmConfig);
        this.clusters = that.clusters == null ? null : that.clusters.stream().map(ClusterInfo::new).collect(Collectors.toList());
        this.tbTelemetryKey = that.tbTelemetryKey;
        this.anomalyScoreAssociatedFieldId = that.anomalyScoreAssociatedFieldId;
        this.anomalyScoreIndexAssociatedFieldId = that.anomalyScoreIndexAssociatedFieldId;
        this.telemetrySavePeriodUnit = that.telemetrySavePeriodUnit;
        this.alarmType = that.alarmType;
        this.enabledAlarmDeletion = that.enabledAlarmDeletion;
    }

    @JsonIgnore
    public UUID getTenantId() {
        return this.user.getTenantId();
    }

    @Generated
    public static AnomalyModelBuilder builder() {
        return new AnomalyModelBuilder();
    }

    @Generated
    public UUID getId() {
        return this.id;
    }

    @Generated
    public JwtSecurityUser getUser() {
        return this.user;
    }

    @Generated
    public long getCreateTs() {
        return this.createTs;
    }

    @Generated
    public long getUpdateTs() {
        return this.updateTs;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public AnomalyModelStatus getStatus() {
        return this.status;
    }

    @Generated
    public ModelType getType() {
        return this.type;
    }

    @Generated
    public MlProperties getProperties() {
        return this.properties;
    }

    @Generated
    public DatasetConfig getDatasetConfig() {
        return this.datasetConfig;
    }

    @Generated
    public AnomalyModelTaskData getTaskData() {
        return this.taskData;
    }

    @Generated
    public AnomalyAlarmConfig getAnomalyAlarmConfig() {
        return this.anomalyAlarmConfig;
    }

    @Generated
    public List<ClusterInfo> getClusters() {
        return this.clusters;
    }

    @Generated
    public String getTbTelemetryKey() {
        return this.tbTelemetryKey;
    }

    @Generated
    public UUID getAnomalyScoreAssociatedFieldId() {
        return this.anomalyScoreAssociatedFieldId;
    }

    @Generated
    public UUID getAnomalyScoreIndexAssociatedFieldId() {
        return this.anomalyScoreIndexAssociatedFieldId;
    }

    @Generated
    public String getTelemetrySavePeriodUnit() {
        return this.telemetrySavePeriodUnit;
    }

    @Generated
    public String getAlarmType() {
        return this.alarmType;
    }

    @Generated
    public boolean isEnabledAlarmDeletion() {
        return this.enabledAlarmDeletion;
    }

    @Generated
    public void setId(UUID id) {
        this.id = id;
    }

    @Generated
    public void setUser(JwtSecurityUser user) {
        this.user = user;
    }

    @Generated
    public void setCreateTs(long createTs) {
        this.createTs = createTs;
    }

    @Generated
    public void setUpdateTs(long updateTs) {
        this.updateTs = updateTs;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setStatus(AnomalyModelStatus status) {
        this.status = status;
    }

    @Generated
    public void setType(ModelType type) {
        this.type = type;
    }

    @Generated
    public void setProperties(MlProperties properties) {
        this.properties = properties;
    }

    @Generated
    public void setDatasetConfig(DatasetConfig datasetConfig) {
        this.datasetConfig = datasetConfig;
    }

    @Generated
    public void setTaskData(AnomalyModelTaskData taskData) {
        this.taskData = taskData;
    }

    @Generated
    public void setAnomalyAlarmConfig(AnomalyAlarmConfig anomalyAlarmConfig) {
        this.anomalyAlarmConfig = anomalyAlarmConfig;
    }

    @Generated
    public void setClusters(List<ClusterInfo> clusters) {
        this.clusters = clusters;
    }

    @Generated
    public void setTbTelemetryKey(String tbTelemetryKey) {
        this.tbTelemetryKey = tbTelemetryKey;
    }

    @Generated
    public void setAnomalyScoreAssociatedFieldId(UUID anomalyScoreAssociatedFieldId) {
        this.anomalyScoreAssociatedFieldId = anomalyScoreAssociatedFieldId;
    }

    @Generated
    public void setAnomalyScoreIndexAssociatedFieldId(UUID anomalyScoreIndexAssociatedFieldId) {
        this.anomalyScoreIndexAssociatedFieldId = anomalyScoreIndexAssociatedFieldId;
    }

    @Generated
    public void setTelemetrySavePeriodUnit(String telemetrySavePeriodUnit) {
        this.telemetrySavePeriodUnit = telemetrySavePeriodUnit;
    }

    @Generated
    public void setAlarmType(String alarmType) {
        this.alarmType = alarmType;
    }

    @Generated
    public void setEnabledAlarmDeletion(boolean enabledAlarmDeletion) {
        this.enabledAlarmDeletion = enabledAlarmDeletion;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AnomalyModel)) {
            return false;
        }
        AnomalyModel other = (AnomalyModel)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getCreateTs() != other.getCreateTs()) {
            return false;
        }
        if (this.getUpdateTs() != other.getUpdateTs()) {
            return false;
        }
        if (this.isEnabledAlarmDeletion() != other.isEnabledAlarmDeletion()) {
            return false;
        }
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        JwtSecurityUser this$user = this.getUser();
        JwtSecurityUser other$user = other.getUser();
        if (this$user == null ? other$user != null : !this$user.equals(other$user)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        AnomalyModelStatus this$status = this.getStatus();
        AnomalyModelStatus other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        ModelType this$type = this.getType();
        ModelType other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        MlProperties this$properties = this.getProperties();
        MlProperties other$properties = other.getProperties();
        if (this$properties == null ? other$properties != null : !this$properties.equals(other$properties)) {
            return false;
        }
        DatasetConfig this$datasetConfig = this.getDatasetConfig();
        DatasetConfig other$datasetConfig = other.getDatasetConfig();
        if (this$datasetConfig == null ? other$datasetConfig != null : !this$datasetConfig.equals(other$datasetConfig)) {
            return false;
        }
        AnomalyModelTaskData this$taskData = this.getTaskData();
        AnomalyModelTaskData other$taskData = other.getTaskData();
        if (this$taskData == null ? other$taskData != null : !this$taskData.equals(other$taskData)) {
            return false;
        }
        AnomalyAlarmConfig this$anomalyAlarmConfig = this.getAnomalyAlarmConfig();
        AnomalyAlarmConfig other$anomalyAlarmConfig = other.getAnomalyAlarmConfig();
        if (this$anomalyAlarmConfig == null ? other$anomalyAlarmConfig != null : !this$anomalyAlarmConfig.equals(other$anomalyAlarmConfig)) {
            return false;
        }
        List this$clusters = this.getClusters();
        List other$clusters = other.getClusters();
        if (this$clusters == null ? other$clusters != null : !((Object)this$clusters).equals(other$clusters)) {
            return false;
        }
        String this$tbTelemetryKey = this.getTbTelemetryKey();
        String other$tbTelemetryKey = other.getTbTelemetryKey();
        if (this$tbTelemetryKey == null ? other$tbTelemetryKey != null : !this$tbTelemetryKey.equals(other$tbTelemetryKey)) {
            return false;
        }
        UUID this$anomalyScoreAssociatedFieldId = this.getAnomalyScoreAssociatedFieldId();
        UUID other$anomalyScoreAssociatedFieldId = other.getAnomalyScoreAssociatedFieldId();
        if (this$anomalyScoreAssociatedFieldId == null ? other$anomalyScoreAssociatedFieldId != null : !((Object)this$anomalyScoreAssociatedFieldId).equals(other$anomalyScoreAssociatedFieldId)) {
            return false;
        }
        UUID this$anomalyScoreIndexAssociatedFieldId = this.getAnomalyScoreIndexAssociatedFieldId();
        UUID other$anomalyScoreIndexAssociatedFieldId = other.getAnomalyScoreIndexAssociatedFieldId();
        if (this$anomalyScoreIndexAssociatedFieldId == null ? other$anomalyScoreIndexAssociatedFieldId != null : !((Object)this$anomalyScoreIndexAssociatedFieldId).equals(other$anomalyScoreIndexAssociatedFieldId)) {
            return false;
        }
        String this$telemetrySavePeriodUnit = this.getTelemetrySavePeriodUnit();
        String other$telemetrySavePeriodUnit = other.getTelemetrySavePeriodUnit();
        if (this$telemetrySavePeriodUnit == null ? other$telemetrySavePeriodUnit != null : !this$telemetrySavePeriodUnit.equals(other$telemetrySavePeriodUnit)) {
            return false;
        }
        String this$alarmType = this.getAlarmType();
        String other$alarmType = other.getAlarmType();
        return !(this$alarmType == null ? other$alarmType != null : !this$alarmType.equals(other$alarmType));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AnomalyModel;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $createTs = this.getCreateTs();
        result = result * 59 + (int)($createTs >>> 32 ^ $createTs);
        long $updateTs = this.getUpdateTs();
        result = result * 59 + (int)($updateTs >>> 32 ^ $updateTs);
        result = result * 59 + (this.isEnabledAlarmDeletion() ? 79 : 97);
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        JwtSecurityUser $user = this.getUser();
        result = result * 59 + ($user == null ? 43 : $user.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        AnomalyModelStatus $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        ModelType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        MlProperties $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : $properties.hashCode());
        DatasetConfig $datasetConfig = this.getDatasetConfig();
        result = result * 59 + ($datasetConfig == null ? 43 : $datasetConfig.hashCode());
        AnomalyModelTaskData $taskData = this.getTaskData();
        result = result * 59 + ($taskData == null ? 43 : $taskData.hashCode());
        AnomalyAlarmConfig $anomalyAlarmConfig = this.getAnomalyAlarmConfig();
        result = result * 59 + ($anomalyAlarmConfig == null ? 43 : $anomalyAlarmConfig.hashCode());
        List $clusters = this.getClusters();
        result = result * 59 + ($clusters == null ? 43 : ((Object)$clusters).hashCode());
        String $tbTelemetryKey = this.getTbTelemetryKey();
        result = result * 59 + ($tbTelemetryKey == null ? 43 : $tbTelemetryKey.hashCode());
        UUID $anomalyScoreAssociatedFieldId = this.getAnomalyScoreAssociatedFieldId();
        result = result * 59 + ($anomalyScoreAssociatedFieldId == null ? 43 : ((Object)$anomalyScoreAssociatedFieldId).hashCode());
        UUID $anomalyScoreIndexAssociatedFieldId = this.getAnomalyScoreIndexAssociatedFieldId();
        result = result * 59 + ($anomalyScoreIndexAssociatedFieldId == null ? 43 : ((Object)$anomalyScoreIndexAssociatedFieldId).hashCode());
        String $telemetrySavePeriodUnit = this.getTelemetrySavePeriodUnit();
        result = result * 59 + ($telemetrySavePeriodUnit == null ? 43 : $telemetrySavePeriodUnit.hashCode());
        String $alarmType = this.getAlarmType();
        result = result * 59 + ($alarmType == null ? 43 : $alarmType.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "AnomalyModel(id=" + String.valueOf(this.getId()) + ", user=" + String.valueOf(this.getUser()) + ", createTs=" + this.getCreateTs() + ", updateTs=" + this.getUpdateTs() + ", name=" + this.getName() + ", status=" + String.valueOf(this.getStatus()) + ", type=" + String.valueOf(this.getType()) + ", properties=" + String.valueOf(this.getProperties()) + ", datasetConfig=" + String.valueOf(this.getDatasetConfig()) + ", taskData=" + String.valueOf(this.getTaskData()) + ", anomalyAlarmConfig=" + String.valueOf(this.getAnomalyAlarmConfig()) + ", clusters=" + String.valueOf(this.getClusters()) + ", tbTelemetryKey=" + this.getTbTelemetryKey() + ", anomalyScoreAssociatedFieldId=" + String.valueOf(this.getAnomalyScoreAssociatedFieldId()) + ", anomalyScoreIndexAssociatedFieldId=" + String.valueOf(this.getAnomalyScoreIndexAssociatedFieldId()) + ", telemetrySavePeriodUnit=" + this.getTelemetrySavePeriodUnit() + ", alarmType=" + this.getAlarmType() + ", enabledAlarmDeletion=" + this.isEnabledAlarmDeletion() + ")";
    }

    @Generated
    public AnomalyModel() {
    }

    @Generated
    public AnomalyModel(UUID id, JwtSecurityUser user, long createTs, long updateTs, String name, AnomalyModelStatus status, ModelType type, MlProperties properties, DatasetConfig datasetConfig, AnomalyModelTaskData taskData, AnomalyAlarmConfig anomalyAlarmConfig, List<ClusterInfo> clusters, String tbTelemetryKey, UUID anomalyScoreAssociatedFieldId, UUID anomalyScoreIndexAssociatedFieldId, String telemetrySavePeriodUnit, String alarmType, boolean enabledAlarmDeletion) {
        this.id = id;
        this.user = user;
        this.createTs = createTs;
        this.updateTs = updateTs;
        this.name = name;
        this.status = status;
        this.type = type;
        this.properties = properties;
        this.datasetConfig = datasetConfig;
        this.taskData = taskData;
        this.anomalyAlarmConfig = anomalyAlarmConfig;
        this.clusters = clusters;
        this.tbTelemetryKey = tbTelemetryKey;
        this.anomalyScoreAssociatedFieldId = anomalyScoreAssociatedFieldId;
        this.anomalyScoreIndexAssociatedFieldId = anomalyScoreIndexAssociatedFieldId;
        this.telemetrySavePeriodUnit = telemetrySavePeriodUnit;
        this.alarmType = alarmType;
        this.enabledAlarmDeletion = enabledAlarmDeletion;
    }
}

