/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.dao.view;

import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.CrudRepository;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;
import org.thingsboard.trendz.dao.view.ViewConfigDto;
import org.thingsboard.trendz.domain.definition.view.config.ViewConfigLite;
import org.thingsboard.trendz.domain.summary.TrendzSimpleEntityUsage;

@Repository
public interface ViewConfigRepository
extends CrudRepository<ViewConfigDto, UUID> {
    @Query(value="SELECT new org.thingsboard.trendz.domain.definition.view.config.ViewConfigLite\n(\n   vc.id, vc.tenantId, vc.customerId, vc.collectionId, vc.parentPath, vc.favorite, vc.name,\n   vc.viewType, vc.createdAt, vc.updatedAt\n)\nFROM ViewConfigDto vc\nWHERE vc.tenantId = :tenantId AND vc.customerId IN (:customerIdSet)\n")
    public Page<ViewConfigLite> findAllLiteByUserSet(@Param(value="tenantId") UUID var1, @Param(value="customerIdSet") Set<UUID> var2, PageRequest var3);

    @Query(value="SELECT new org.thingsboard.trendz.domain.definition.view.config.ViewConfigLite\n(\n   vc.id, vc.tenantId, vc.customerId, vc.collectionId, vc.parentPath, vc.favorite, vc.name,\n   vc.viewType, vc.createdAt, vc.updatedAt\n)\nFROM ViewConfigDto vc\nWHERE vc.tenantId = :tenantId AND vc.collectionId = :collectionId AND vc.customerId IN (:customerIdSet)\n")
    public Page<ViewConfigLite> findAllLiteByUserSetAndCollectionId(@Param(value="tenantId") UUID var1, @Param(value="customerIdSet") Set<UUID> var2, @Param(value="collectionId") UUID var3, PageRequest var4);

    @Query(value="SELECT vc.id, vc.tenantId, vc.customerId, vc.collectionId, vc.parentPath, vc.name, vc.viewType, vc.createdAt, vc.updatedAt, vc.favorite\nFROM ViewConfigDto vc\nWHERE vc.tenantId = :tenantId AND vc.collectionId IN (:collectionIdSet) AND vc.customerId IN (:customerIdSet)\n")
    public List<Object[]> findAllLiteByUserSetAndCollectionIdSet(@Param(value="tenantId") UUID var1, @Param(value="customerIdSet") Set<UUID> var2, @Param(value="collectionIdSet") Set<UUID> var3);

    @Query(value="SELECT vc.id, vc.tenantId, vc.customerId, vc.collectionId, vc.parentPath, vc.name, vc.viewType, vc.createdAt, vc.updatedAt, vc.favorite\nFROM ViewConfigDto vc\nWHERE vc.id IN (:configIdSet) AND vc.tenantId = :tenantId AND vc.customerId IN (:customerIdSet)\n")
    public List<Object[]> findAllLiteByUserSetAndConfigIdSet(@Param(value="tenantId") UUID var1, @Param(value="customerIdSet") Set<UUID> var2, @Param(value="configIdSet") Set<UUID> var3);

    @Query(value="SELECT new org.thingsboard.trendz.domain.definition.view.config.ViewConfigLite\n(\n   vc.id, vc.tenantId, vc.customerId, vc.collectionId, vc.parentPath, vc.favorite, vc.name,\n   vc.viewType, vc.createdAt, vc.updatedAt\n)\nFROM ViewConfigDto vc\nWHERE vc.tenantId = :tenantId AND vc.customerId IN (:customerIdSet) AND lower(vc.name) LIKE lower(concat('%', :word, '%'))\n")
    public Page<ViewConfigLite> findAllLiteByUserSetAndWord(@Param(value="tenantId") UUID var1, @Param(value="customerIdSet") Set<UUID> var2, @Param(value="word") String var3, PageRequest var4);

    @Query(value="SELECT vc FROM ViewConfigDto vc WHERE vc.tenantId = :tenantId AND vc.customerId IN (:customerIdSet)")
    public Set<ViewConfigDto> findAllByUserSet(@Param(value="tenantId") UUID var1, @Param(value="customerIdSet") Set<UUID> var2);

    @Query(value="SELECT vc\nFROM ViewConfigDto vc\nWHERE vc.id = :id AND vc.tenantId = :tenantId AND (:insecure = TRUE OR vc.customerId IN (:customerIdSet))\n")
    public Optional<ViewConfigDto> findByIdAndUserSet(@Param(value="id") UUID var1, @Param(value="tenantId") UUID var2, @Param(value="customerIdSet") Set<UUID> var3, @Param(value="insecure") boolean var4);

    @Query(value="SELECT new org.thingsboard.trendz.domain.definition.view.config.ViewConfigLite(\n   vc.id, vc.tenantId, vc.customerId, vc.collectionId, vc.parentPath, vc.favorite, vc.name,\n   vc.viewType, vc.createdAt, vc.updatedAt\n)\nFROM ViewConfigDto vc\nWHERE vc.tenantId = :tenantId AND vc.customerId IN (:customerIdSet) AND vc.favorite = TRUE\n")
    public Page<ViewConfigLite> findAllFavoriteByUserSet(@Param(value="tenantId") UUID var1, @Param(value="customerIdSet") Set<UUID> var2, PageRequest var3);

    @Query(value="SELECT new org.thingsboard.trendz.domain.summary.TrendzSimpleEntityUsage(COUNT(v))\nFROM ViewConfigDto v\nWHERE :tenantId = :nullId OR v.tenantId = :tenantId\n")
    public Optional<TrendzSimpleEntityUsage> findUsage(UUID var1, UUID var2);

    @Query(value="UPDATE ViewConfigDto vc\nSET vc.favorite = :favorite\nWHERE vc.id = :id AND vc.tenantId = :tenantId AND vc.customerId IN (:customerIdSet)\n")
    @Modifying
    public void setFavoriteByIdAndUserSet(@Param(value="favorite") boolean var1, @Param(value="id") UUID var2, @Param(value="tenantId") UUID var3, @Param(value="customerIdSet") Set<UUID> var4);

    @Query(value="UPDATE ViewConfigDto vc\nSET vc.name = :name\nWHERE vc.id = :id AND vc.tenantId = :tenantId AND vc.customerId IN (:customerIdSet)\n")
    @Modifying
    public void renameByIdAndUserSet(@Param(value="name") String var1, @Param(value="id") UUID var2, @Param(value="tenantId") UUID var3, @Param(value="customerIdSet") Set<UUID> var4);

    @Query(value="DELETE FROM ViewConfigDto vc\nWHERE vc.id = :id AND vc.tenantId = :tenantId AND vc.customerId IN (:customerIdSet)\n")
    @Modifying
    public void deleteByIdAndUserSet(@Param(value="id") UUID var1, @Param(value="tenantId") UUID var2, @Param(value="customerIdSet") Set<UUID> var3);

    @Query(value="DELETE FROM ViewConfigDto vc\nWHERE vc.id IN (:idSet) AND vc.tenantId = :tenantId AND vc.customerId IN (:customerIdSet)\n")
    @Modifying
    public void deleteByIdSetAndUserSet(@Param(value="idSet") Set<UUID> var1, @Param(value="tenantId") UUID var2, @Param(value="customerIdSet") Set<UUID> var3);

    @Query(value="UPDATE ViewConfigDto vc\nSET vc.collectionId = :parentId\nWHERE vc.id IN (:idSet) AND vc.tenantId = :tenantId AND vc.customerId IN (:customerIdSet)\n")
    @Modifying
    public void moveByIdSetAndParent(@Param(value="idSet") Set<UUID> var1, @Param(value="tenantId") UUID var2, @Param(value="customerIdSet") Set<UUID> var3, @Param(value="parentId") UUID var4);

    @Query(value="UPDATE ViewConfigDto vc\nSET vc.parentPath = :parentPath\nWHERE vc.collectionId = :parentId AND vc.tenantId = :tenantId AND vc.customerId IN (:customerIdSet)\n")
    @Modifying
    public void setParentPathByIdSetAndUserSet(@Param(value="tenantId") UUID var1, @Param(value="customerIdSet") Set<UUID> var2, @Param(value="parentId") UUID var3, @Param(value="parentPath") String var4);
}

