/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.dao.view;

import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.CrudRepository;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;
import org.thingsboard.trendz.dao.view.ViewCollectionDto;

@Repository
public interface ViewCollectionRepository
extends CrudRepository<ViewCollectionDto, UUID> {
    @Query(value="select vc from ViewCollectionDto vc where vc.tenantId = :tenantId and vc.customerId in (:customerIdSet)")
    public Set<ViewCollectionDto> findAllByUserSet(@Param(value="tenantId") UUID var1, @Param(value="customerIdSet") Set<UUID> var2);

    @Query(value="select vc from ViewCollectionDto vc where vc.parentId in (:parentIds) and vc.tenantId = :tenantId and vc.customerId in (:customerIdSet)")
    public Set<ViewCollectionDto> findAllByParentCollectionSetAndUserSet(@Param(value="parentIds") Set<UUID> var1, @Param(value="tenantId") UUID var2, @Param(value="customerIdSet") Set<UUID> var3);

    @Query(value="select vc from ViewCollectionDto vc where vc.id in (:idSet) and vc.tenantId = :tenantId and vc.customerId in (:customerIdSet)")
    public Set<ViewCollectionDto> findAllByIdSetAndUserSet(@Param(value="tenantId") UUID var1, @Param(value="customerIdSet") Set<UUID> var2, @Param(value="idSet") Set<UUID> var3);

    @Query(value="select vc from ViewCollectionDto vc where vc.tenantId = :tenantId and vc.customerId in (:customerIdSet) and vc.name like :prefix%")
    public Set<ViewCollectionDto> findAllByUserSetAndPrefix(@Param(value="tenantId") UUID var1, @Param(value="customerIdSet") Set<UUID> var2, @Param(value="prefix") String var3);

    @Query(value="select vc from ViewCollectionDto vc where vc.id = :id and vc.tenantId = :tenantId and vc.customerId in (:customerIdSet)")
    public Optional<ViewCollectionDto> findByIdAndUserSet(@Param(value="id") UUID var1, @Param(value="tenantId") UUID var2, @Param(value="customerIdSet") Set<UUID> var3);

    @Query(value="update ViewCollectionDto vc set vc.name = :name where vc.id = :id and vc.tenantId = :tenantId and vc.customerId in (:customerIdSet)")
    @Modifying
    public void renameByUserSetAndId(@Param(value="name") String var1, @Param(value="id") UUID var2, @Param(value="tenantId") UUID var3, @Param(value="customerIdSet") Set<UUID> var4);

    @Query(value="delete from ViewCollectionDto vc where vc.id = :id and vc.tenantId = :tenantId and vc.customerId in (:customerIdSet)")
    @Modifying
    public void deleteByUserSetAndId(@Param(value="id") UUID var1, @Param(value="tenantId") UUID var2, @Param(value="customerIdSet") Set<UUID> var3);

    @Query(value="delete from ViewCollectionDto vc where vc.id in (:idSet) and vc.tenantId = :tenantId and vc.customerId in (:customerIdSet)")
    @Modifying
    public void deleteByUserSetAndIdSet(@Param(value="idSet") Set<UUID> var1, @Param(value="tenantId") UUID var2, @Param(value="customerIdSet") Set<UUID> var3);

    @Query(value="update ViewCollectionDto vc set vc.parentId = :parentId where vc.id in (:idSet) and vc.tenantId = :tenantId and vc.customerId in (:customerIdSet)")
    @Modifying
    public void moveByUserSetAndIdSetAndParentId(@Param(value="idSet") Set<UUID> var1, @Param(value="tenantId") UUID var2, @Param(value="customerIdSet") Set<UUID> var3, @Param(value="parentId") UUID var4);

    @Query(nativeQuery=true, value="WITH RECURSIVE r AS (\n    SELECT\n        vc.collection_name,\n        vc.parent_id\n    FROM view_collection vc\n    WHERE vc.id = :id AND vc.tenant_id = :tenantId AND vc.customer_id in (:customerIdSet)\n\n    UNION\n\n    SELECT\n        vc.collection_name,\n        vc.parent_id\n    FROM view_collection vc INNER JOIN r ON vc.id = r.parent_id\n    WHERE vc.id <> '13814000-1dd2-11b2-8080-808080808080'\n)\nSELECT r.collection_name FROM r;")
    public List<Object[]> getParentPathById(@Param(value="id") UUID var1, @Param(value="tenantId") UUID var2, @Param(value="customerIdSet") Set<UUID> var3);
}

