/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.dao.task;

import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.CrudRepository;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;
import org.thingsboard.trendz.dao.task.TaskSequenceDto;
import org.thingsboard.trendz.service.task.model.TaskReference;

@Repository
public interface TaskSequenceRepository
extends CrudRepository<TaskSequenceDto, UUID> {
    @Query(value="SELECT tsd\nFROM TaskSequenceDto tsd\nWHERE tsd.tenantId = :tenantId AND\n(coalesce(:customerId, null) IS NULL OR tsd.customerId = :customerId)\n")
    public List<TaskSequenceDto> exportAllByTenantIdAndCustomerId(@Param(value="tenantId") UUID var1, @Param(value="customerId") UUID var2);

    @Query(value="SELECT tsd\nFROM TaskSequenceDto tsd\nWHERE tsd.tenantId = :tenantId AND\n(coalesce(:customerId, null) IS NULL OR tsd.customerId = :customerId) AND\n(coalesce(:name, null) IS NULL OR tsd.name LIKE %:name%)\n")
    public Page<TaskSequenceDto> findAllByTenantIdAndCustomerId(@Param(value="tenantId") UUID var1, @Param(value="customerId") UUID var2, @Param(value="name") String var3, Pageable var4);

    @Query(value="SELECT tsd\nFROM TaskSequenceDto tsd\nWHERE tsd.id = :id AND tsd.tenantId = :tenantId AND\n(:insecure = TRUE OR coalesce(:customerId, null) IS NULL OR tsd.customerId = :customerId)\n")
    public Optional<TaskSequenceDto> findByIdAndTenantIdAndCustomerId(@Param(value="id") UUID var1, @Param(value="tenantId") UUID var2, @Param(value="customerId") UUID var3, @Param(value="insecure") boolean var4);

    @Query(value="SELECT t.reference\nFROM TaskDto t\nWHERE t.tenantId = :tenantId\n  AND (coalesce(:customerId, null) IS NULL OR t.customerId = :customerId)\n  AND t.reference IN :taskReferenceSet\n")
    public Set<TaskReference> checkTaskExistence(@Param(value="tenantId") UUID var1, @Param(value="customerId") UUID var2, @Param(value="taskReferenceSet") Set<TaskReference> var3);
}

