/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.dao.task;

import com.fasterxml.jackson.databind.type.CollectionType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.Id;
import jakarta.persistence.IdClass;
import jakarta.persistence.Table;
import java.util.Set;
import java.util.UUID;
import lombok.Generated;
import org.thingsboard.trendz.dao.task.TaskExecutionRequestDto;
import org.thingsboard.trendz.dao.task.TaskExecutionRequestDtoId;
import org.thingsboard.trendz.dao.task.TaskState;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.service.task.TaskJob;
import org.thingsboard.trendz.service.task.model.TaskExecutionRequest;
import org.thingsboard.trendz.service.task.model.TaskJobType;
import org.thingsboard.trendz.tools.json.JsonUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@Entity
@Table(name="trendz_task_execution_request")
@IdClass(value=TaskExecutionRequestDtoId.class)
public class TaskExecutionRequestDto {
    @Id
    @Column(name="task_id")
    private UUID taskId;
    @Id
    @Column(name="execution_id")
    private UUID executionId;
    @Column(name="tenant_id")
    private UUID tenantId;
    @Column(name="customer_id")
    private UUID customerId;
    @Column(name="user_id")
    private UUID userId;
    @Column(name="scheduled")
    private boolean scheduled;
    @Column(name="job_type")
    @Enumerated(value=EnumType.STRING)
    private TaskJobType jobType;
    @Column(name="json_job")
    private String jsonJob;
    @Column(name="created_ts")
    private long createdTs;
    @Column(name="state")
    @Enumerated(value=EnumType.STRING)
    private TaskState state;

    public TaskExecutionRequest toData(Class<? extends TaskJob> jobClass) {
        CollectionType type = JsonUtils.getObjectMapper().getTypeFactory().constructCollectionType(Set.class, UUID.class);
        return TaskExecutionRequest.builder().taskId(this.taskId).executionId(this.executionId).user(new JwtSecurityUser(this.tenantId, this.customerId, this.userId)).scheduled(this.scheduled).job((TaskJob)JsonUtils.fromJson((String)this.jsonJob, jobClass)).createdTs(this.createdTs).state(this.state).build();
    }

    public static TaskExecutionRequestDto from(TaskExecutionRequest entity) {
        return TaskExecutionRequestDto.builder().taskId(entity.getTaskId()).executionId(entity.getExecutionId()).tenantId(entity.getUser().getTenantId()).customerId(entity.getUser().getCustomerId()).userId(entity.getUser().getUserId()).scheduled(entity.isScheduled()).jobType(entity.getJob().getJobType()).jsonJob(JsonUtils.toJson((Object)entity.getJob())).createdTs(entity.getCreatedTs()).state(entity.getState()).build();
    }

    @Generated
    public static TaskExecutionRequestDtoBuilder builder() {
        return new TaskExecutionRequestDtoBuilder();
    }

    @Generated
    public UUID getTaskId() {
        return this.taskId;
    }

    @Generated
    public UUID getExecutionId() {
        return this.executionId;
    }

    @Generated
    public UUID getTenantId() {
        return this.tenantId;
    }

    @Generated
    public UUID getCustomerId() {
        return this.customerId;
    }

    @Generated
    public UUID getUserId() {
        return this.userId;
    }

    @Generated
    public boolean isScheduled() {
        return this.scheduled;
    }

    @Generated
    public TaskJobType getJobType() {
        return this.jobType;
    }

    @Generated
    public String getJsonJob() {
        return this.jsonJob;
    }

    @Generated
    public long getCreatedTs() {
        return this.createdTs;
    }

    @Generated
    public TaskState getState() {
        return this.state;
    }

    @Generated
    public void setTaskId(UUID taskId) {
        this.taskId = taskId;
    }

    @Generated
    public void setExecutionId(UUID executionId) {
        this.executionId = executionId;
    }

    @Generated
    public void setTenantId(UUID tenantId) {
        this.tenantId = tenantId;
    }

    @Generated
    public void setCustomerId(UUID customerId) {
        this.customerId = customerId;
    }

    @Generated
    public void setUserId(UUID userId) {
        this.userId = userId;
    }

    @Generated
    public void setScheduled(boolean scheduled) {
        this.scheduled = scheduled;
    }

    @Generated
    public void setJobType(TaskJobType jobType) {
        this.jobType = jobType;
    }

    @Generated
    public void setJsonJob(String jsonJob) {
        this.jsonJob = jsonJob;
    }

    @Generated
    public void setCreatedTs(long createdTs) {
        this.createdTs = createdTs;
    }

    @Generated
    public void setState(TaskState state) {
        this.state = state;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TaskExecutionRequestDto)) {
            return false;
        }
        TaskExecutionRequestDto other = (TaskExecutionRequestDto)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.isScheduled() != other.isScheduled()) {
            return false;
        }
        if (this.getCreatedTs() != other.getCreatedTs()) {
            return false;
        }
        UUID this$taskId = this.getTaskId();
        UUID other$taskId = other.getTaskId();
        if (this$taskId == null ? other$taskId != null : !((Object)this$taskId).equals(other$taskId)) {
            return false;
        }
        UUID this$executionId = this.getExecutionId();
        UUID other$executionId = other.getExecutionId();
        if (this$executionId == null ? other$executionId != null : !((Object)this$executionId).equals(other$executionId)) {
            return false;
        }
        UUID this$tenantId = this.getTenantId();
        UUID other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !((Object)this$tenantId).equals(other$tenantId)) {
            return false;
        }
        UUID this$customerId = this.getCustomerId();
        UUID other$customerId = other.getCustomerId();
        if (this$customerId == null ? other$customerId != null : !((Object)this$customerId).equals(other$customerId)) {
            return false;
        }
        UUID this$userId = this.getUserId();
        UUID other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !((Object)this$userId).equals(other$userId)) {
            return false;
        }
        TaskJobType this$jobType = this.getJobType();
        TaskJobType other$jobType = other.getJobType();
        if (this$jobType == null ? other$jobType != null : !this$jobType.equals(other$jobType)) {
            return false;
        }
        String this$jsonJob = this.getJsonJob();
        String other$jsonJob = other.getJsonJob();
        if (this$jsonJob == null ? other$jsonJob != null : !this$jsonJob.equals(other$jsonJob)) {
            return false;
        }
        TaskState this$state = this.getState();
        TaskState other$state = other.getState();
        return !(this$state == null ? other$state != null : !this$state.equals(other$state));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TaskExecutionRequestDto;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isScheduled() ? 79 : 97);
        long $createdTs = this.getCreatedTs();
        result = result * 59 + (int)($createdTs >>> 32 ^ $createdTs);
        UUID $taskId = this.getTaskId();
        result = result * 59 + ($taskId == null ? 43 : ((Object)$taskId).hashCode());
        UUID $executionId = this.getExecutionId();
        result = result * 59 + ($executionId == null ? 43 : ((Object)$executionId).hashCode());
        UUID $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : ((Object)$tenantId).hashCode());
        UUID $customerId = this.getCustomerId();
        result = result * 59 + ($customerId == null ? 43 : ((Object)$customerId).hashCode());
        UUID $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : ((Object)$userId).hashCode());
        TaskJobType $jobType = this.getJobType();
        result = result * 59 + ($jobType == null ? 43 : $jobType.hashCode());
        String $jsonJob = this.getJsonJob();
        result = result * 59 + ($jsonJob == null ? 43 : $jsonJob.hashCode());
        TaskState $state = this.getState();
        result = result * 59 + ($state == null ? 43 : $state.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "TaskExecutionRequestDto(taskId=" + String.valueOf(this.getTaskId()) + ", executionId=" + String.valueOf(this.getExecutionId()) + ", tenantId=" + String.valueOf(this.getTenantId()) + ", customerId=" + String.valueOf(this.getCustomerId()) + ", userId=" + String.valueOf(this.getUserId()) + ", scheduled=" + this.isScheduled() + ", jobType=" + String.valueOf(this.getJobType()) + ", jsonJob=" + this.getJsonJob() + ", createdTs=" + this.getCreatedTs() + ", state=" + String.valueOf(this.getState()) + ")";
    }

    @Generated
    public TaskExecutionRequestDto() {
    }

    @Generated
    public TaskExecutionRequestDto(UUID taskId, UUID executionId, UUID tenantId, UUID customerId, UUID userId, boolean scheduled, TaskJobType jobType, String jsonJob, long createdTs, TaskState state) {
        this.taskId = taskId;
        this.executionId = executionId;
        this.tenantId = tenantId;
        this.customerId = customerId;
        this.userId = userId;
        this.scheduled = scheduled;
        this.jobType = jobType;
        this.jsonJob = jsonJob;
        this.createdTs = createdTs;
        this.state = state;
    }
}

