/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.dao.task;

import java.util.UUID;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.CrudRepository;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;
import org.thingsboard.trendz.dao.task.TaskExecutionDto;
import org.thingsboard.trendz.service.task.model.TaskExecutionLite;
import org.thingsboard.trendz.service.task.model.TaskExecutionStatus;

@Repository
public interface TaskExecutionRepository
extends CrudRepository<TaskExecutionDto, UUID> {
    @Query(value="SELECT new org.thingsboard.trendz.service.task.model.TaskExecutionLite(\n    te.id, te.taskId, t.name, t.jobType, t.reference.type, te.status, te.createdTs, te.startTs, te.finishTs, te.duration\n)\nFROM TaskExecutionDto te\nINNER JOIN TaskDto t ON te.taskId = t.id\nWHERE te.taskId = :taskId AND\n    t.tenantId = :tenantId AND\n    (coalesce(:customerId, null) IS NULL OR t.customerId = :customerId) AND\n    (coalesce(:status, null) IS NULL OR te.status = :status)\n")
    public Page<TaskExecutionLite> findAllLiteByTaskId(@Param(value="taskId") UUID var1, @Param(value="tenantId") UUID var2, @Param(value="customerId") UUID var3, @Param(value="status") TaskExecutionStatus var4, Pageable var5);

    @Query(value="SELECT new org.thingsboard.trendz.service.task.model.TaskExecutionLite(\n    te.id, te.taskId, t.name, t.jobType, t.reference.type, te.status, te.createdTs, te.startTs, te.finishTs, te.duration\n)\nFROM TaskExecutionDto te\nINNER JOIN TaskDto t ON te.taskId = t.id\nWHERE t.tenantId = :tenantId AND\n    (coalesce(:customerId, null) IS NULL OR t.customerId = :customerId) AND\n    (coalesce(:status, null) IS NULL OR te.status = :status)\n")
    public Page<TaskExecutionLite> findAllLite(@Param(value="tenantId") UUID var1, @Param(value="customerId") UUID var2, @Param(value="status") TaskExecutionStatus var3, Pageable var4);

    @Query(value="DELETE FROM TaskExecutionDto te\nWHERE\n    te.status <> 'CREATED' AND te.status <> 'RUNNING' AND\n    te.taskId IN (\n    SELECT t.id\n    FROM TaskDto t\n    WHERE\n        t.tenantId = :tenantId AND\n        (coalesce(:customerId, null) IS NULL OR t.customerId = :customerId)\n    )\n")
    @Modifying
    public void deleteAll(@Param(value="tenantId") UUID var1, @Param(value="customerId") UUID var2);
}

