/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.dao.task;

import jakarta.transaction.Transactional;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.JpaSort;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.dao.task.TaskAndExecutionInfoDto;
import org.thingsboard.trendz.dao.task.TaskDto;
import org.thingsboard.trendz.dao.task.TaskExecutionDto;
import org.thingsboard.trendz.dao.task.TaskExecutionProgressStepRepository;
import org.thingsboard.trendz.dao.task.TaskExecutionRepository;
import org.thingsboard.trendz.dao.task.TaskExecutionRequestDto;
import org.thingsboard.trendz.dao.task.TaskExecutionRequestDtoId;
import org.thingsboard.trendz.dao.task.TaskExecutionRequestRepository;
import org.thingsboard.trendz.dao.task.TaskExecutionState;
import org.thingsboard.trendz.dao.task.TaskExecutionStateRecordDto;
import org.thingsboard.trendz.dao.task.TaskExecutionStateRecordRepository;
import org.thingsboard.trendz.dao.task.TaskRepository;
import org.thingsboard.trendz.dao.task.TaskSchedulingStateRecordDto;
import org.thingsboard.trendz.dao.task.TaskSchedulingStateRecordRepository;
import org.thingsboard.trendz.dao.task.TaskState;
import org.thingsboard.trendz.domain.definition.view.config.ViewConfigTaskStatusData;
import org.thingsboard.trendz.exception.task.TaskNotFoundException;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.service.task.TaskExecutionProgressContent;
import org.thingsboard.trendz.service.task.TaskJob;
import org.thingsboard.trendz.service.task.TaskJobExecutorManager;
import org.thingsboard.trendz.service.task.model.Task;
import org.thingsboard.trendz.service.task.model.TaskExecution;
import org.thingsboard.trendz.service.task.model.TaskExecutionFilteringField;
import org.thingsboard.trendz.service.task.model.TaskExecutionLite;
import org.thingsboard.trendz.service.task.model.TaskExecutionProgress;
import org.thingsboard.trendz.service.task.model.TaskExecutionProgressStep;
import org.thingsboard.trendz.service.task.model.TaskExecutionRequest;
import org.thingsboard.trendz.service.task.model.TaskExecutionSortingField;
import org.thingsboard.trendz.service.task.model.TaskExecutionStatus;
import org.thingsboard.trendz.service.task.model.TaskFilteringField;
import org.thingsboard.trendz.service.task.model.TaskJobType;
import org.thingsboard.trendz.service.task.model.TaskLite;
import org.thingsboard.trendz.service.task.model.TaskReference;
import org.thingsboard.trendz.service.task.model.TaskReferencedEntityType;
import org.thingsboard.trendz.service.task.model.TaskSortingField;
import org.thingsboard.trendz.tools.UUIDUtils;
import org.thingsboard.trendz.tools.json.JsonUtils;

@Service
@Transactional
public class TaskDao {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TaskDao.class);
    private final TaskJobExecutorManager taskJobExecutorManager;
    private final TaskRepository taskRepository;
    private final TaskExecutionRepository taskExecutionRepository;
    private final TaskSchedulingStateRecordRepository taskSchedulingStateRecordRepository;
    private final TaskExecutionRequestRepository taskExecutionRequestRepository;
    private final TaskExecutionStateRecordRepository taskExecutionStateRecordRepository;
    private final TaskExecutionProgressStepRepository taskExecutionProgressStepRepository;

    @Autowired
    public TaskDao(TaskJobExecutorManager taskJobExecutorManager, TaskRepository taskRepository, TaskExecutionRepository taskExecutionRepository, TaskSchedulingStateRecordRepository taskSchedulingStateRecordRepository, TaskExecutionRequestRepository taskExecutionRequestRepository, TaskExecutionStateRecordRepository taskExecutionStateRecordRepository, TaskExecutionProgressStepRepository taskExecutionProgressStepRepository) {
        this.taskJobExecutorManager = taskJobExecutorManager;
        this.taskRepository = taskRepository;
        this.taskExecutionRepository = taskExecutionRepository;
        this.taskSchedulingStateRecordRepository = taskSchedulingStateRecordRepository;
        this.taskExecutionRequestRepository = taskExecutionRequestRepository;
        this.taskExecutionStateRecordRepository = taskExecutionStateRecordRepository;
        this.taskExecutionProgressStepRepository = taskExecutionProgressStepRepository;
    }

    public Page<TaskLite> getAllLite(JwtSecurityUser user, int page, int pageSize, List<TaskFilteringField> filteringFields, List<TaskSortingField> sortingFields) {
        List<Sort.Order> orders;
        Set referencedEntityTypeSet;
        Set referencedEntityKeySet;
        String jobNameFilter;
        TaskJobType jobType;
        Map<TaskFilteringField.Type, String> filterMap;
        Boolean enabled;
        UUID customerId;
        UUID tenantId = user.getTenantId();
        Page taskPage = this.taskRepository.findAllLiteByTenantIdAndCustomerId(tenantId, customerId = UUIDUtils.mapNullUuidToNull((UUID)user.getCustomerId()), enabled = (Boolean)Optional.ofNullable((filterMap = filteringFields.stream().filter(filteringField -> !filteringField.getType().equals((Object)TaskFilteringField.Type.REFERENCE_KEY)).filter(filteringField -> !filteringField.getType().equals((Object)TaskFilteringField.Type.REFERENCE_TYPE)).collect(Collectors.toMap(TaskFilteringField::getType, TaskFilteringField::getValue))).get(TaskFilteringField.Type.ENABLED)).map(Boolean::parseBoolean).orElse(null), jobType = (TaskJobType)Optional.ofNullable(filterMap.get(TaskFilteringField.Type.JOB_TYPE)).map(TaskJobType::valueOf).orElse(null), jobNameFilter = (String)Optional.ofNullable(filterMap.get(TaskFilteringField.Type.NAME)).map(urlEncodedJobNameParam -> URLDecoder.decode(urlEncodedJobNameParam, StandardCharsets.UTF_8)).orElse(null), referencedEntityKeySet = filteringFields.stream().filter(filteringField -> filteringField.getType().equals((Object)TaskFilteringField.Type.REFERENCE_KEY)).map(TaskFilteringField::getValue).collect(Collectors.collectingAndThen(Collectors.toSet(), set -> set.isEmpty() ? null : set)), referencedEntityTypeSet = filteringFields.stream().filter(filteringField -> filteringField.getType().equals((Object)TaskFilteringField.Type.REFERENCE_TYPE)).map(TaskFilteringField::getValue).map(TaskReferencedEntityType::valueOf).collect(Collectors.collectingAndThen(Collectors.toSet(), set -> set.isEmpty() ? null : set)), (Pageable)PageRequest.of((int)page, (int)pageSize, (Sort)Sort.by(orders = sortingFields.stream().map(sortingField -> {
            TaskSortingField.Type type = sortingField.type();
            return type.isUnsafe() ? JpaSort.unsafe((Sort.Direction)sortingField.direction(), (String[])new String[]{type.getSortingParameter()}).getOrderFor(type.getSortingParameter()) : new Sort.Order(sortingField.direction(), type.getValue());
        }).toList())));
        Set taskIdSet = taskPage.getContent().stream().map(TaskLite::getId).collect(Collectors.toSet());
        Map taskIdToExecutionIdToStatusMap = taskIdSet.isEmpty() ? Collections.emptyMap() : this.taskRepository.findAllExecutionsInfoByTaskIdSet(taskIdSet).stream().collect(Collectors.groupingBy(TaskAndExecutionInfoDto::getTaskId, Collectors.toMap(TaskAndExecutionInfoDto::getExecutionId, TaskAndExecutionInfoDto::getExecutionStatus)));
        taskPage.getContent().forEach(taskLite -> {
            Map statusMap = taskIdToExecutionIdToStatusMap.computeIfAbsent(taskLite.getId(), key -> Collections.emptyMap());
            taskLite.setExecutionStatusMap(statusMap);
        });
        return taskPage;
    }

    public Page<Task> getAll(JwtSecurityUser user, int page, int pageSize, List<TaskFilteringField> filteringFields, List<TaskSortingField> sortingFields) {
        UUID tenantId = user.getTenantId();
        UUID customerId = UUIDUtils.mapNullUuidToNull((UUID)user.getCustomerId());
        Map<TaskFilteringField.Type, String> filterMap = filteringFields.stream().filter(filteringField -> !filteringField.getType().equals((Object)TaskFilteringField.Type.REFERENCE_KEY)).filter(filteringField -> !filteringField.getType().equals((Object)TaskFilteringField.Type.REFERENCE_TYPE)).collect(Collectors.toMap(TaskFilteringField::getType, TaskFilteringField::getValue));
        Boolean enabled = Optional.ofNullable(filterMap.get(TaskFilteringField.Type.ENABLED)).map(Boolean::parseBoolean).orElse(null);
        TaskJobType jobType = Optional.ofNullable(filterMap.get(TaskFilteringField.Type.JOB_TYPE)).map(TaskJobType::valueOf).orElse(null);
        String jobNameFilter = Optional.ofNullable(filterMap.get(TaskFilteringField.Type.NAME)).map(urlEncodedJobNameParam -> URLDecoder.decode(urlEncodedJobNameParam, StandardCharsets.UTF_8)).orElse(null);
        Set referencedEntityKeySet = filteringFields.stream().filter(filteringField -> filteringField.getType().equals((Object)TaskFilteringField.Type.REFERENCE_KEY)).map(TaskFilteringField::getValue).collect(Collectors.collectingAndThen(Collectors.toSet(), set -> set.isEmpty() ? null : set));
        Set referencedEntityTypeSet = filteringFields.stream().filter(filteringField -> filteringField.getType().equals((Object)TaskFilteringField.Type.REFERENCE_TYPE)).map(TaskFilteringField::getValue).map(TaskReferencedEntityType::valueOf).collect(Collectors.collectingAndThen(Collectors.toSet(), set -> set.isEmpty() ? null : set));
        List orders = sortingFields.stream().map(sortingField -> new Sort.Order(sortingField.direction(), sortingField.type().getValue())).collect(Collectors.toList());
        return this.taskRepository.findAllByTenantIdAndCustomerId(tenantId, customerId, enabled, jobType, jobNameFilter, referencedEntityKeySet, referencedEntityTypeSet, (Pageable)PageRequest.of((int)page, (int)pageSize, (Sort)Sort.by(orders))).map(arg_0 -> this.mapTaskWithType(arg_0));
    }

    public Optional<Task> findById(JwtSecurityUser user, UUID taskId) {
        return this.findById(user, taskId, false);
    }

    public Optional<Task> findById(JwtSecurityUser user, UUID taskId, boolean insecure) {
        UUID tenantId = user.getTenantId();
        UUID customerId = UUIDUtils.mapNullUuidToNull((UUID)user.getCustomerId());
        return this.taskRepository.findByIdAndTenantIdAndCustomerId(taskId, tenantId, customerId, insecure).map(arg_0 -> this.mapTaskWithType(arg_0));
    }

    public Optional<Task> findTaskByReferencedEntity(JwtSecurityUser user, TaskReference reference, boolean insecure) {
        UUID tenantId = user.getTenantId();
        UUID customerId = UUIDUtils.mapNullUuidToNull((UUID)user.getCustomerId());
        return this.taskRepository.findTaskByReferencedEntityAndTenantIdAndCustomerId(tenantId, customerId, reference.getType(), reference.getKey(), insecure).map(arg_0 -> this.mapTaskWithType(arg_0));
    }

    public Page<TaskExecutionLite> getAllExecutionsLite(JwtSecurityUser user, int page, int pageSize, List<TaskExecutionFilteringField> filteringFields, List<TaskExecutionSortingField> sortingFields) {
        UUID tenantId = user.getTenantId();
        UUID customerId = UUIDUtils.mapNullUuidToNull((UUID)user.getCustomerId());
        Map<TaskExecutionFilteringField.Type, String> filterMap = filteringFields.stream().collect(Collectors.toMap(TaskExecutionFilteringField::getType, TaskExecutionFilteringField::getValue));
        TaskExecutionStatus status = Optional.ofNullable(filterMap.get(TaskExecutionFilteringField.Type.STATUS)).map(TaskExecutionStatus::parse).orElse(null);
        List orders = sortingFields.stream().map(sortingField -> new Sort.Order(sortingField.direction(), sortingField.type().getValue())).collect(Collectors.toList());
        return this.taskExecutionRepository.findAllLite(tenantId, customerId, status, (Pageable)PageRequest.of((int)page, (int)pageSize, (Sort)Sort.by(orders)));
    }

    public Page<TaskExecutionLite> getAllExecutionsByTaskLite(JwtSecurityUser user, UUID taskId, int page, int pageSize, List<TaskExecutionFilteringField> filteringFields, List<TaskExecutionSortingField> sortingFields) {
        UUID tenantId = user.getTenantId();
        UUID customerId = UUIDUtils.mapNullUuidToNull((UUID)user.getCustomerId());
        Map<TaskExecutionFilteringField.Type, String> filterMap = filteringFields.stream().collect(Collectors.toMap(TaskExecutionFilteringField::getType, TaskExecutionFilteringField::getValue));
        TaskExecutionStatus status = Optional.ofNullable(filterMap.get(TaskExecutionFilteringField.Type.STATUS)).map(TaskExecutionStatus::parse).orElse(null);
        List orders = sortingFields.stream().map(sortingField -> new Sort.Order(sortingField.direction(), sortingField.type().getValue())).collect(Collectors.toList());
        return this.taskExecutionRepository.findAllLiteByTaskId(taskId, tenantId, customerId, status, (Pageable)PageRequest.of((int)page, (int)pageSize, (Sort)Sort.by(orders)));
    }

    public Optional<TaskExecution> findExecutionById(JwtSecurityUser user, UUID executionId) {
        UUID tenantId = user.getTenantId();
        UUID customerId = UUIDUtils.mapNullUuidToNull((UUID)user.getCustomerId());
        return this.taskRepository.findExecutionByIdAndTenantIdAndCustomerId(executionId, tenantId, customerId).map(arg_0 -> this.mapTaskExecutionWithType(arg_0));
    }

    public Task saveTask(Task task) {
        TaskDto taskDto = TaskDto.from((Task)task);
        TaskDto savedDto = (TaskDto)this.taskRepository.save((Object)taskDto);
        return this.mapTaskWithType(savedDto);
    }

    public void deleteTask(JwtSecurityUser user, UUID taskId) {
        Task task = (Task)this.findById(user, taskId).orElseThrow(() -> new TaskNotFoundException(taskId));
        this.taskRepository.deleteById((Object)task.getId());
    }

    public void updateTaskJob(UUID taskId, TaskJob job) {
        this.taskRepository.updateTaskJob(taskId, JsonUtils.toJson((Object)job));
    }

    public void updateTaskEnabled(UUID taskId, boolean enabled) {
        this.taskRepository.updateTaskEnabled(taskId, enabled);
    }

    public void saveExecution(TaskExecution execution) {
        TaskExecutionDto dto = TaskExecutionDto.from((TaskExecution)execution);
        this.taskExecutionRepository.save((Object)dto);
    }

    public Optional<Long> getTaskSchedulingTime(UUID taskId) {
        return this.taskSchedulingStateRecordRepository.findById((Object)taskId).map(TaskSchedulingStateRecordDto::getLastFinishTs);
    }

    public void saveTaskScheduleRecord(UUID taskId, TaskState state, long ts) {
        TaskSchedulingStateRecordDto recordDto = new TaskSchedulingStateRecordDto(taskId, state, ts);
        this.taskSchedulingStateRecordRepository.save((Object)recordDto);
    }

    public void removeTaskScheduleRecord(UUID taskId) {
        this.taskSchedulingStateRecordRepository.deleteById((Object)taskId);
    }

    public Optional<TaskExecutionRequest> findExecutionRequest(JwtSecurityUser user, UUID executionId) {
        UUID tenantId = user.getTenantId();
        UUID customerId = UUIDUtils.mapNullUuidToNull((UUID)user.getCustomerId());
        return this.taskExecutionRequestRepository.findByExecutionIdAndTenantIdAndCustomerId(executionId, tenantId, customerId).map(arg_0 -> this.mapTaskExecutionRequestWithType(arg_0));
    }

    public void saveExecutionRequest(TaskExecutionRequest executionRequest) {
        TaskExecutionRequestDto requestDto = TaskExecutionRequestDto.from((TaskExecutionRequest)executionRequest);
        TaskExecutionRequestDto savedDto = (TaskExecutionRequestDto)this.taskExecutionRequestRepository.save((Object)requestDto);
        TaskExecutionRequest saved = this.mapTaskExecutionRequestWithType(savedDto);
    }

    public void removeExecutionRequest(UUID taskId, UUID executionId) {
        TaskExecutionRequestDtoId id = new TaskExecutionRequestDtoId(taskId, executionId);
        this.taskExecutionRequestRepository.deleteById((Object)id);
    }

    public void cancelTaskExecutionsForTask(JwtSecurityUser user, UUID taskId, boolean removedTask) {
        UUID tenantId = user.getTenantId();
        UUID customerId = UUIDUtils.mapNullUuidToNull((UUID)user.getCustomerId());
        this.taskExecutionRequestRepository.removeAllByTaskIdAndTenantIdAndCustomerId(taskId, tenantId, customerId);
        this.taskExecutionStateRecordRepository.cancelByTaskIdAndTenantIdAndCustomerId(taskId, user.getTenantId(), user.getCustomerId(), removedTask);
    }

    public void cancelTaskExecutionsForUser(JwtSecurityUser user) {
        UUID tenantId = user.getTenantId();
        UUID customerId = UUIDUtils.mapNullUuidToNull((UUID)user.getCustomerId());
        this.taskExecutionRequestRepository.removeAllByTenantIdAndCustomerId(tenantId, customerId);
        this.taskExecutionStateRecordRepository.cancelByTenantIdAndCustomerId(user.getTenantId(), user.getCustomerId());
    }

    public void deleteAllExecutions(JwtSecurityUser user) {
        UUID tenantId = user.getTenantId();
        UUID customerId = UUIDUtils.mapNullUuidToNull((UUID)user.getCustomerId());
        this.taskExecutionRepository.deleteAll(tenantId, customerId);
    }

    public void saveTaskExecutionStateRecords(UUID executionId, TaskExecutionState state, boolean removedTask) {
        long now = System.currentTimeMillis();
        TaskExecutionStateRecordDto recordDto = new TaskExecutionStateRecordDto(executionId, state, now, removedTask);
        this.taskExecutionStateRecordRepository.save((Object)recordDto);
    }

    public void updateTaskExecutionStateRecords(Set<UUID> executionIdSet, TaskExecutionState state) {
        if (!executionIdSet.isEmpty()) {
            long now = System.currentTimeMillis();
            this.taskExecutionStateRecordRepository.updateBatch(executionIdSet, state.name(), now);
        }
    }

    public void removeTaskExecutionStateRecord(UUID executionId) {
        this.taskExecutionStateRecordRepository.deleteById((Object)executionId);
    }

    public void removeExpiredTaskExecutionsByTtl() {
        long now = System.currentTimeMillis();
        int expiredTaskExecutionCount = this.taskRepository.deleteExpiredTaskExecutions(now);
        int exceedingTaskExecutionCount = this.taskRepository.deleteExceedingTaskExecutions();
        log.debug("Task TTL: {} executions are expired, {} executions are exceeding", (Object)expiredTaskExecutionCount, (Object)exceedingTaskExecutionCount);
    }

    public void processLostTaskExecutions(long recordTimeout) {
        long now = System.currentTimeMillis();
        List lostIdExecutionPairList = this.taskRepository.loadLostTaskExecutions(recordTimeout, now);
        Set executionIds = lostIdExecutionPairList.stream().map(array -> UUID.fromString(array[0].toString())).collect(Collectors.toSet());
        Set taskIds = lostIdExecutionPairList.stream().map(array -> UUID.fromString(array[1].toString())).collect(Collectors.toSet());
        List lostIdRequestPairList = this.taskRepository.findLostTaskExecutionRequests(executionIds);
        if (!executionIds.isEmpty()) {
            this.taskRepository.labelLostTaskExecutions(executionIds, now);
            this.taskRepository.deleteTaskExecutionStateRecordsByIdSet(executionIds);
        }
        if (!lostIdRequestPairList.isEmpty()) {
            Set requestExecutionIds = lostIdRequestPairList.stream().map(array -> UUID.fromString(array[0].toString())).collect(Collectors.toSet());
            Set requestTaskIds = lostIdRequestPairList.stream().map(array -> UUID.fromString(array[1].toString())).collect(Collectors.toSet());
            taskIds.addAll(requestTaskIds);
            this.taskRepository.removeAllExecutionRequestsByExecutionIdSet(requestExecutionIds);
        }
        if (!taskIds.isEmpty()) {
            this.taskRepository.labelLostTaskStateRecords(taskIds, now);
        }
        log.debug("Task Lost: {} executions were lost", (Object)executionIds.size());
    }

    public Set<TaskExecutionStateRecordDto> findCancelledTaskExecutionIds(Set<UUID> currentTaskExecutionIds) {
        if (currentTaskExecutionIds.isEmpty()) {
            return Collections.emptySet();
        }
        return this.taskRepository.findCancelledTaskExecutionIds(currentTaskExecutionIds).stream().map(array -> new TaskExecutionStateRecordDto(UUID.fromString((String)array[0]), TaskExecutionState.parse((String)((String)array[1])), ((Number)array[2]).longValue(), ((Boolean)array[3]).booleanValue())).collect(Collectors.toSet());
    }

    public boolean updateProgress(UUID executionId, TaskExecutionProgress progress) {
        TaskExecutionProgressContent content = progress.getContent();
        TaskExecutionProgressStep rootStep = progress.getRootStep();
        String jsonContent = JsonUtils.toJson((Object)content);
        List stepDtos = TaskExecutionDto.mapExecutionSteps((TaskExecutionProgressStep)rootStep);
        if (this.taskExecutionRepository.findById((Object)executionId).isEmpty()) {
            return false;
        }
        this.taskExecutionProgressStepRepository.updateProgressContent(executionId, jsonContent);
        this.taskExecutionProgressStepRepository.saveAll((Iterable)stepDtos);
        return true;
    }

    public Optional<TaskExecutionRequest> findAndBorrowTaskExecutionRequest() {
        return this.taskRepository.findNextExecutionRequest().flatMap(array -> {
            if (((Object[][])array).length == 0) {
                return Optional.empty();
            }
            return Optional.of(new TaskExecutionRequestDtoId(UUID.fromString((String)array[0][0]), UUID.fromString((String)array[0][1])));
        }).flatMap(arg_0 -> ((TaskExecutionRequestRepository)this.taskExecutionRequestRepository).findById(arg_0)).map(arg_0 -> this.mapTaskExecutionRequestWithType(arg_0)).map(executionRequest -> {
            executionRequest.setState(TaskState.BORROWED);
            this.saveExecutionRequest(executionRequest);
            return executionRequest;
        });
    }

    public void findAndBorrowTaskAndDoAction(Consumer<Task> action) {
        long now = System.currentTimeMillis();
        this.taskRepository.findNextPlannedTask(now).or(() -> this.taskRepository.findNextPeriodicTask(now)).or(() -> this.taskRepository.findNextScheduledTask(now)).flatMap(arg_0 -> ((TaskRepository)this.taskRepository).findById(arg_0)).map(arg_0 -> this.mapTaskWithTypeLite(arg_0)).map(nextTask -> {
            this.saveTaskScheduleRecord(nextTask.getId(), TaskState.BORROWED, now);
            return nextTask;
        }).ifPresent(action);
    }

    public List<ViewConfigTaskStatusData> getViewConfigStatusData(UUID tenantId, Set<UUID> configIdSet) {
        return this.taskRepository.getViewConfigStatusData(tenantId, configIdSet).stream().map(dataArray -> ViewConfigTaskStatusData.builder().viewConfigId(UUID.fromString(dataArray[0].toString())).statusCacheReference((String)dataArray[1]).statusSaveReference((String)dataArray[2]).statusCacheTask((String)dataArray[3]).statusSaveTask((String)dataArray[4]).statusCacheExecution((String)dataArray[5]).statusSaveExecution((String)dataArray[6]).build()).collect(Collectors.toList());
    }

    private Task mapTaskWithType(TaskDto dto) {
        TaskJobType jobType = dto.getJobType();
        Class jobClass = this.taskJobExecutorManager.getJobClassByType(jobType);
        Class progressContentClass = this.taskJobExecutorManager.getProgressContentClassByType(jobType);
        return dto.toData(jobClass, progressContentClass);
    }

    private Task mapTaskWithTypeLite(TaskDto dto) {
        TaskJobType jobType = dto.getJobType();
        Class jobClass = this.taskJobExecutorManager.getJobClassByType(jobType);
        return dto.toDataLite(jobClass);
    }

    private TaskExecution mapTaskExecutionWithType(TaskExecutionDto dto) {
        TaskJobType jobType = dto.getJobType();
        Class jobClass = this.taskJobExecutorManager.getJobClassByType(jobType);
        Class progressContentClass = this.taskJobExecutorManager.getProgressContentClassByType(jobType);
        return dto.toData(jobClass, progressContentClass);
    }

    private TaskExecutionRequest mapTaskExecutionRequestWithType(TaskExecutionRequestDto dto) {
        TaskJobType jobType = dto.getJobType();
        Class jobClass = this.taskJobExecutorManager.getJobClassByType(jobType);
        return dto.toData(jobClass);
    }
}

