/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.dao.predict;

import com.google.common.collect.Lists;
import jakarta.transaction.Transactional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.dao.predict.CustomPredictionModelDto;
import org.thingsboard.trendz.dao.predict.CustomPredictionModelRepository;
import org.thingsboard.trendz.domain.prediction.CustomPredictionModel;
import org.thingsboard.trendz.exception.predict.CustomPredictionModelNotFoundException;

@Service
@Transactional
public class CustomPredictionModelDao {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CustomPredictionModelDao.class);
    private final CustomPredictionModelRepository customPredictionModelRepository;

    @Autowired
    public CustomPredictionModelDao(CustomPredictionModelRepository customPredictionModelRepository) {
        this.customPredictionModelRepository = customPredictionModelRepository;
    }

    public Set<CustomPredictionModel> getAll() {
        return Lists.newArrayList((Iterable)this.customPredictionModelRepository.findAll()).stream().map(CustomPredictionModelDto::toData).collect(Collectors.toSet());
    }

    public CustomPredictionModel getById(UUID id) throws CustomPredictionModelNotFoundException {
        return this.customPredictionModelRepository.findById((Object)id).map(CustomPredictionModelDto::toData).orElseThrow(() -> new CustomPredictionModelNotFoundException(id));
    }

    public CustomPredictionModel save(CustomPredictionModel model) {
        return ((CustomPredictionModelDto)this.customPredictionModelRepository.save((Object)CustomPredictionModelDto.from((CustomPredictionModel)model))).toData();
    }

    public void delete(UUID id) throws CustomPredictionModelNotFoundException {
        this.customPredictionModelRepository.deleteById((Object)id);
    }
}

