/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.dao.model.prediction.segment;

import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.CrudRepository;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;
import org.thingsboard.trendz.dao.model.prediction.segment.SegmentDataDto;

@Repository
public interface SegmentDataRepository
extends CrudRepository<SegmentDataDto, UUID> {
    @Query(value="select sgd\nfrom SegmentDataDto sgd\nwhere sgd.modelId in (\n    select pmd.id\n    from PredictionModelDto pmd\n    where\n        pmd.tenantId = :tenantId and\n        (coalesce(:customerId, null) is null or pmd.customerId = :customerId))\n")
    public List<SegmentDataDto> findAllByTenantIdAndCustomerId(@Param(value="tenantId") UUID var1, @Param(value="customerId") UUID var2);

    @Query(value="select sgd\nfrom SegmentDataDto sgd\nwhere\n    sgd.modelId = :modelId AND\n    (coalesce(:itemIdSet, null) is null or sgd.itemId in (:itemIdSet))\n")
    public Set<SegmentDataDto> findAllByModelIdAndItemIdSet(@Param(value="modelId") UUID var1, @Param(value="itemIdSet") Set<UUID> var2);

    @Modifying
    @Query(nativeQuery=true, value="DELETE FROM segment_data\nWHERE id IN (\n    SELECT sgd.id\n    FROM segment_data sgd\n    WHERE sgd.model_id = :modelId\n    AND sgd.id NOT IN (\n        SELECT sgd2.id\n        FROM segment_data sgd2\n        WHERE sgd2.model_id = sgd.model_id AND sgd2.item_id = sgd.item_id\n        ORDER BY sgd2.range_start_ts DESC\n        LIMIT :n\n    )\n)\n")
    public void deleteAllExceptLastNByModelId(@Param(value="modelId") UUID var1, @Param(value="n") int var2);

    @Modifying
    @Query(value="delete from SegmentDataDto sgd where sgd.modelId = :modelId")
    public void deleteAllByModelId(@Param(value="modelId") UUID var1);
}

