/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.dao.model.prediction;

import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.CrudRepository;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;
import org.thingsboard.trendz.dao.model.prediction.PredictionModelDto;
import org.thingsboard.trendz.domain.summary.TrendzEntityUsage;
import org.thingsboard.trendz.service.model.prediction.PredictionModelLite;
import org.thingsboard.trendz.service.model.prediction.PredictionModelStatus;
import org.thingsboard.trendz.service.model.prediction.methods.PredictionMethodType;

@Repository
public interface PredictionModelRepository
extends CrudRepository<PredictionModelDto, UUID> {
    @Query(value="SELECT new org.thingsboard.trendz.service.model.prediction.PredictionModelLite(\n   pm.id, pm.name, pm.enabled, pm.createdTs, pm.updatedTs, pm.status, pm.type, pm.businessEntityId, pm.businessEntityFieldId\n)\nFROM PredictionModelDto pm\nWHERE pm.tenantId = :tenantId AND\n(coalesce(:customerId, null) IS NULL OR pm.customerId = :customerId) AND\n(coalesce(:name, null) IS NULL OR LOWER(pm.name) LIKE %:name%) AND\n(coalesce(:enabled, null) IS NULL OR pm.enabled = :enabled) AND\n(coalesce(:status, null) IS NULL OR pm.status = :status) AND\n(coalesce(:type, null) IS NULL OR pm.type = :type) AND\n(coalesce(:businessEntityIdSet, null) IS NULL OR pm.businessEntityId in (:businessEntityIdSet))\n")
    public Page<PredictionModelLite> findAllLiteByTenantIdAndCustomerId(@Param(value="tenantId") UUID var1, @Param(value="customerId") UUID var2, @Param(value="name") String var3, @Param(value="enabled") Boolean var4, @Param(value="status") PredictionModelStatus var5, @Param(value="type") PredictionMethodType var6, @Param(value="businessEntityIdSet") Set<UUID> var7, Pageable var8);

    @Query(value="select pm\nfrom PredictionModelDto pm\nwhere pm.tenantId = :tenantId and\n(coalesce(:customerId, null) is null or pm.customerId = :customerId)\n")
    public List<PredictionModelDto> findByTenantIdAndCustomerId(@Param(value="tenantId") UUID var1, @Param(value="customerId") UUID var2);

    @Query(value="select pm\nfrom PredictionModelDto pm\nwhere\n    pm.id = :id and\n    pm.tenantId = :tenantId and\n    (:insecure = TRUE OR coalesce(:customerId, null) is null or pm.customerId = :customerId)\n")
    public Optional<PredictionModelDto> findByIdAndTenantIdAndCustomerId(@Param(value="id") UUID var1, @Param(value="tenantId") UUID var2, @Param(value="customerId") UUID var3, @Param(value="insecure") boolean var4);

    @Query(value="delete from PredictionModelDto pm\nwhere\n    pm.id = :id and\n    pm.tenantId = :tenantId and\n    (coalesce(:customerId, null) is null or pm.customerId = :customerId)\n")
    @Modifying
    public void deleteByIdAndTenantIdAndCustomerId(@Param(value="id") UUID var1, @Param(value="tenantId") UUID var2, @Param(value="customerId") UUID var3);

    @Query(value="update PredictionModelDto pm\nset pm.status = :status\nwhere\n    pm.id = :id and\n    pm.tenantId = :tenantId and\n    (coalesce(:customerId, null) is null or pm.customerId = :customerId)\n")
    @Modifying
    public void updateStatusByIdAndTenantIdAndCustomerId(@Param(value="id") UUID var1, @Param(value="tenantId") UUID var2, @Param(value="customerId") UUID var3, @Param(value="status") PredictionModelStatus var4);

    @Query(value="update PredictionModelDto pm\nset pm.enabled = :enabled\nwhere\n    pm.id = :id and\n    pm.tenantId = :tenantId and\n    (coalesce(:customerId, null) is null or pm.customerId = :customerId)\n")
    @Modifying
    public void updateEnablingByIdAndTenantIdAndCustomerId(@Param(value="id") UUID var1, @Param(value="tenantId") UUID var2, @Param(value="customerId") UUID var3, @Param(value="enabled") boolean var4);

    @Query(value="select pm.id\nfrom PredictionModelDto pm\nwhere pm.tbTelemetryKey = :queryKey and pm.tenantId = :tenantId\n")
    public Set<UUID> findAllIdsByTenantIdAndTbKey(@Param(value="queryKey") String var1, @Param(value="tenantId") UUID var2);

    @Query(value="select pm\nfrom PredictionModelDto pm\nwhere\n    pm.associatedEntityFieldId = :entityFieldId and\n    pm.tenantId = :tenantId and\n    (:insecure = TRUE OR coalesce(:customerId, null) is null or pm.customerId = :customerId)\n")
    public Optional<PredictionModelDto> findByAssociatedEntityFieldIdAndTenantIdAndCustomerId(@Param(value="entityFieldId") UUID var1, @Param(value="tenantId") UUID var2, @Param(value="customerId") UUID var3, @Param(value="insecure") boolean var4);

    @Query(value="select new org.apache.commons.lang3.tuple.ImmutablePair(pm.associatedEntityFieldId, pm.businessEntityFieldId)\nfrom PredictionModelDto pm\nwhere\n    pm.tenantId = :tenantId and\n    (coalesce(:customerId, null) is null or pm.customerId = :customerId) and\n    pm.associatedEntityFieldId in (:predictionModelFieldSet)\n")
    public List<Pair<UUID, UUID>> findWiredPredictionAndHistoricalFields(@Param(value="tenantId") UUID var1, @Param(value="customerId") UUID var2, @Param(value="predictionModelFieldSet") Set<UUID> var3);

    @Query(nativeQuery=true, value="WITH associated_entity_fields AS (\n    SELECT bef.id, bef.business_entity_id\n    FROM business_entity_field bef\n    WHERE bef.id IN (\n        SELECT pm.associated_entity_field_id\n        FROM prediction_model pm\n        WHERE pm.id = :id\n            AND pm.tenant_id = :tenantId\n            AND (:customerId = :nullId OR pm.customer_id = :customerId)\n    )\n)\n    SELECT 'BUSINESS_ENTITY' AS TYPE, be.name AS name\n    FROM business_entity be\n    WHERE be.id IN (\n        SELECT business_entity_id\n        FROM associated_entity_fields\n    )\nUNION\n    SELECT 'VIEW_CONFIG' AS TYPE, vc.name AS name\n    FROM view_config vc\n    WHERE vc.tenant_id = :tenantId\n        AND vc.customer_id IN :customerIdSet\n        AND vc.id IN (\n\t\t    SELECT vf.view_config_id\n\t\t    FROM view_field vf\n\t\t    WHERE vf.entity_field_id IN (\n\t\t\t\tSELECT id\n\t\t\t\tFROM associated_entity_fields\n           \t)\n        )\nUNION\n    SELECT 'ANOMALY_MODEL' AS TYPE, cm.name AS name\n    FROM cluster_model cm\n    WHERE cm.tenant_id = :tenantId\n        AND (:customerId = :nullId OR cm.customer_id = :customerId)\n        AND cm.dataset_config_id IN (\n\t\t    SELECT dc.id\n\t\t    FROM dataset_config dc\n\t\t    WHERE dc.id IN (\n\t\t\t\tSELECT vf.dataset_config_id\n\t\t\t\tFROM view_field vf\n\t\t\t\tWHERE vf.entity_field_id IN (\n\t\t\t\t\tSELECT id\n\t\t\t\t\tFROM associated_entity_fields\n                )\n   \t\t\t)\n        )\n")
    public List<Object[]> findDependedEntities(@Param(value="id") UUID var1, @Param(value="tenantId") UUID var2, @Param(value="customerId") UUID var3, @Param(value="customerIdSet") Set<UUID> var4, @Param(value="nullId") UUID var5);

    @Query(value="SELECT new org.thingsboard.trendz.domain.summary.TrendzEntityUsage(\n    COUNT(m) FILTER (WHERE m.enabled = true),\n    COUNT(m)\n)\nFROM PredictionModelDto m\nWHERE :tenantId = :nullId OR m.tenantId = :tenantId\n")
    public Optional<TrendzEntityUsage> findUsage(UUID var1, UUID var2);
}

