/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.dao.model.prediction;

import jakarta.transaction.Transactional;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.dao.model.prediction.PredictionModelLastItemPointDto;
import org.thingsboard.trendz.dao.model.prediction.PredictionModelLastItemPointRepository;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.tools.UUIDUtils;

@Service
@Transactional
public class PredictionModelLastItemPointDao {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PredictionModelLastItemPointDao.class);
    private final PredictionModelLastItemPointRepository repository;

    @Autowired
    public PredictionModelLastItemPointDao(PredictionModelLastItemPointRepository repository) {
        this.repository = repository;
    }

    public Map<UUID, Map<UUID, Long>> loadAll(JwtSecurityUser user) {
        UUID tenantId = user.getTenantId();
        UUID customerId = UUIDUtils.mapNullUuidToNull((UUID)user.getCustomerId());
        return this.repository.findAllByTenantIdAndCustomerId(tenantId, customerId).stream().collect(Collectors.toMap(PredictionModelLastItemPointDto::getPredictionModelId, dto -> Map.of(dto.getItemId(), dto.getTs()), (map1, map2) -> {
            HashMap merged = new HashMap(map1);
            merged.putAll(map2);
            return merged;
        }));
    }

    public void saveAll(JwtSecurityUser user, Map<UUID, Map<UUID, Long>> modelToItemToLastPointMap) {
        UUID tenantId = user.getTenantId();
        UUID customerId = UUIDUtils.mapNullUuidToNull((UUID)user.getCustomerId());
        Set predictionModelIds = this.repository.findAllPredictionModelIdsByTenantIdAndCustomerId(tenantId, customerId);
        Set fullSet = modelToItemToLastPointMap.entrySet().stream().filter(entry -> {
            UUID predictionModelId = (UUID)entry.getKey();
            return predictionModelIds.contains(predictionModelId);
        }).flatMap(entry1 -> {
            UUID predictionModelId = (UUID)entry1.getKey();
            Map itemToLastPoint = (Map)entry1.getValue();
            return itemToLastPoint.entrySet().stream().map(entry2 -> {
                UUID itemId = (UUID)entry2.getKey();
                Long lastPoint = (Long)entry2.getValue();
                return new PredictionModelLastItemPointDto(predictionModelId, itemId, lastPoint.longValue());
            });
        }).collect(Collectors.toSet());
        this.repository.saveAll(fullSet);
    }

    public Map<UUID, Long> getItemToLastPointMap(UUID predictionModelId) {
        return this.repository.findAllByPredictionModelId(predictionModelId).stream().collect(Collectors.toMap(PredictionModelLastItemPointDto::getItemId, PredictionModelLastItemPointDto::getTs));
    }

    public void saveItemToLastPointMap(UUID predictionModelId, Map<UUID, Long> itemToLastPointMap) {
        Set dtoSet = itemToLastPointMap.entrySet().stream().map(entry -> new PredictionModelLastItemPointDto(predictionModelId, (UUID)entry.getKey(), ((Long)entry.getValue()).longValue())).collect(Collectors.toSet());
        this.repository.saveAll(dtoSet);
    }

    public void deleteAllByModelId(UUID predictionModelId) {
        this.repository.deleteAllByPredictionModelId(predictionModelId);
    }
}

