/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.dao.model.prediction;

import com.fasterxml.jackson.annotation.JsonRawValue;
import com.fasterxml.jackson.databind.JavaType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.Id;
import jakarta.persistence.Table;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import lombok.Generated;
import org.thingsboard.trendz.dao.model.prediction.PredictionModelDto;
import org.thingsboard.trendz.domain.runtime.ItemLite;
import org.thingsboard.trendz.service.model.prediction.PredictionModel;
import org.thingsboard.trendz.service.model.prediction.PredictionModelDatasourceParameters;
import org.thingsboard.trendz.service.model.prediction.PredictionModelParameters;
import org.thingsboard.trendz.service.model.prediction.PredictionModelStatus;
import org.thingsboard.trendz.service.model.prediction.methods.PredictionMethodParameters;
import org.thingsboard.trendz.service.model.prediction.methods.PredictionMethodType;
import org.thingsboard.trendz.tools.json.JsonUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@Entity
@Table(name="prediction_model")
public class PredictionModelDto {
    @Id
    private UUID id;
    @Column(name="tenant_id")
    private UUID tenantId;
    @Column(name="customer_id")
    private UUID customerId;
    @Column(name="name")
    private String name;
    @Column(name="created_ts")
    private long createdTs;
    @Column(name="updated_ts")
    private long updatedTs;
    @Column(name="enabled")
    private boolean enabled;
    @Column(name="partial_fit_enabled")
    private boolean partialFitEnabled;
    @Column(name="status")
    @Enumerated(value=EnumType.STRING)
    private PredictionModelStatus status;
    @Column(name="type")
    @Enumerated(value=EnumType.STRING)
    private PredictionMethodType type;
    @Column(name="associated_entity_field_id")
    private UUID associatedEntityFieldId;
    @Column(name="tb_telemetry_key")
    private String tbTelemetryKey;
    @JsonRawValue
    @Column(name="model_parameters")
    private String modelParameters;
    @JsonRawValue
    @Column(name="method_parameters")
    private String methodParameters;
    @JsonRawValue
    @Column(name="datasource_parameters")
    private String datasourceParameters;
    @JsonRawValue
    @Column(name="item_state_map")
    private String itemStateMap;
    @JsonRawValue
    @Column(name="trained_item_set")
    private String trainedItemSet;
    @Column(name="business_entity_id")
    private UUID businessEntityId;
    @Column(name="business_entity_field_id")
    private UUID businessEntityFieldId;
    @Column(name="avoid_disabling")
    private boolean avoidDisabling;

    public static PredictionModelDto from(PredictionModel entity) {
        PredictionModelDatasourceParameters ds = entity.getDatasourceParameters();
        UUID businessEntityId = Optional.ofNullable(ds).map(PredictionModelDatasourceParameters::getBusinessEntityId).orElse(null);
        UUID businessEntityFieldId = Optional.ofNullable(ds).map(PredictionModelDatasourceParameters::getBusinessEntityFieldId).orElse(null);
        return PredictionModelDto.builder().id(entity.getId()).tenantId(entity.getTenantId()).customerId(entity.getCustomerId()).name(entity.getName()).createdTs(entity.getCreatedTs()).updatedTs(entity.getUpdatedTs()).enabled(entity.isEnabled()).partialFitEnabled(entity.isPartialFitEnabled()).status(entity.getStatus()).type(entity.getType()).associatedEntityFieldId(entity.getAssociatedBusinessEntityFieldId()).tbTelemetryKey(entity.getTbTelemetryKey()).modelParameters(JsonUtils.toJson((Object)entity.getModelParameters())).methodParameters(JsonUtils.toJson((Object)entity.getMethodParameters())).datasourceParameters(JsonUtils.toJson((Object)ds)).itemStateMap(JsonUtils.toJson((Object)entity.getItemIdToStateMap())).trainedItemSet(JsonUtils.toJson((Object)entity.getTrainedItemsSet())).businessEntityId(businessEntityId).businessEntityFieldId(businessEntityFieldId).avoidDisabling(entity.isAvoidDisabling()).build();
    }

    public PredictionModel toData() {
        return PredictionModel.builder().id(this.id).tenantId(this.tenantId).customerId(this.customerId).name(this.name).createdTs(this.createdTs).updatedTs(this.updatedTs).enabled(this.enabled).partialFitEnabled(this.partialFitEnabled).status(this.status).type(this.type).methodParameters((PredictionMethodParameters)JsonUtils.fromJson((String)this.methodParameters, PredictionMethodParameters.class)).associatedBusinessEntityFieldId(this.associatedEntityFieldId).tbTelemetryKey(this.tbTelemetryKey).modelParameters((PredictionModelParameters)JsonUtils.fromJson((String)this.modelParameters, PredictionModelParameters.class)).methodParameters((PredictionMethodParameters)JsonUtils.fromJson((String)this.methodParameters, PredictionMethodParameters.class)).datasourceParameters((PredictionModelDatasourceParameters)JsonUtils.fromJson((String)this.datasourceParameters, PredictionModelDatasourceParameters.class)).itemIdToStateMap((Map)JsonUtils.fromJson((String)this.itemStateMap, (JavaType)JsonUtils.getObjectMapper().getTypeFactory().constructMapType(HashMap.class, UUID.class, String.class))).trainedItemsSet((Set)JsonUtils.fromJson((String)this.trainedItemSet, (JavaType)JsonUtils.getObjectMapper().getTypeFactory().constructCollectionType(HashSet.class, ItemLite.class))).avoidDisabling(this.avoidDisabling).build();
    }

    @Generated
    public static PredictionModelDtoBuilder builder() {
        return new PredictionModelDtoBuilder();
    }

    @Generated
    public UUID getId() {
        return this.id;
    }

    @Generated
    public UUID getTenantId() {
        return this.tenantId;
    }

    @Generated
    public UUID getCustomerId() {
        return this.customerId;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public long getCreatedTs() {
        return this.createdTs;
    }

    @Generated
    public long getUpdatedTs() {
        return this.updatedTs;
    }

    @Generated
    public boolean isEnabled() {
        return this.enabled;
    }

    @Generated
    public boolean isPartialFitEnabled() {
        return this.partialFitEnabled;
    }

    @Generated
    public PredictionModelStatus getStatus() {
        return this.status;
    }

    @Generated
    public PredictionMethodType getType() {
        return this.type;
    }

    @Generated
    public UUID getAssociatedEntityFieldId() {
        return this.associatedEntityFieldId;
    }

    @Generated
    public String getTbTelemetryKey() {
        return this.tbTelemetryKey;
    }

    @Generated
    public String getModelParameters() {
        return this.modelParameters;
    }

    @Generated
    public String getMethodParameters() {
        return this.methodParameters;
    }

    @Generated
    public String getDatasourceParameters() {
        return this.datasourceParameters;
    }

    @Generated
    public String getItemStateMap() {
        return this.itemStateMap;
    }

    @Generated
    public String getTrainedItemSet() {
        return this.trainedItemSet;
    }

    @Generated
    public UUID getBusinessEntityId() {
        return this.businessEntityId;
    }

    @Generated
    public UUID getBusinessEntityFieldId() {
        return this.businessEntityFieldId;
    }

    @Generated
    public boolean isAvoidDisabling() {
        return this.avoidDisabling;
    }

    @Generated
    public void setId(UUID id) {
        this.id = id;
    }

    @Generated
    public void setTenantId(UUID tenantId) {
        this.tenantId = tenantId;
    }

    @Generated
    public void setCustomerId(UUID customerId) {
        this.customerId = customerId;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setCreatedTs(long createdTs) {
        this.createdTs = createdTs;
    }

    @Generated
    public void setUpdatedTs(long updatedTs) {
        this.updatedTs = updatedTs;
    }

    @Generated
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Generated
    public void setPartialFitEnabled(boolean partialFitEnabled) {
        this.partialFitEnabled = partialFitEnabled;
    }

    @Generated
    public void setStatus(PredictionModelStatus status) {
        this.status = status;
    }

    @Generated
    public void setType(PredictionMethodType type) {
        this.type = type;
    }

    @Generated
    public void setAssociatedEntityFieldId(UUID associatedEntityFieldId) {
        this.associatedEntityFieldId = associatedEntityFieldId;
    }

    @Generated
    public void setTbTelemetryKey(String tbTelemetryKey) {
        this.tbTelemetryKey = tbTelemetryKey;
    }

    @Generated
    public void setModelParameters(String modelParameters) {
        this.modelParameters = modelParameters;
    }

    @Generated
    public void setMethodParameters(String methodParameters) {
        this.methodParameters = methodParameters;
    }

    @Generated
    public void setDatasourceParameters(String datasourceParameters) {
        this.datasourceParameters = datasourceParameters;
    }

    @Generated
    public void setItemStateMap(String itemStateMap) {
        this.itemStateMap = itemStateMap;
    }

    @Generated
    public void setTrainedItemSet(String trainedItemSet) {
        this.trainedItemSet = trainedItemSet;
    }

    @Generated
    public void setBusinessEntityId(UUID businessEntityId) {
        this.businessEntityId = businessEntityId;
    }

    @Generated
    public void setBusinessEntityFieldId(UUID businessEntityFieldId) {
        this.businessEntityFieldId = businessEntityFieldId;
    }

    @Generated
    public void setAvoidDisabling(boolean avoidDisabling) {
        this.avoidDisabling = avoidDisabling;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PredictionModelDto)) {
            return false;
        }
        PredictionModelDto other = (PredictionModelDto)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getCreatedTs() != other.getCreatedTs()) {
            return false;
        }
        if (this.getUpdatedTs() != other.getUpdatedTs()) {
            return false;
        }
        if (this.isEnabled() != other.isEnabled()) {
            return false;
        }
        if (this.isPartialFitEnabled() != other.isPartialFitEnabled()) {
            return false;
        }
        if (this.isAvoidDisabling() != other.isAvoidDisabling()) {
            return false;
        }
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        UUID this$tenantId = this.getTenantId();
        UUID other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !((Object)this$tenantId).equals(other$tenantId)) {
            return false;
        }
        UUID this$customerId = this.getCustomerId();
        UUID other$customerId = other.getCustomerId();
        if (this$customerId == null ? other$customerId != null : !((Object)this$customerId).equals(other$customerId)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        PredictionModelStatus this$status = this.getStatus();
        PredictionModelStatus other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        PredictionMethodType this$type = this.getType();
        PredictionMethodType other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        UUID this$associatedEntityFieldId = this.getAssociatedEntityFieldId();
        UUID other$associatedEntityFieldId = other.getAssociatedEntityFieldId();
        if (this$associatedEntityFieldId == null ? other$associatedEntityFieldId != null : !((Object)this$associatedEntityFieldId).equals(other$associatedEntityFieldId)) {
            return false;
        }
        String this$tbTelemetryKey = this.getTbTelemetryKey();
        String other$tbTelemetryKey = other.getTbTelemetryKey();
        if (this$tbTelemetryKey == null ? other$tbTelemetryKey != null : !this$tbTelemetryKey.equals(other$tbTelemetryKey)) {
            return false;
        }
        String this$modelParameters = this.getModelParameters();
        String other$modelParameters = other.getModelParameters();
        if (this$modelParameters == null ? other$modelParameters != null : !this$modelParameters.equals(other$modelParameters)) {
            return false;
        }
        String this$methodParameters = this.getMethodParameters();
        String other$methodParameters = other.getMethodParameters();
        if (this$methodParameters == null ? other$methodParameters != null : !this$methodParameters.equals(other$methodParameters)) {
            return false;
        }
        String this$datasourceParameters = this.getDatasourceParameters();
        String other$datasourceParameters = other.getDatasourceParameters();
        if (this$datasourceParameters == null ? other$datasourceParameters != null : !this$datasourceParameters.equals(other$datasourceParameters)) {
            return false;
        }
        String this$itemStateMap = this.getItemStateMap();
        String other$itemStateMap = other.getItemStateMap();
        if (this$itemStateMap == null ? other$itemStateMap != null : !this$itemStateMap.equals(other$itemStateMap)) {
            return false;
        }
        String this$trainedItemSet = this.getTrainedItemSet();
        String other$trainedItemSet = other.getTrainedItemSet();
        if (this$trainedItemSet == null ? other$trainedItemSet != null : !this$trainedItemSet.equals(other$trainedItemSet)) {
            return false;
        }
        UUID this$businessEntityId = this.getBusinessEntityId();
        UUID other$businessEntityId = other.getBusinessEntityId();
        if (this$businessEntityId == null ? other$businessEntityId != null : !((Object)this$businessEntityId).equals(other$businessEntityId)) {
            return false;
        }
        UUID this$businessEntityFieldId = this.getBusinessEntityFieldId();
        UUID other$businessEntityFieldId = other.getBusinessEntityFieldId();
        return !(this$businessEntityFieldId == null ? other$businessEntityFieldId != null : !((Object)this$businessEntityFieldId).equals(other$businessEntityFieldId));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PredictionModelDto;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $createdTs = this.getCreatedTs();
        result = result * 59 + (int)($createdTs >>> 32 ^ $createdTs);
        long $updatedTs = this.getUpdatedTs();
        result = result * 59 + (int)($updatedTs >>> 32 ^ $updatedTs);
        result = result * 59 + (this.isEnabled() ? 79 : 97);
        result = result * 59 + (this.isPartialFitEnabled() ? 79 : 97);
        result = result * 59 + (this.isAvoidDisabling() ? 79 : 97);
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        UUID $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : ((Object)$tenantId).hashCode());
        UUID $customerId = this.getCustomerId();
        result = result * 59 + ($customerId == null ? 43 : ((Object)$customerId).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        PredictionModelStatus $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        PredictionMethodType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        UUID $associatedEntityFieldId = this.getAssociatedEntityFieldId();
        result = result * 59 + ($associatedEntityFieldId == null ? 43 : ((Object)$associatedEntityFieldId).hashCode());
        String $tbTelemetryKey = this.getTbTelemetryKey();
        result = result * 59 + ($tbTelemetryKey == null ? 43 : $tbTelemetryKey.hashCode());
        String $modelParameters = this.getModelParameters();
        result = result * 59 + ($modelParameters == null ? 43 : $modelParameters.hashCode());
        String $methodParameters = this.getMethodParameters();
        result = result * 59 + ($methodParameters == null ? 43 : $methodParameters.hashCode());
        String $datasourceParameters = this.getDatasourceParameters();
        result = result * 59 + ($datasourceParameters == null ? 43 : $datasourceParameters.hashCode());
        String $itemStateMap = this.getItemStateMap();
        result = result * 59 + ($itemStateMap == null ? 43 : $itemStateMap.hashCode());
        String $trainedItemSet = this.getTrainedItemSet();
        result = result * 59 + ($trainedItemSet == null ? 43 : $trainedItemSet.hashCode());
        UUID $businessEntityId = this.getBusinessEntityId();
        result = result * 59 + ($businessEntityId == null ? 43 : ((Object)$businessEntityId).hashCode());
        UUID $businessEntityFieldId = this.getBusinessEntityFieldId();
        result = result * 59 + ($businessEntityFieldId == null ? 43 : ((Object)$businessEntityFieldId).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "PredictionModelDto(id=" + String.valueOf(this.getId()) + ", tenantId=" + String.valueOf(this.getTenantId()) + ", customerId=" + String.valueOf(this.getCustomerId()) + ", name=" + this.getName() + ", createdTs=" + this.getCreatedTs() + ", updatedTs=" + this.getUpdatedTs() + ", enabled=" + this.isEnabled() + ", partialFitEnabled=" + this.isPartialFitEnabled() + ", status=" + String.valueOf(this.getStatus()) + ", type=" + String.valueOf(this.getType()) + ", associatedEntityFieldId=" + String.valueOf(this.getAssociatedEntityFieldId()) + ", tbTelemetryKey=" + this.getTbTelemetryKey() + ", modelParameters=" + this.getModelParameters() + ", methodParameters=" + this.getMethodParameters() + ", datasourceParameters=" + this.getDatasourceParameters() + ", itemStateMap=" + this.getItemStateMap() + ", trainedItemSet=" + this.getTrainedItemSet() + ", businessEntityId=" + String.valueOf(this.getBusinessEntityId()) + ", businessEntityFieldId=" + String.valueOf(this.getBusinessEntityFieldId()) + ", avoidDisabling=" + this.isAvoidDisabling() + ")";
    }

    @Generated
    public PredictionModelDto() {
    }

    @Generated
    public PredictionModelDto(UUID id, UUID tenantId, UUID customerId, String name, long createdTs, long updatedTs, boolean enabled, boolean partialFitEnabled, PredictionModelStatus status, PredictionMethodType type, UUID associatedEntityFieldId, String tbTelemetryKey, String modelParameters, String methodParameters, String datasourceParameters, String itemStateMap, String trainedItemSet, UUID businessEntityId, UUID businessEntityFieldId, boolean avoidDisabling) {
        this.id = id;
        this.tenantId = tenantId;
        this.customerId = customerId;
        this.name = name;
        this.createdTs = createdTs;
        this.updatedTs = updatedTs;
        this.enabled = enabled;
        this.partialFitEnabled = partialFitEnabled;
        this.status = status;
        this.type = type;
        this.associatedEntityFieldId = associatedEntityFieldId;
        this.tbTelemetryKey = tbTelemetryKey;
        this.modelParameters = modelParameters;
        this.methodParameters = methodParameters;
        this.datasourceParameters = datasourceParameters;
        this.itemStateMap = itemStateMap;
        this.trainedItemSet = trainedItemSet;
        this.businessEntityId = businessEntityId;
        this.businessEntityFieldId = businessEntityFieldId;
        this.avoidDisabling = avoidDisabling;
    }
}

