/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.dao.model.anomaly;

import com.fasterxml.jackson.databind.JavaType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.Id;
import jakarta.persistence.Table;
import java.util.Set;
import java.util.UUID;
import lombok.Generated;
import org.thingsboard.trendz.dao.model.anomaly.AnomalyModelTaskDataDto;
import org.thingsboard.trendz.domain.anomaly.AnomalyModelTaskData;
import org.thingsboard.trendz.domain.definition.view.config.DateAggregationUnit;
import org.thingsboard.trendz.domain.runtime.ItemLite;
import org.thingsboard.trendz.tools.json.JsonUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@Entity
@Table(name="anomaly_model_task_data")
public class AnomalyModelTaskDataDto {
    @Id
    @Column(name="anomaly_model_id")
    private UUID anomalyModelId;
    @Column(name="item_set_json")
    private String itemSetJson;
    @Column(name="enabled_refresh")
    private boolean enabledRefresh;
    @Column(name="enabled_save_to_tb")
    private boolean enabledSaveToTb;
    @Column(name="enabled_alarm_creation")
    private boolean enabledAlarmCreation;
    @Column(name="refresh_time_unit")
    @Enumerated(value=EnumType.STRING)
    private DateAggregationUnit refreshTimeUnit;
    @Column(name="refresh_time_unit_count")
    private int refreshTimeUnitCount;
    @Column(name="refresh_time_unit_truncated")
    private boolean refreshTimeUnitTruncated;

    public AnomalyModelTaskData toData() {
        return AnomalyModelTaskData.builder().anomalyModelId(this.anomalyModelId).itemSet(this.itemSetJson == null ? null : (Set)JsonUtils.fromJson((String)this.itemSetJson, (JavaType)JsonUtils.getObjectMapper().getTypeFactory().constructCollectionType(Set.class, ItemLite.class))).enabledRefresh(this.enabledRefresh).enabledSaveToTb(this.enabledSaveToTb).enabledAlarmCreation(this.enabledAlarmCreation).refreshTimeUnit(this.refreshTimeUnit).refreshTimeUnitCount(this.refreshTimeUnitCount).refreshTimeUnitTruncated(this.refreshTimeUnitTruncated).build();
    }

    public static AnomalyModelTaskDataDto from(AnomalyModelTaskData entity) {
        if (entity == null) {
            return null;
        }
        return AnomalyModelTaskDataDto.builder().anomalyModelId(entity.getAnomalyModelId()).itemSetJson(entity.getItemSet() == null ? null : JsonUtils.toJson((Object)entity.getItemSet())).enabledRefresh(entity.isEnabledRefresh()).enabledSaveToTb(entity.isEnabledSaveToTb()).enabledAlarmCreation(entity.isEnabledAlarmCreation()).refreshTimeUnit(entity.getRefreshTimeUnit()).refreshTimeUnitCount(entity.getRefreshTimeUnitCount()).refreshTimeUnitTruncated(entity.isRefreshTimeUnitTruncated()).build();
    }

    @Generated
    public static AnomalyModelTaskDataDtoBuilder builder() {
        return new AnomalyModelTaskDataDtoBuilder();
    }

    @Generated
    public UUID getAnomalyModelId() {
        return this.anomalyModelId;
    }

    @Generated
    public String getItemSetJson() {
        return this.itemSetJson;
    }

    @Generated
    public boolean isEnabledRefresh() {
        return this.enabledRefresh;
    }

    @Generated
    public boolean isEnabledSaveToTb() {
        return this.enabledSaveToTb;
    }

    @Generated
    public boolean isEnabledAlarmCreation() {
        return this.enabledAlarmCreation;
    }

    @Generated
    public DateAggregationUnit getRefreshTimeUnit() {
        return this.refreshTimeUnit;
    }

    @Generated
    public int getRefreshTimeUnitCount() {
        return this.refreshTimeUnitCount;
    }

    @Generated
    public boolean isRefreshTimeUnitTruncated() {
        return this.refreshTimeUnitTruncated;
    }

    @Generated
    public void setAnomalyModelId(UUID anomalyModelId) {
        this.anomalyModelId = anomalyModelId;
    }

    @Generated
    public void setItemSetJson(String itemSetJson) {
        this.itemSetJson = itemSetJson;
    }

    @Generated
    public void setEnabledRefresh(boolean enabledRefresh) {
        this.enabledRefresh = enabledRefresh;
    }

    @Generated
    public void setEnabledSaveToTb(boolean enabledSaveToTb) {
        this.enabledSaveToTb = enabledSaveToTb;
    }

    @Generated
    public void setEnabledAlarmCreation(boolean enabledAlarmCreation) {
        this.enabledAlarmCreation = enabledAlarmCreation;
    }

    @Generated
    public void setRefreshTimeUnit(DateAggregationUnit refreshTimeUnit) {
        this.refreshTimeUnit = refreshTimeUnit;
    }

    @Generated
    public void setRefreshTimeUnitCount(int refreshTimeUnitCount) {
        this.refreshTimeUnitCount = refreshTimeUnitCount;
    }

    @Generated
    public void setRefreshTimeUnitTruncated(boolean refreshTimeUnitTruncated) {
        this.refreshTimeUnitTruncated = refreshTimeUnitTruncated;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AnomalyModelTaskDataDto)) {
            return false;
        }
        AnomalyModelTaskDataDto other = (AnomalyModelTaskDataDto)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.isEnabledRefresh() != other.isEnabledRefresh()) {
            return false;
        }
        if (this.isEnabledSaveToTb() != other.isEnabledSaveToTb()) {
            return false;
        }
        if (this.isEnabledAlarmCreation() != other.isEnabledAlarmCreation()) {
            return false;
        }
        if (this.getRefreshTimeUnitCount() != other.getRefreshTimeUnitCount()) {
            return false;
        }
        if (this.isRefreshTimeUnitTruncated() != other.isRefreshTimeUnitTruncated()) {
            return false;
        }
        UUID this$anomalyModelId = this.getAnomalyModelId();
        UUID other$anomalyModelId = other.getAnomalyModelId();
        if (this$anomalyModelId == null ? other$anomalyModelId != null : !((Object)this$anomalyModelId).equals(other$anomalyModelId)) {
            return false;
        }
        String this$itemSetJson = this.getItemSetJson();
        String other$itemSetJson = other.getItemSetJson();
        if (this$itemSetJson == null ? other$itemSetJson != null : !this$itemSetJson.equals(other$itemSetJson)) {
            return false;
        }
        DateAggregationUnit this$refreshTimeUnit = this.getRefreshTimeUnit();
        DateAggregationUnit other$refreshTimeUnit = other.getRefreshTimeUnit();
        return !(this$refreshTimeUnit == null ? other$refreshTimeUnit != null : !this$refreshTimeUnit.equals(other$refreshTimeUnit));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AnomalyModelTaskDataDto;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEnabledRefresh() ? 79 : 97);
        result = result * 59 + (this.isEnabledSaveToTb() ? 79 : 97);
        result = result * 59 + (this.isEnabledAlarmCreation() ? 79 : 97);
        result = result * 59 + this.getRefreshTimeUnitCount();
        result = result * 59 + (this.isRefreshTimeUnitTruncated() ? 79 : 97);
        UUID $anomalyModelId = this.getAnomalyModelId();
        result = result * 59 + ($anomalyModelId == null ? 43 : ((Object)$anomalyModelId).hashCode());
        String $itemSetJson = this.getItemSetJson();
        result = result * 59 + ($itemSetJson == null ? 43 : $itemSetJson.hashCode());
        DateAggregationUnit $refreshTimeUnit = this.getRefreshTimeUnit();
        result = result * 59 + ($refreshTimeUnit == null ? 43 : $refreshTimeUnit.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "AnomalyModelTaskDataDto(anomalyModelId=" + String.valueOf(this.getAnomalyModelId()) + ", itemSetJson=" + this.getItemSetJson() + ", enabledRefresh=" + this.isEnabledRefresh() + ", enabledSaveToTb=" + this.isEnabledSaveToTb() + ", enabledAlarmCreation=" + this.isEnabledAlarmCreation() + ", refreshTimeUnit=" + String.valueOf(this.getRefreshTimeUnit()) + ", refreshTimeUnitCount=" + this.getRefreshTimeUnitCount() + ", refreshTimeUnitTruncated=" + this.isRefreshTimeUnitTruncated() + ")";
    }

    @Generated
    public AnomalyModelTaskDataDto() {
    }

    @Generated
    public AnomalyModelTaskDataDto(UUID anomalyModelId, String itemSetJson, boolean enabledRefresh, boolean enabledSaveToTb, boolean enabledAlarmCreation, DateAggregationUnit refreshTimeUnit, int refreshTimeUnitCount, boolean refreshTimeUnitTruncated) {
        this.anomalyModelId = anomalyModelId;
        this.itemSetJson = itemSetJson;
        this.enabledRefresh = enabledRefresh;
        this.enabledSaveToTb = enabledSaveToTb;
        this.enabledAlarmCreation = enabledAlarmCreation;
        this.refreshTimeUnit = refreshTimeUnit;
        this.refreshTimeUnitCount = refreshTimeUnitCount;
        this.refreshTimeUnitTruncated = refreshTimeUnitTruncated;
    }
}

