/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.dao.customize;

import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.CrudRepository;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;
import org.thingsboard.trendz.dao.customize.UserRecordDto;
import org.thingsboard.trendz.dao.customize.UserRecordDtoId;

@Repository
public interface UserRecordRepository
extends CrudRepository<UserRecordDto, UserRecordDtoId> {
    @Query(value="SELECT new org.thingsboard.trendz.dao.customize.UserRecordDtoId(ur.tenantId, ur.customerId, ur.userId)\nFROM UserRecordDto ur\n")
    public Page<UserRecordDtoId> getAllTenantIds(Pageable var1);

    @Query(value="SELECT DISTINCT ur.tenantId FROM UserRecordDto ur")
    public Set<UUID> getAllTenantIds();

    @Query(value="SELECT CAST(ur.tenant_id as varchar), CAST(ur.customer_id as varchar), CAST(ur.user_id as varchar)\nFROM user_record ur\nWHERE ur.customer_id = '13814000-1dd2-11b2-8080-808080808080'\nAND ur.validation_last_ts = (\n    SELECT MIN(ur2.validation_last_ts)\n    FROM user_record ur2\n    WHERE\n       ur2.tenant_id = ur.tenant_id AND\n       ur2.customer_id = '13814000-1dd2-11b2-8080-808080808080' AND\n       ur2.valid = TRUE\n)\n", nativeQuery=true)
    public Set<Object[]> findAllFirstTenantIds();

    @Query(value="SELECT ur\nFROM UserRecordDto ur\nWHERE ur.tenantId = :tenantId\n    AND ur.customerId = :nullId\n    AND ur.valid\nORDER BY ur.visitFirstTs\nLIMIT 1\n")
    public Optional<UserRecordDto> findFirstTenantUserByTenantId(@Param(value="tenantId") UUID var1, @Param(value="nullId") UUID var2);

    @Query(value="SELECT new org.thingsboard.trendz.dao.customize.UserRecordDtoId(ur.tenantId, ur.customerId, ur.userId)\nFROM UserRecordDto ur\nWHERE\n   ur.tenantId = :tenantId AND\n   ur.customerId = :nullUuid AND\n   ur.valid = TRUE\n")
    public Page<UserRecordDtoId> findAllTenantUserByTenantId(@Param(value="tenantId") UUID var1, @Param(value="nullUuid") UUID var2, Pageable var3);
}

