/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.dao.customize;

import jakarta.transaction.Transactional;
import java.util.Set;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.dao.customize.DomainTenantPairDto;
import org.thingsboard.trendz.dao.customize.DomainTenantPairRepository;

@Service
@Transactional
public class DomainTenantPairDao {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DomainTenantPairDao.class);
    private final DomainTenantPairRepository domainTenantPairRepository;

    @Autowired
    public DomainTenantPairDao(DomainTenantPairRepository domainTenantPairRepository) {
        this.domainTenantPairRepository = domainTenantPairRepository;
    }

    public void writePair(String domain, UUID tenantId) {
        Set domains = this.findByTenantId(tenantId);
        if (domains.isEmpty()) {
            this.domainTenantPairRepository.save((Object)new DomainTenantPairDto(domain, tenantId));
            log.info("Domain and tenant are wired: domain = {}, tenant = {}", (Object)domain, (Object)tenantId);
        }
    }

    public Set<UUID> findByDomain(String domain) {
        return this.domainTenantPairRepository.getByDomain(domain);
    }

    public Set<String> findByTenantId(UUID tenantId) {
        return this.domainTenantPairRepository.getByTenantId(tenantId);
    }

    public void removeAllByTenantId(UUID tenantId) {
        this.domainTenantPairRepository.deleteAllByTenantId(tenantId);
    }
}

