/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.dao.customize;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.Id;
import jakarta.persistence.Table;
import lombok.Generated;
import org.thingsboard.server.common.data.wl.PaletteSettings;
import org.thingsboard.trendz.dao.customize.CustomViewSettingsDto;
import org.thingsboard.trendz.domain.customize.CustomViewSettings;
import org.thingsboard.trendz.domain.customize.PaletteSelection;
import org.thingsboard.trendz.tools.json.JsonUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@Entity
@Table(name="custom_view_settings")
public class CustomViewSettingsDto {
    @Id
    @Column(name="domain")
    private String domain;
    @Column(name="palette_selection")
    @Enumerated(value=EnumType.STRING)
    private PaletteSelection paletteSelection;
    @Column(name="palette_trendz")
    private String paletteTrendz;
    @Column(name="palette_tb")
    private String paletteTb;
    @Column(name="url")
    private String url;
    @Column(name="tab_name")
    private String tabName;
    @Column(name="logo_base64")
    private String logoBase64;
    @Column(name="dark_mode")
    private boolean darkMode;
    @Column(name="help_mode_enabled")
    private boolean helpModeEnabled;
    @Column(name="thingsboard_redirect_url")
    private String thingsboardRedirectUrl;

    public static CustomViewSettingsDto from(CustomViewSettings entity) {
        return CustomViewSettingsDto.builder().domain(entity.getDomain()).paletteSelection(entity.getPaletteSelection()).paletteTrendz(JsonUtils.toJson((Object)entity.getTrendzPaletteSettings())).paletteTb(JsonUtils.toJson((Object)entity.getTbPaletteSettings())).url(entity.getUrl()).tabName(entity.getTabName()).logoBase64(entity.getLogoBase64()).darkMode(entity.isDarkMode()).helpModeEnabled(entity.isHelpModeEnabled()).thingsboardRedirectUrl(entity.getThingsboardRedirectUrl()).build();
    }

    public CustomViewSettings toData() {
        return CustomViewSettings.builder().domain(this.domain).paletteSelection(this.paletteSelection).trendzPaletteSettings((PaletteSettings)JsonUtils.fromJson((String)this.paletteTrendz, PaletteSettings.class)).tbPaletteSettings((PaletteSettings)JsonUtils.fromJson((String)this.paletteTb, PaletteSettings.class)).url(this.url).tabName(this.tabName).logoBase64(this.logoBase64).darkMode(this.darkMode).helpModeEnabled(this.helpModeEnabled).thingsboardRedirectUrl(this.thingsboardRedirectUrl).build();
    }

    @Generated
    public static CustomViewSettingsDtoBuilder builder() {
        return new CustomViewSettingsDtoBuilder();
    }

    @Generated
    public String getDomain() {
        return this.domain;
    }

    @Generated
    public PaletteSelection getPaletteSelection() {
        return this.paletteSelection;
    }

    @Generated
    public String getPaletteTrendz() {
        return this.paletteTrendz;
    }

    @Generated
    public String getPaletteTb() {
        return this.paletteTb;
    }

    @Generated
    public String getUrl() {
        return this.url;
    }

    @Generated
    public String getTabName() {
        return this.tabName;
    }

    @Generated
    public String getLogoBase64() {
        return this.logoBase64;
    }

    @Generated
    public boolean isDarkMode() {
        return this.darkMode;
    }

    @Generated
    public boolean isHelpModeEnabled() {
        return this.helpModeEnabled;
    }

    @Generated
    public String getThingsboardRedirectUrl() {
        return this.thingsboardRedirectUrl;
    }

    @Generated
    public void setDomain(String domain) {
        this.domain = domain;
    }

    @Generated
    public void setPaletteSelection(PaletteSelection paletteSelection) {
        this.paletteSelection = paletteSelection;
    }

    @Generated
    public void setPaletteTrendz(String paletteTrendz) {
        this.paletteTrendz = paletteTrendz;
    }

    @Generated
    public void setPaletteTb(String paletteTb) {
        this.paletteTb = paletteTb;
    }

    @Generated
    public void setUrl(String url) {
        this.url = url;
    }

    @Generated
    public void setTabName(String tabName) {
        this.tabName = tabName;
    }

    @Generated
    public void setLogoBase64(String logoBase64) {
        this.logoBase64 = logoBase64;
    }

    @Generated
    public void setDarkMode(boolean darkMode) {
        this.darkMode = darkMode;
    }

    @Generated
    public void setHelpModeEnabled(boolean helpModeEnabled) {
        this.helpModeEnabled = helpModeEnabled;
    }

    @Generated
    public void setThingsboardRedirectUrl(String thingsboardRedirectUrl) {
        this.thingsboardRedirectUrl = thingsboardRedirectUrl;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CustomViewSettingsDto)) {
            return false;
        }
        CustomViewSettingsDto other = (CustomViewSettingsDto)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.isDarkMode() != other.isDarkMode()) {
            return false;
        }
        if (this.isHelpModeEnabled() != other.isHelpModeEnabled()) {
            return false;
        }
        String this$domain = this.getDomain();
        String other$domain = other.getDomain();
        if (this$domain == null ? other$domain != null : !this$domain.equals(other$domain)) {
            return false;
        }
        PaletteSelection this$paletteSelection = this.getPaletteSelection();
        PaletteSelection other$paletteSelection = other.getPaletteSelection();
        if (this$paletteSelection == null ? other$paletteSelection != null : !this$paletteSelection.equals(other$paletteSelection)) {
            return false;
        }
        String this$paletteTrendz = this.getPaletteTrendz();
        String other$paletteTrendz = other.getPaletteTrendz();
        if (this$paletteTrendz == null ? other$paletteTrendz != null : !this$paletteTrendz.equals(other$paletteTrendz)) {
            return false;
        }
        String this$paletteTb = this.getPaletteTb();
        String other$paletteTb = other.getPaletteTb();
        if (this$paletteTb == null ? other$paletteTb != null : !this$paletteTb.equals(other$paletteTb)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        String this$tabName = this.getTabName();
        String other$tabName = other.getTabName();
        if (this$tabName == null ? other$tabName != null : !this$tabName.equals(other$tabName)) {
            return false;
        }
        String this$logoBase64 = this.getLogoBase64();
        String other$logoBase64 = other.getLogoBase64();
        if (this$logoBase64 == null ? other$logoBase64 != null : !this$logoBase64.equals(other$logoBase64)) {
            return false;
        }
        String this$thingsboardRedirectUrl = this.getThingsboardRedirectUrl();
        String other$thingsboardRedirectUrl = other.getThingsboardRedirectUrl();
        return !(this$thingsboardRedirectUrl == null ? other$thingsboardRedirectUrl != null : !this$thingsboardRedirectUrl.equals(other$thingsboardRedirectUrl));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CustomViewSettingsDto;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isDarkMode() ? 79 : 97);
        result = result * 59 + (this.isHelpModeEnabled() ? 79 : 97);
        String $domain = this.getDomain();
        result = result * 59 + ($domain == null ? 43 : $domain.hashCode());
        PaletteSelection $paletteSelection = this.getPaletteSelection();
        result = result * 59 + ($paletteSelection == null ? 43 : $paletteSelection.hashCode());
        String $paletteTrendz = this.getPaletteTrendz();
        result = result * 59 + ($paletteTrendz == null ? 43 : $paletteTrendz.hashCode());
        String $paletteTb = this.getPaletteTb();
        result = result * 59 + ($paletteTb == null ? 43 : $paletteTb.hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        String $tabName = this.getTabName();
        result = result * 59 + ($tabName == null ? 43 : $tabName.hashCode());
        String $logoBase64 = this.getLogoBase64();
        result = result * 59 + ($logoBase64 == null ? 43 : $logoBase64.hashCode());
        String $thingsboardRedirectUrl = this.getThingsboardRedirectUrl();
        result = result * 59 + ($thingsboardRedirectUrl == null ? 43 : $thingsboardRedirectUrl.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "CustomViewSettingsDto(domain=" + this.getDomain() + ", paletteSelection=" + String.valueOf(this.getPaletteSelection()) + ", paletteTrendz=" + this.getPaletteTrendz() + ", paletteTb=" + this.getPaletteTb() + ", url=" + this.getUrl() + ", tabName=" + this.getTabName() + ", logoBase64=" + this.getLogoBase64() + ", darkMode=" + this.isDarkMode() + ", helpModeEnabled=" + this.isHelpModeEnabled() + ", thingsboardRedirectUrl=" + this.getThingsboardRedirectUrl() + ")";
    }

    @Generated
    public CustomViewSettingsDto() {
    }

    @Generated
    public CustomViewSettingsDto(String domain, PaletteSelection paletteSelection, String paletteTrendz, String paletteTb, String url, String tabName, String logoBase64, boolean darkMode, boolean helpModeEnabled, String thingsboardRedirectUrl) {
        this.domain = domain;
        this.paletteSelection = paletteSelection;
        this.paletteTrendz = paletteTrendz;
        this.paletteTb = paletteTb;
        this.url = url;
        this.tabName = tabName;
        this.logoBase64 = logoBase64;
        this.darkMode = darkMode;
        this.helpModeEnabled = helpModeEnabled;
        this.thingsboardRedirectUrl = thingsboardRedirectUrl;
    }
}

