/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.dao.calculation;

import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.CrudRepository;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;
import org.thingsboard.trendz.dao.calculation.CalculationFieldDto;
import org.thingsboard.trendz.domain.definition.calculation.CalculationFieldLite;
import org.thingsboard.trendz.domain.definition.calculation.CalculationFieldType;
import org.thingsboard.trendz.domain.definition.view.config.ScriptLanguage;
import org.thingsboard.trendz.domain.summary.TrendzEntityUsage;

@Repository
public interface CalculationFieldRepository
extends CrudRepository<CalculationFieldDto, UUID> {
    @Query(value="select new org.thingsboard.trendz.domain.definition.calculation.CalculationFieldLite(\n    cf.id, cf.name, cf.businessEntityId, cf.creationTime, cf.updateTime, cf.enabled, cf.language, cf.calculationFieldType\n)\nfrom CalculationFieldDto cf\nwhere cf.tenantId = :tenantId\nand (coalesce(:customerId, null) is null or cf.customerId = :customerId)\nand (coalesce(:enabled, null) is null or cf.enabled = :enabled)\nand (coalesce(:name, null) is null or LOWER(cf.name) like %:name%)\nand (coalesce(:language, null) is null or cf.language = :language)\nand (coalesce(:fieldType, null) is null or cf.calculationFieldType = :fieldType)\nand (coalesce(:businessEntityIdSet, null) is null or cf.businessEntityId in (:businessEntityIdSet))\n")
    public Page<CalculationFieldLite> findAllByTenantIdAndCustomerId(@Param(value="tenantId") UUID var1, @Param(value="customerId") UUID var2, @Param(value="enabled") Boolean var3, @Param(value="name") String var4, @Param(value="language") ScriptLanguage var5, @Param(value="fieldType") CalculationFieldType var6, @Param(value="businessEntityIdSet") Set<UUID> var7, PageRequest var8);

    @Query(value="select cf\nfrom CalculationFieldDto cf\nwhere cf.tenantId = :tenantId and\n(coalesce(:customerId, null) is null or cf.customerId = :customerId)\n")
    public List<CalculationFieldDto> findByTenantIdAndCustomerId(@Param(value="tenantId") UUID var1, @Param(value="customerId") UUID var2);

    @Query(value="select cf\nfrom CalculationFieldDto cf\nwhere cf.id = :id and\ncf.tenantId = :tenantId and\n(:insecure = TRUE OR coalesce(:customerId, null) is null or cf.customerId = :customerId)\n")
    public Optional<CalculationFieldDto> findByIdAndTenantIdAndCustomerId(@Param(value="id") UUID var1, @Param(value="tenantId") UUID var2, @Param(value="customerId") UUID var3, @Param(value="insecure") boolean var4);

    @Query(value="select cf\nfrom CalculationFieldDto cf\nwhere cf.name = :name and\ncf.tenantId = :tenantId and\n(coalesce(:customerId, null) is null or cf.customerId = :customerId)\n")
    public Optional<CalculationFieldDto> findByNameAndTenantIdAndCustomerId(@Param(value="name") String var1, @Param(value="tenantId") UUID var2, @Param(value="customerId") UUID var3);

    @Query(value="update CalculationFieldDto cf\nset cf.name = :name\nwhere cf.id = :id and\ncf.tenantId = :tenantId and\n(coalesce(:customerId, null) is null or cf.customerId = :customerId)\n")
    @Modifying
    public void renameByIdAndTenantIdAndCustomerId(@Param(value="name") String var1, @Param(value="id") UUID var2, @Param(value="tenantId") UUID var3, @Param(value="customerId") UUID var4);

    @Query(value="update CalculationFieldDto cf\nset cf.enabled = :enabled\nwhere\n    cf.id = :id and\n    cf.tenantId = :tenantId and\n    (coalesce(:customerId, null) is null or cf.customerId = :customerId)\n")
    @Modifying
    public void updateEnablingByIdAndTenantIdAndCustomerId(@Param(value="id") UUID var1, @Param(value="tenantId") UUID var2, @Param(value="customerId") UUID var3, @Param(value="enabled") boolean var4);

    @Query(value="delete from CalculationFieldDto cf\nwhere cf.id = :id and\ncf.tenantId = :tenantId and\n(coalesce(:customerId, null) is null or cf.customerId = :customerId)\n")
    @Modifying
    public void deleteByIdAndTenantIdAndCustomerId(@Param(value="id") UUID var1, @Param(value="tenantId") UUID var2, @Param(value="customerId") UUID var3);

    @Query(value="select count(cf)\nfrom CalculationFieldDto cf\nwhere cf.name = :name and cf.tenantId = :tenantId\n")
    public int countAllByTenantIdAndName(@Param(value="name") String var1, @Param(value="tenantId") UUID var2);

    @Query(value="select cf\nfrom CalculationFieldDto cf\nwhere\n    cf.associatedEntityFieldId = :entityFieldId and\n    cf.tenantId = :tenantId and\n    (:insecure = TRUE OR coalesce(:customerId, null) is null or cf.customerId = :customerId)\n")
    public Optional<CalculationFieldDto> findByAssociatedEntityFieldIdAndTenantIdAndCustomerId(@Param(value="entityFieldId") UUID var1, @Param(value="tenantId") UUID var2, @Param(value="customerId") UUID var3, @Param(value="insecure") boolean var4);

    @Query(nativeQuery=true, value="WITH associated_entity_fields AS (\n    SELECT bef.id, bef.business_entity_id\n    FROM business_entity_field bef\n    WHERE bef.id IN (\n        SELECT cf.associated_entity_field_id\n        FROM calculation_field cf\n        WHERE cf.id = :id\n            AND cf.tenant_id = :tenantId\n            AND (:customerId = :nullId OR cf.customer_id = :customerId)\n    )\n)\n    SELECT 'BUSINESS_ENTITY' AS TYPE, be.name AS name\n    FROM business_entity be\n    WHERE be.id IN (\n        SELECT business_entity_id\n        FROM associated_entity_fields\n    )\nUNION\n    SELECT 'VIEW_CONFIG' AS TYPE, vc.name AS name\n    FROM view_config vc\n    WHERE vc.tenant_id = :tenantId\n        AND vc.customer_id IN :customerIdSet\n        AND vc.id IN (\n\t\t    SELECT vf.view_config_id\n\t\t    FROM view_field vf\n\t\t    WHERE vf.entity_field_id IN (\n                SELECT id\n                FROM associated_entity_fields\n            )\n        )\nUNION\n    SELECT 'ANOMALY_MODEL' AS TYPE, cm.name AS name\n    FROM cluster_model cm\n    WHERE cm.tenant_id = :tenantId\n        AND (:customerId = :nullId OR cm.customer_id = :customerId)\n        AND (\n            cm.dataset_config_id IN (\n\t\t        SELECT dc.id\n\t\t        FROM dataset_config dc\n\t\t        WHERE dc.id IN (\n\t\t\t\t    SELECT vf.dataset_config_id\n\t\t\t\t    FROM view_field vf\n\t\t\t\t    WHERE vf.entity_field_id IN (\n\t\t\t\t\t    SELECT id\n                        FROM associated_entity_fields\n                    )\n           \t    )\n            )\n        )\nUNION\n    SELECT 'PREDICTION_MODEL' AS TYPE, pm.name AS name\n    FROM prediction_model pm\n    WHERE pm.tenant_id = :tenantId\n        AND (:customerId = :nullId OR pm.customer_id = :customerId)\n        AND CAST(CAST(pm.datasource_parameters AS JSONB) ->> 'businessEntityFieldId' AS UUID) IN (\n            SELECT id\n            FROM associated_entity_fields\n        )\n")
    public List<Object[]> findDependedEntities(@Param(value="id") UUID var1, @Param(value="tenantId") UUID var2, @Param(value="customerId") UUID var3, @Param(value="customerIdSet") Set<UUID> var4, @Param(value="nullId") UUID var5);

    @Query(value="SELECT new org.thingsboard.trendz.domain.summary.TrendzEntityUsage(\n    COUNT(f) FILTER (WHERE f.enabled = true),\n    COUNT(f)\n)\nFROM CalculationFieldDto f\nWHERE :tenantId = :nullId OR f.tenantId = :tenantId\n")
    public Optional<TrendzEntityUsage> findUsage(UUID var1, UUID var2);
}

