/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.dao.calculation;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.Id;
import jakarta.persistence.Table;
import java.util.UUID;
import lombok.Generated;
import org.thingsboard.trendz.dao.calculation.CalculationFieldDto;
import org.thingsboard.trendz.domain.definition.calculation.CalculationField;
import org.thingsboard.trendz.domain.definition.calculation.CalculationFieldTimeRangeStrategy;
import org.thingsboard.trendz.domain.definition.calculation.CalculationFieldType;
import org.thingsboard.trendz.domain.definition.entity.field.FieldType;
import org.thingsboard.trendz.domain.definition.view.FieldAggregation;
import org.thingsboard.trendz.domain.definition.view.config.DateAggregationUnit;
import org.thingsboard.trendz.domain.definition.view.config.DatePickerConfig;
import org.thingsboard.trendz.domain.definition.view.config.ScriptLanguage;
import org.thingsboard.trendz.service.view.proto.FillGapSettings;
import org.thingsboard.trendz.service.view.proto.FillGapStrategy;
import org.thingsboard.trendz.tools.json.JsonUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@Entity
@Table(name="calculation_field")
public class CalculationFieldDto {
    @Id
    private UUID id;
    @Column(name="tenant_id")
    private UUID tenantId;
    @Column(name="customer_id")
    private UUID customerId;
    @Column(name="name")
    private String name;
    @Column(name="enabled")
    private boolean enabled;
    @Column(name="creation_time")
    private long creationTime;
    @Column(name="update_time")
    private long updateTime;
    @Column(name="business_entity_id")
    private UUID businessEntityId;
    @Column(name="associated_entity_field_id")
    private UUID associatedEntityFieldId;
    @Enumerated(value=EnumType.STRING)
    @Column(name="language")
    private ScriptLanguage language;
    @Enumerated(value=EnumType.STRING)
    @Column(name="calculation_field_type")
    private CalculationFieldType calculationFieldType;
    @Enumerated(value=EnumType.STRING)
    @Column(name="return_data_type")
    private FieldType returnDataType;
    @Column(name="grouping_interval")
    private String groupingInterval;
    @Enumerated(value=EnumType.STRING)
    @Column(name="field_aggregation")
    private FieldAggregation fieldAggregation;
    @Column(name="fill_gap_enable")
    private boolean fillGapEnable;
    @Enumerated(value=EnumType.STRING)
    @Column(name="fill_gap_time_unit")
    private DateAggregationUnit fillGapEnableTimeUnit;
    @Enumerated(value=EnumType.STRING)
    @Column(name="fill_gap_strategy")
    private FillGapStrategy fillGapStrategy;
    @Column(name="tb_telemetry_key")
    private String tbTelemetryKey;
    @Column(name="script")
    private String script;
    @Enumerated(value=EnumType.STRING)
    @Column(name="time_range_strategy")
    private CalculationFieldTimeRangeStrategy timeRangeStrategy;
    @Column(name="json_fixed_strategy_date_picker")
    private String jsonFixedStrategyDatePicker;
    @Column(name="manual_dataset_id")
    private UUID manualDatasetId;
    @Column(name="split_time_range")
    private boolean splitTimeRange;
    @Enumerated(value=EnumType.STRING)
    @Column(name="split_time_range_time_unit")
    private DateAggregationUnit splitTimeRangeTimeUnit;

    public static CalculationFieldDto from(CalculationField entity, UUID manualDatasetId) {
        return CalculationFieldDto.builder().id(entity.getId()).tenantId(entity.getTenantId()).customerId(entity.getCustomerId()).enabled(entity.isEnabled()).name(entity.getName()).creationTime(entity.getCreationTime()).updateTime(entity.getUpdateTime()).businessEntityId(entity.getBusinessEntityId()).associatedEntityFieldId(entity.getAssociatedEntityFieldId()).language(entity.getLanguage()).calculationFieldType(entity.getCalculationFieldType()).returnDataType(entity.getReturnDataType()).groupingInterval(entity.getGroupingInterval()).fieldAggregation(entity.getFieldAggregation()).fillGapEnable(entity.getFillGapSettings().isEnableFillGap()).fillGapEnableTimeUnit(entity.getFillGapSettings().getTimeUnit()).fillGapStrategy(entity.getFillGapSettings().getFillGapStrategy()).tbTelemetryKey(entity.getTbTelemetryKey()).script(entity.getScript()).timeRangeStrategy(entity.getTimeRangeStrategy()).jsonFixedStrategyDatePicker(entity.getFixedStrategyDatePicker() == null ? null : JsonUtils.toJson((Object)entity.getFixedStrategyDatePicker())).manualDatasetId(manualDatasetId).splitTimeRange(entity.isSplitTimeRange()).splitTimeRangeTimeUnit(entity.getSplitTimeRangeTimeUnit()).build();
    }

    public CalculationField toData() {
        return CalculationField.builder().id(this.id).tenantId(this.tenantId).customerId(this.customerId).enabled(this.enabled).name(this.name).creationTime(this.creationTime).updateTime(this.updateTime).businessEntityId(this.businessEntityId).associatedEntityFieldId(this.associatedEntityFieldId).language(this.language).calculationFieldType(this.calculationFieldType).returnDataType(this.returnDataType).groupingInterval(this.groupingInterval).fieldAggregation(this.fieldAggregation).fillGapSettings(FillGapSettings.builder().enableFillGap(this.fillGapEnable).timeUnit(this.fillGapEnableTimeUnit).fillGapStrategy(this.fillGapStrategy).build()).tbTelemetryKey(this.tbTelemetryKey).script(this.script).timeRangeStrategy(this.timeRangeStrategy).fixedStrategyDatePicker(this.jsonFixedStrategyDatePicker == null ? null : (DatePickerConfig)JsonUtils.fromJson((String)this.jsonFixedStrategyDatePicker, DatePickerConfig.class)).splitTimeRange(this.splitTimeRange).splitTimeRangeTimeUnit(this.splitTimeRangeTimeUnit).build();
    }

    @Generated
    public static CalculationFieldDtoBuilder builder() {
        return new CalculationFieldDtoBuilder();
    }

    @Generated
    public UUID getId() {
        return this.id;
    }

    @Generated
    public UUID getTenantId() {
        return this.tenantId;
    }

    @Generated
    public UUID getCustomerId() {
        return this.customerId;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public boolean isEnabled() {
        return this.enabled;
    }

    @Generated
    public long getCreationTime() {
        return this.creationTime;
    }

    @Generated
    public long getUpdateTime() {
        return this.updateTime;
    }

    @Generated
    public UUID getBusinessEntityId() {
        return this.businessEntityId;
    }

    @Generated
    public UUID getAssociatedEntityFieldId() {
        return this.associatedEntityFieldId;
    }

    @Generated
    public ScriptLanguage getLanguage() {
        return this.language;
    }

    @Generated
    public CalculationFieldType getCalculationFieldType() {
        return this.calculationFieldType;
    }

    @Generated
    public FieldType getReturnDataType() {
        return this.returnDataType;
    }

    @Generated
    public String getGroupingInterval() {
        return this.groupingInterval;
    }

    @Generated
    public FieldAggregation getFieldAggregation() {
        return this.fieldAggregation;
    }

    @Generated
    public boolean isFillGapEnable() {
        return this.fillGapEnable;
    }

    @Generated
    public DateAggregationUnit getFillGapEnableTimeUnit() {
        return this.fillGapEnableTimeUnit;
    }

    @Generated
    public FillGapStrategy getFillGapStrategy() {
        return this.fillGapStrategy;
    }

    @Generated
    public String getTbTelemetryKey() {
        return this.tbTelemetryKey;
    }

    @Generated
    public String getScript() {
        return this.script;
    }

    @Generated
    public CalculationFieldTimeRangeStrategy getTimeRangeStrategy() {
        return this.timeRangeStrategy;
    }

    @Generated
    public String getJsonFixedStrategyDatePicker() {
        return this.jsonFixedStrategyDatePicker;
    }

    @Generated
    public UUID getManualDatasetId() {
        return this.manualDatasetId;
    }

    @Generated
    public boolean isSplitTimeRange() {
        return this.splitTimeRange;
    }

    @Generated
    public DateAggregationUnit getSplitTimeRangeTimeUnit() {
        return this.splitTimeRangeTimeUnit;
    }

    @Generated
    public void setId(UUID id) {
        this.id = id;
    }

    @Generated
    public void setTenantId(UUID tenantId) {
        this.tenantId = tenantId;
    }

    @Generated
    public void setCustomerId(UUID customerId) {
        this.customerId = customerId;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Generated
    public void setCreationTime(long creationTime) {
        this.creationTime = creationTime;
    }

    @Generated
    public void setUpdateTime(long updateTime) {
        this.updateTime = updateTime;
    }

    @Generated
    public void setBusinessEntityId(UUID businessEntityId) {
        this.businessEntityId = businessEntityId;
    }

    @Generated
    public void setAssociatedEntityFieldId(UUID associatedEntityFieldId) {
        this.associatedEntityFieldId = associatedEntityFieldId;
    }

    @Generated
    public void setLanguage(ScriptLanguage language) {
        this.language = language;
    }

    @Generated
    public void setCalculationFieldType(CalculationFieldType calculationFieldType) {
        this.calculationFieldType = calculationFieldType;
    }

    @Generated
    public void setReturnDataType(FieldType returnDataType) {
        this.returnDataType = returnDataType;
    }

    @Generated
    public void setGroupingInterval(String groupingInterval) {
        this.groupingInterval = groupingInterval;
    }

    @Generated
    public void setFieldAggregation(FieldAggregation fieldAggregation) {
        this.fieldAggregation = fieldAggregation;
    }

    @Generated
    public void setFillGapEnable(boolean fillGapEnable) {
        this.fillGapEnable = fillGapEnable;
    }

    @Generated
    public void setFillGapEnableTimeUnit(DateAggregationUnit fillGapEnableTimeUnit) {
        this.fillGapEnableTimeUnit = fillGapEnableTimeUnit;
    }

    @Generated
    public void setFillGapStrategy(FillGapStrategy fillGapStrategy) {
        this.fillGapStrategy = fillGapStrategy;
    }

    @Generated
    public void setTbTelemetryKey(String tbTelemetryKey) {
        this.tbTelemetryKey = tbTelemetryKey;
    }

    @Generated
    public void setScript(String script) {
        this.script = script;
    }

    @Generated
    public void setTimeRangeStrategy(CalculationFieldTimeRangeStrategy timeRangeStrategy) {
        this.timeRangeStrategy = timeRangeStrategy;
    }

    @Generated
    public void setJsonFixedStrategyDatePicker(String jsonFixedStrategyDatePicker) {
        this.jsonFixedStrategyDatePicker = jsonFixedStrategyDatePicker;
    }

    @Generated
    public void setManualDatasetId(UUID manualDatasetId) {
        this.manualDatasetId = manualDatasetId;
    }

    @Generated
    public void setSplitTimeRange(boolean splitTimeRange) {
        this.splitTimeRange = splitTimeRange;
    }

    @Generated
    public void setSplitTimeRangeTimeUnit(DateAggregationUnit splitTimeRangeTimeUnit) {
        this.splitTimeRangeTimeUnit = splitTimeRangeTimeUnit;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CalculationFieldDto)) {
            return false;
        }
        CalculationFieldDto other = (CalculationFieldDto)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.isEnabled() != other.isEnabled()) {
            return false;
        }
        if (this.getCreationTime() != other.getCreationTime()) {
            return false;
        }
        if (this.getUpdateTime() != other.getUpdateTime()) {
            return false;
        }
        if (this.isFillGapEnable() != other.isFillGapEnable()) {
            return false;
        }
        if (this.isSplitTimeRange() != other.isSplitTimeRange()) {
            return false;
        }
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        UUID this$tenantId = this.getTenantId();
        UUID other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !((Object)this$tenantId).equals(other$tenantId)) {
            return false;
        }
        UUID this$customerId = this.getCustomerId();
        UUID other$customerId = other.getCustomerId();
        if (this$customerId == null ? other$customerId != null : !((Object)this$customerId).equals(other$customerId)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        UUID this$businessEntityId = this.getBusinessEntityId();
        UUID other$businessEntityId = other.getBusinessEntityId();
        if (this$businessEntityId == null ? other$businessEntityId != null : !((Object)this$businessEntityId).equals(other$businessEntityId)) {
            return false;
        }
        UUID this$associatedEntityFieldId = this.getAssociatedEntityFieldId();
        UUID other$associatedEntityFieldId = other.getAssociatedEntityFieldId();
        if (this$associatedEntityFieldId == null ? other$associatedEntityFieldId != null : !((Object)this$associatedEntityFieldId).equals(other$associatedEntityFieldId)) {
            return false;
        }
        ScriptLanguage this$language = this.getLanguage();
        ScriptLanguage other$language = other.getLanguage();
        if (this$language == null ? other$language != null : !this$language.equals(other$language)) {
            return false;
        }
        CalculationFieldType this$calculationFieldType = this.getCalculationFieldType();
        CalculationFieldType other$calculationFieldType = other.getCalculationFieldType();
        if (this$calculationFieldType == null ? other$calculationFieldType != null : !this$calculationFieldType.equals(other$calculationFieldType)) {
            return false;
        }
        FieldType this$returnDataType = this.getReturnDataType();
        FieldType other$returnDataType = other.getReturnDataType();
        if (this$returnDataType == null ? other$returnDataType != null : !this$returnDataType.equals(other$returnDataType)) {
            return false;
        }
        String this$groupingInterval = this.getGroupingInterval();
        String other$groupingInterval = other.getGroupingInterval();
        if (this$groupingInterval == null ? other$groupingInterval != null : !this$groupingInterval.equals(other$groupingInterval)) {
            return false;
        }
        FieldAggregation this$fieldAggregation = this.getFieldAggregation();
        FieldAggregation other$fieldAggregation = other.getFieldAggregation();
        if (this$fieldAggregation == null ? other$fieldAggregation != null : !this$fieldAggregation.equals(other$fieldAggregation)) {
            return false;
        }
        DateAggregationUnit this$fillGapEnableTimeUnit = this.getFillGapEnableTimeUnit();
        DateAggregationUnit other$fillGapEnableTimeUnit = other.getFillGapEnableTimeUnit();
        if (this$fillGapEnableTimeUnit == null ? other$fillGapEnableTimeUnit != null : !this$fillGapEnableTimeUnit.equals(other$fillGapEnableTimeUnit)) {
            return false;
        }
        FillGapStrategy this$fillGapStrategy = this.getFillGapStrategy();
        FillGapStrategy other$fillGapStrategy = other.getFillGapStrategy();
        if (this$fillGapStrategy == null ? other$fillGapStrategy != null : !this$fillGapStrategy.equals(other$fillGapStrategy)) {
            return false;
        }
        String this$tbTelemetryKey = this.getTbTelemetryKey();
        String other$tbTelemetryKey = other.getTbTelemetryKey();
        if (this$tbTelemetryKey == null ? other$tbTelemetryKey != null : !this$tbTelemetryKey.equals(other$tbTelemetryKey)) {
            return false;
        }
        String this$script = this.getScript();
        String other$script = other.getScript();
        if (this$script == null ? other$script != null : !this$script.equals(other$script)) {
            return false;
        }
        CalculationFieldTimeRangeStrategy this$timeRangeStrategy = this.getTimeRangeStrategy();
        CalculationFieldTimeRangeStrategy other$timeRangeStrategy = other.getTimeRangeStrategy();
        if (this$timeRangeStrategy == null ? other$timeRangeStrategy != null : !this$timeRangeStrategy.equals(other$timeRangeStrategy)) {
            return false;
        }
        String this$jsonFixedStrategyDatePicker = this.getJsonFixedStrategyDatePicker();
        String other$jsonFixedStrategyDatePicker = other.getJsonFixedStrategyDatePicker();
        if (this$jsonFixedStrategyDatePicker == null ? other$jsonFixedStrategyDatePicker != null : !this$jsonFixedStrategyDatePicker.equals(other$jsonFixedStrategyDatePicker)) {
            return false;
        }
        UUID this$manualDatasetId = this.getManualDatasetId();
        UUID other$manualDatasetId = other.getManualDatasetId();
        if (this$manualDatasetId == null ? other$manualDatasetId != null : !((Object)this$manualDatasetId).equals(other$manualDatasetId)) {
            return false;
        }
        DateAggregationUnit this$splitTimeRangeTimeUnit = this.getSplitTimeRangeTimeUnit();
        DateAggregationUnit other$splitTimeRangeTimeUnit = other.getSplitTimeRangeTimeUnit();
        return !(this$splitTimeRangeTimeUnit == null ? other$splitTimeRangeTimeUnit != null : !this$splitTimeRangeTimeUnit.equals(other$splitTimeRangeTimeUnit));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CalculationFieldDto;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEnabled() ? 79 : 97);
        long $creationTime = this.getCreationTime();
        result = result * 59 + (int)($creationTime >>> 32 ^ $creationTime);
        long $updateTime = this.getUpdateTime();
        result = result * 59 + (int)($updateTime >>> 32 ^ $updateTime);
        result = result * 59 + (this.isFillGapEnable() ? 79 : 97);
        result = result * 59 + (this.isSplitTimeRange() ? 79 : 97);
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        UUID $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : ((Object)$tenantId).hashCode());
        UUID $customerId = this.getCustomerId();
        result = result * 59 + ($customerId == null ? 43 : ((Object)$customerId).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        UUID $businessEntityId = this.getBusinessEntityId();
        result = result * 59 + ($businessEntityId == null ? 43 : ((Object)$businessEntityId).hashCode());
        UUID $associatedEntityFieldId = this.getAssociatedEntityFieldId();
        result = result * 59 + ($associatedEntityFieldId == null ? 43 : ((Object)$associatedEntityFieldId).hashCode());
        ScriptLanguage $language = this.getLanguage();
        result = result * 59 + ($language == null ? 43 : $language.hashCode());
        CalculationFieldType $calculationFieldType = this.getCalculationFieldType();
        result = result * 59 + ($calculationFieldType == null ? 43 : $calculationFieldType.hashCode());
        FieldType $returnDataType = this.getReturnDataType();
        result = result * 59 + ($returnDataType == null ? 43 : $returnDataType.hashCode());
        String $groupingInterval = this.getGroupingInterval();
        result = result * 59 + ($groupingInterval == null ? 43 : $groupingInterval.hashCode());
        FieldAggregation $fieldAggregation = this.getFieldAggregation();
        result = result * 59 + ($fieldAggregation == null ? 43 : $fieldAggregation.hashCode());
        DateAggregationUnit $fillGapEnableTimeUnit = this.getFillGapEnableTimeUnit();
        result = result * 59 + ($fillGapEnableTimeUnit == null ? 43 : $fillGapEnableTimeUnit.hashCode());
        FillGapStrategy $fillGapStrategy = this.getFillGapStrategy();
        result = result * 59 + ($fillGapStrategy == null ? 43 : $fillGapStrategy.hashCode());
        String $tbTelemetryKey = this.getTbTelemetryKey();
        result = result * 59 + ($tbTelemetryKey == null ? 43 : $tbTelemetryKey.hashCode());
        String $script = this.getScript();
        result = result * 59 + ($script == null ? 43 : $script.hashCode());
        CalculationFieldTimeRangeStrategy $timeRangeStrategy = this.getTimeRangeStrategy();
        result = result * 59 + ($timeRangeStrategy == null ? 43 : $timeRangeStrategy.hashCode());
        String $jsonFixedStrategyDatePicker = this.getJsonFixedStrategyDatePicker();
        result = result * 59 + ($jsonFixedStrategyDatePicker == null ? 43 : $jsonFixedStrategyDatePicker.hashCode());
        UUID $manualDatasetId = this.getManualDatasetId();
        result = result * 59 + ($manualDatasetId == null ? 43 : ((Object)$manualDatasetId).hashCode());
        DateAggregationUnit $splitTimeRangeTimeUnit = this.getSplitTimeRangeTimeUnit();
        result = result * 59 + ($splitTimeRangeTimeUnit == null ? 43 : $splitTimeRangeTimeUnit.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "CalculationFieldDto(id=" + String.valueOf(this.getId()) + ", tenantId=" + String.valueOf(this.getTenantId()) + ", customerId=" + String.valueOf(this.getCustomerId()) + ", name=" + this.getName() + ", enabled=" + this.isEnabled() + ", creationTime=" + this.getCreationTime() + ", updateTime=" + this.getUpdateTime() + ", businessEntityId=" + String.valueOf(this.getBusinessEntityId()) + ", associatedEntityFieldId=" + String.valueOf(this.getAssociatedEntityFieldId()) + ", language=" + String.valueOf(this.getLanguage()) + ", calculationFieldType=" + String.valueOf(this.getCalculationFieldType()) + ", returnDataType=" + String.valueOf(this.getReturnDataType()) + ", groupingInterval=" + this.getGroupingInterval() + ", fieldAggregation=" + String.valueOf(this.getFieldAggregation()) + ", fillGapEnable=" + this.isFillGapEnable() + ", fillGapEnableTimeUnit=" + String.valueOf(this.getFillGapEnableTimeUnit()) + ", fillGapStrategy=" + String.valueOf(this.getFillGapStrategy()) + ", tbTelemetryKey=" + this.getTbTelemetryKey() + ", script=" + this.getScript() + ", timeRangeStrategy=" + String.valueOf(this.getTimeRangeStrategy()) + ", jsonFixedStrategyDatePicker=" + this.getJsonFixedStrategyDatePicker() + ", manualDatasetId=" + String.valueOf(this.getManualDatasetId()) + ", splitTimeRange=" + this.isSplitTimeRange() + ", splitTimeRangeTimeUnit=" + String.valueOf(this.getSplitTimeRangeTimeUnit()) + ")";
    }

    @Generated
    public CalculationFieldDto() {
    }

    @Generated
    public CalculationFieldDto(UUID id, UUID tenantId, UUID customerId, String name, boolean enabled, long creationTime, long updateTime, UUID businessEntityId, UUID associatedEntityFieldId, ScriptLanguage language, CalculationFieldType calculationFieldType, FieldType returnDataType, String groupingInterval, FieldAggregation fieldAggregation, boolean fillGapEnable, DateAggregationUnit fillGapEnableTimeUnit, FillGapStrategy fillGapStrategy, String tbTelemetryKey, String script, CalculationFieldTimeRangeStrategy timeRangeStrategy, String jsonFixedStrategyDatePicker, UUID manualDatasetId, boolean splitTimeRange, DateAggregationUnit splitTimeRangeTimeUnit) {
        this.id = id;
        this.tenantId = tenantId;
        this.customerId = customerId;
        this.name = name;
        this.enabled = enabled;
        this.creationTime = creationTime;
        this.updateTime = updateTime;
        this.businessEntityId = businessEntityId;
        this.associatedEntityFieldId = associatedEntityFieldId;
        this.language = language;
        this.calculationFieldType = calculationFieldType;
        this.returnDataType = returnDataType;
        this.groupingInterval = groupingInterval;
        this.fieldAggregation = fieldAggregation;
        this.fillGapEnable = fillGapEnable;
        this.fillGapEnableTimeUnit = fillGapEnableTimeUnit;
        this.fillGapStrategy = fillGapStrategy;
        this.tbTelemetryKey = tbTelemetryKey;
        this.script = script;
        this.timeRangeStrategy = timeRangeStrategy;
        this.jsonFixedStrategyDatePicker = jsonFixedStrategyDatePicker;
        this.manualDatasetId = manualDatasetId;
        this.splitTimeRange = splitTimeRange;
        this.splitTimeRangeTimeUnit = splitTimeRangeTimeUnit;
    }
}

