/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.dao.business.metadata;

import jakarta.transaction.Transactional;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.dao.business.metadata.BusinessEntityMetadataDto;
import org.thingsboard.trendz.dao.business.metadata.BusinessEntityMetadataRepository;
import org.thingsboard.trendz.domain.definition.entity.metadata.BusinessEntityMetadata;
import org.thingsboard.trendz.domain.runtime.ItemLite;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;

@Service
@Transactional
public class BusinessEntityMetadataDao {
    private final BusinessEntityMetadataRepository entityMetadataRepository;

    @Autowired
    public BusinessEntityMetadataDao(BusinessEntityMetadataRepository entityMetadataRepository) {
        this.entityMetadataRepository = entityMetadataRepository;
    }

    public Optional<BusinessEntityMetadata> getMetadata(JwtSecurityUser user, UUID entityId) {
        UUID tenantId = user.getTenantId();
        UUID customerId = user.getCustomerId();
        return this.entityMetadataRepository.findByEntityId(entityId, tenantId, customerId).map(BusinessEntityMetadataDto::toData);
    }

    public BusinessEntityMetadata updateMetadata(UUID entityId, JwtSecurityUser user, ItemLite itemLite) {
        UUID tenantId = user.getTenantId();
        UUID customerId = user.getCustomerId();
        BusinessEntityMetadataDto metadataDto = this.entityMetadataRepository.findByEntityId(entityId, tenantId, customerId).orElseGet(() -> BusinessEntityMetadataDto.builder().id(UUID.randomUUID()).businessEntityId(entityId).tenantId(tenantId).customerId(customerId).build());
        if (itemLite != null) {
            metadataDto.setItemId(itemLite.getId());
            metadataDto.setItemName(itemLite.getName());
        }
        return ((BusinessEntityMetadataDto)this.entityMetadataRepository.save((Object)metadataDto)).toData();
    }

    public List<BusinessEntityMetadata> saveAll(List<BusinessEntityMetadata> businessEntityMetadata) {
        return businessEntityMetadata.stream().map(metadata -> this.updateMetadata(metadata.getBusinessEntityId(), JwtSecurityUser.builder().tenantId(metadata.getTenantId()).customerId(metadata.getCustomerId()).build(), metadata.getItemLite())).toList();
    }

    public List<BusinessEntityMetadata> findAllByTenantId(JwtSecurityUser user) {
        return this.entityMetadataRepository.findAllByTenantId(user.getTenantId()).stream().map(BusinessEntityMetadataDto::toData).toList();
    }
}

