/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.dao.business;

import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.CrudRepository;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;
import org.thingsboard.trendz.dao.business.BusinessEntityDto;
import org.thingsboard.trendz.dao.business.BusinessEntityFieldDto;

@Repository
public interface BusinessEntityRepository
extends CrudRepository<BusinessEntityDto, String> {
    @Query(value="select count(1) from business_entity be where be.tenantId = :tenantId")
    public int anyTenantEntityCount(@Param(value="tenantId") UUID var1);

    @Query(value="select be from business_entity be where be.tenantId = :tenantId")
    public List<BusinessEntityDto> findAllByTenantId(@Param(value="tenantId") UUID var1);

    @Query(value="select be from business_entity be where be.id = :id and be.tenantId = :tenantId")
    public Optional<BusinessEntityDto> findByIdAndTenantId(@Param(value="id") UUID var1, @Param(value="tenantId") UUID var2);

    @Query(value="select beF from BusinessEntityFieldDto beF where beF.id = :id")
    public Optional<BusinessEntityFieldDto> findFieldById(@Param(value="id") UUID var1);

    @Query(value="delete from business_entity be where be.id = :id and be.tenantId = :tenantId")
    @Modifying
    public void deleteByIdAndTenantId(@Param(value="id") UUID var1, @Param(value="tenantId") UUID var2);

    @Query(nativeQuery=true, value="WITH entity_fields AS (\n    SELECT id\n    FROM business_entity_field\n    WHERE id IN :entityFieldIdSet\n)\n    SELECT 'VIEW_CONFIG' AS TYPE, vc.name AS name\n    FROM view_config vc\n    WHERE vc.tenant_id = :tenantId\n        AND vc.customer_id IN :customerIdSet\n        AND vc.id IN (\n\t\t    SELECT vf.view_config_id\n\t\t    FROM view_field vf\n\t\t    WHERE vf.entity_field_id IN (\n\t\t\t\tSELECT id\n\t\t\t\tFROM entity_fields\n       \t\t)\n        )\nUNION\n    SELECT 'ANOMALY_MODEL' AS TYPE, cm.name AS name\n    FROM cluster_model cm\n    WHERE cm.tenant_id = :tenantId\n        AND (:customerId = :nullId OR cm.customer_id = :customerId)\n        AND (\n            (\n                cm.dataset_config_id IN (\n\t                SELECT dc.id\n       \t\t        FROM dataset_config dc\n       \t\t        WHERE dc.id IN (\n       \t\t\t        SELECT vf.dataset_config_id\n\t        \t        FROM view_field vf\n       \t\t\t        WHERE vf.entity_field_id IN (\n\t        \t\t        SELECT id\n\t        \t\t        FROM entity_fields\n\t\t\t\t        )\n\t\t\t\t    )\n\t\t\t\t)\n           \t) OR (\n           \t    cm.score_associated_field_id IN (\n           \t        SELECT id\n           \t        FROM entity_fields\n           \t    )\n           \t) OR (\n           \t    cm.score_index_associated_field_id IN (\n           \t        SELECT id\n           \t        FROM entity_fields\n           \t    )\n           \t)\n        )\nUNION\n    SELECT 'CALCULATION_FIELD' AS TYPE, cf.name AS name\n    FROM calculation_field cf\n    WHERE cf.tenant_id = :tenantId\n        AND (:customerId = :nullId OR cf.customer_id = :customerId)\n        AND cf.associated_entity_field_id IN (\n           \tSELECT id\n           \tFROM entity_fields\n        )\nUNION\n    SELECT 'PREDICTION_MODEL' AS TYPE, pm.name AS name\n    FROM prediction_model pm\n    WHERE pm.tenant_id = :tenantId\n        AND (:customerId = :nullId OR pm.customer_id = :customerId)\n        AND (\n            pm.associated_entity_field_id IN (\n           \t    SELECT id\n           \t    FROM entity_fields\n            ) OR CAST(CAST(pm.datasource_parameters AS JSONB) ->> 'businessEntityFieldId' AS UUID) IN (\n           \t    SELECT id\n           \t    FROM entity_fields\n            )\n        )\n")
    public List<Object[]> findDependedEntities(@Param(value="entityFieldIdSet") Set<UUID> var1, @Param(value="tenantId") UUID var2, @Param(value="customerId") UUID var3, @Param(value="customerIdSet") Set<UUID> var4, @Param(value="nullId") UUID var5);
}

