/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.dao.business;

import com.google.common.collect.Lists;
import jakarta.transaction.Transactional;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.trendz.dao.business.BusinessEntityDto;
import org.thingsboard.trendz.dao.business.BusinessEntityFieldDto;
import org.thingsboard.trendz.dao.business.BusinessEntityRepository;
import org.thingsboard.trendz.domain.definition.entity.BusinessEntity;
import org.thingsboard.trendz.domain.definition.entity.field.BusinessEntityField;
import org.thingsboard.trendz.domain.definition.entity.field.FieldQueryType;
import org.thingsboard.trendz.domain.definition.entity.field.FieldType;
import org.thingsboard.trendz.exception.service.definition.BusinessEntityFieldValidationException;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.service.definition.ChangeEntityValidationInfo;
import org.thingsboard.trendz.service.definition.ChangeEntityValidationItem;

@Service
@Transactional
public class BusinessEntityDao {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BusinessEntityDao.class);
    private static final Set<FieldQueryType> SYSTEM_FIELD_QUERY_TYPES = Set.of(FieldQueryType.ENTITY_ID, FieldQueryType.ENTITY_NAME, FieldQueryType.ENTITY_LABEL, FieldQueryType.OWNER);
    private final BusinessEntityRepository businessEntityRepository;

    @Autowired
    public BusinessEntityDao(BusinessEntityRepository businessEntityRepository) {
        this.businessEntityRepository = businessEntityRepository;
    }

    public boolean hasAnyEntity(UUID tenantId) {
        int count = this.businessEntityRepository.anyTenantEntityCount(tenantId);
        return count > 0;
    }

    public List<BusinessEntity> findAllByTenantId(UUID tenantId) {
        return this.businessEntityRepository.findAllByTenantId(tenantId).stream().map(BusinessEntityDto::toData).collect(Collectors.toList());
    }

    public Optional<BusinessEntity> findByIdAndTenantId(UUID id, UUID tenantId) {
        return this.businessEntityRepository.findByIdAndTenantId(id, tenantId).map(BusinessEntityDto::toData);
    }

    public Optional<BusinessEntityField> findFieldById(UUID id) {
        return this.businessEntityRepository.findFieldById(id).map(BusinessEntityFieldDto::toData);
    }

    public BusinessEntity saveEntity(BusinessEntity entity, UUID tenantId) {
        this.validateBusinessEntity(entity);
        BusinessEntityDto from = BusinessEntityDto.from((UUID)tenantId, (BusinessEntity)entity);
        BusinessEntityDto saved = (BusinessEntityDto)this.businessEntityRepository.save((Object)from);
        return saved.toData();
    }

    public List<BusinessEntity> saveAllEntities(List<BusinessEntity> entities, UUID tenantId) {
        List dtoList = entities.stream().peek(arg_0 -> this.validateBusinessEntity(arg_0)).map(entity -> BusinessEntityDto.from((UUID)tenantId, (BusinessEntity)entity)).collect(Collectors.toList());
        ArrayList savedDto = Lists.newArrayList((Iterable)this.businessEntityRepository.saveAll(dtoList));
        return savedDto.stream().map(BusinessEntityDto::toData).collect(Collectors.toList());
    }

    public void deleteByIdAndTenantId(UUID id, UUID tenantId) {
        this.businessEntityRepository.deleteByIdAndTenantId(id, tenantId);
    }

    public ChangeEntityValidationInfo findDependedEntities(JwtSecurityUser user, Set<UUID> relatedEntityFieldIdSet, Set<UUID> subCustomers) {
        UUID tenantId = user.getTenantId();
        UUID customerId = user.getCustomerId();
        Set dependencyItemSet = this.businessEntityRepository.findDependedEntities(relatedEntityFieldIdSet, tenantId, customerId, subCustomers, EntityId.NULL_UUID).stream().map(array -> new ChangeEntityValidationItem((String)array[0], (String)array[1])).collect(Collectors.toSet());
        return new ChangeEntityValidationInfo(dependencyItemSet);
    }

    private void validateBusinessEntity(BusinessEntity businessEntity) {
        List stringOnlyBusinessEntityFields = businessEntity.getFields() == null ? Collections.emptyList() : businessEntity.getFields();
        Optional<BusinessEntityField> invalidEntityField = stringOnlyBusinessEntityFields.stream().filter(entityField -> entityField.getQuery() != null && SYSTEM_FIELD_QUERY_TYPES.contains(entityField.getQuery().getQueryType()) && entityField.getType() != FieldType.STRING).findAny();
        if (invalidEntityField.isPresent()) {
            BusinessEntityField invalid = invalidEntityField.get();
            throw new BusinessEntityFieldValidationException("Business entity field with query type '%s' can have only 'STRING' field type.".formatted(invalid.getQuery().getQueryType()));
        }
    }
}

