/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.dao.assistance.customprompt;

import jakarta.transaction.Transactional;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.dao.assistance.customprompt.CustomPromptDto;
import org.thingsboard.trendz.dao.assistance.customprompt.CustomPromptRepository;
import org.thingsboard.trendz.domain.assistance.customprompt.CustomPrompt;
import org.thingsboard.trendz.domain.assistance.customprompt.CustomPromptFilteringField;
import org.thingsboard.trendz.domain.assistance.customprompt.CustomPromptLite;
import org.thingsboard.trendz.domain.assistance.customprompt.CustomPromptModifyCreateRequest;
import org.thingsboard.trendz.domain.assistance.customprompt.CustomPromptSortingField;
import org.thingsboard.trendz.exception.assistance.customprompt.CustomPromptModificationException;
import org.thingsboard.trendz.exception.assistance.customprompt.CustomPromptNotFoundException;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.service.definition.ChangeEntityValidationInfo;
import org.thingsboard.trendz.service.definition.ChangeEntityValidationItem;
import org.thingsboard.trendz.tools.UUIDUtils;

@Service
@Transactional
public class CustomPromptDao {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CustomPromptDao.class);
    private final CustomPromptRepository customPromptRepository;

    @Autowired
    public CustomPromptDao(CustomPromptRepository customPromptRepository) {
        this.customPromptRepository = customPromptRepository;
    }

    public CustomPrompt createCustomPrompt(CustomPromptModifyCreateRequest modifyCreateRequest, JwtSecurityUser user) {
        UUID tenantId = user.getTenantId();
        UUID customerId = UUIDUtils.mapNullUuidToNull((UUID)user.getCustomerId());
        UUID userId = UUIDUtils.mapNullUuidToNull((UUID)user.getUserId());
        long now = System.currentTimeMillis();
        CustomPromptDto customPromptDto = CustomPromptDto.builder().id(UUID.randomUUID()).name(modifyCreateRequest.getName()).prompt(modifyCreateRequest.getPrompt()).tenantId(tenantId).customerId(customerId).userId(userId).createdTs(now).lastModifiedTs(now).isDeleted(false).build();
        return ((CustomPromptDto)this.customPromptRepository.save((Object)customPromptDto)).toData();
    }

    public Page<CustomPromptLite> getAllCustomPromptLite(int page, int pageSize, JwtSecurityUser user, List<CustomPromptFilteringField> filteringFields, List<CustomPromptSortingField> sortingFields) {
        long startTime = System.currentTimeMillis();
        UUID tenantId = user.getTenantId();
        UUID customerId = UUIDUtils.mapNullUuidToNull((UUID)user.getCustomerId());
        Map<CustomPromptFilteringField.Type, String> filterMap = filteringFields.stream().collect(Collectors.toMap(CustomPromptFilteringField::getType, CustomPromptFilteringField::getValue));
        String isSystem = filterMap.getOrDefault(CustomPromptFilteringField.Type.IS_SYSTEM, null);
        List orders = sortingFields.stream().map(sortingField -> new Sort.Order(sortingField.getDirection(), sortingField.getType().getValue())).collect(Collectors.toList());
        Page customPromptLites = this.customPromptRepository.findAllCustomPromptLiteByTenantIdAndCustomerId(tenantId, customerId, isSystem, PageRequest.of((int)page, (int)pageSize, (Sort)Sort.by(orders)));
        long endTime = System.currentTimeMillis();
        log.debug("Custom Prompts' page has been loaded, count = {}, time = {}", (Object)customPromptLites.getSize(), (Object)(endTime - startTime));
        return customPromptLites;
    }

    public CustomPrompt findCustomPrompt(UUID promptId, JwtSecurityUser user) {
        UUID tenantId = user.getTenantId();
        UUID customerId = UUIDUtils.mapNullUuidToNull((UUID)user.getCustomerId());
        return this.customPromptRepository.findByIdAndTenantIdAndCustomerId(promptId, tenantId, customerId).map(CustomPromptDto::toData).orElseThrow(() -> new CustomPromptNotFoundException(promptId));
    }

    public CustomPrompt modifyCustomPrompt(UUID promptId, CustomPromptModifyCreateRequest modifyCreateRequest, JwtSecurityUser user) {
        UUID tenantId = user.getTenantId();
        UUID customerId = UUIDUtils.mapNullUuidToNull((UUID)user.getCustomerId());
        UUID userId = UUIDUtils.mapNullUuidToNull((UUID)user.getUserId());
        CustomPromptDto customPromptDto = (CustomPromptDto)this.customPromptRepository.findByIdAndTenantIdAndCustomerId(promptId, tenantId, customerId).orElseThrow(() -> new CustomPromptNotFoundException(promptId));
        if (customPromptDto.isSystem()) {
            throw new CustomPromptModificationException(promptId);
        }
        long now = System.currentTimeMillis();
        customPromptDto.setLastModifiedTs(now);
        if (modifyCreateRequest.getName() != null) {
            customPromptDto.setName(modifyCreateRequest.getName());
        }
        if (modifyCreateRequest.getPrompt() != null) {
            customPromptDto.setPrompt(modifyCreateRequest.getPrompt());
        }
        customPromptDto.setUserId(userId);
        return ((CustomPromptDto)this.customPromptRepository.save((Object)customPromptDto)).toData();
    }

    public void deleteCustomPrompt(UUID promptId, JwtSecurityUser user) {
        UUID tenantId = user.getTenantId();
        UUID customerId = UUIDUtils.mapNullUuidToNull((UUID)user.getCustomerId());
        UUID userId = UUIDUtils.mapNullUuidToNull((UUID)user.getUserId());
        CustomPromptDto customPromptDto = (CustomPromptDto)this.customPromptRepository.findByIdAndTenantIdAndCustomerId(promptId, tenantId, customerId).orElseThrow(() -> new CustomPromptNotFoundException(promptId));
        if (customPromptDto.isSystem()) {
            throw new CustomPromptModificationException(promptId);
        }
        customPromptDto.setDeleted(true);
        customPromptDto.setLastModifiedTs(System.currentTimeMillis());
        customPromptDto.setUserId(userId);
        this.customPromptRepository.save((Object)customPromptDto);
    }

    public List<CustomPrompt> getAllNonSystemPrompts(JwtSecurityUser user) {
        UUID tenantId = user.getTenantId();
        return this.customPromptRepository.findAllNonSystemByTenantId(tenantId).stream().map(CustomPromptDto::toData).toList();
    }

    public List<CustomPrompt> saveAllPrompts(List<CustomPrompt> newPrompts) {
        List<CustomPromptDto> collectionDtos = newPrompts.stream().map(CustomPromptDto::from).toList();
        return StreamSupport.stream(this.customPromptRepository.saveAll(collectionDtos).spliterator(), false).map(CustomPromptDto::toData).toList();
    }

    public List<CustomPromptLite> getAllSystemPromptLite() {
        return this.customPromptRepository.findAllSystemCustomPromptLite();
    }

    public ChangeEntityValidationInfo findDependedEntities(JwtSecurityUser user, CustomPrompt entity) {
        UUID tenantId = user.getTenantId();
        Set dependencyItemSet = this.customPromptRepository.findDependedEntities(tenantId, entity.getId()).stream().map(array -> new ChangeEntityValidationItem((String)array[0], (String)array[1])).collect(Collectors.toSet());
        return new ChangeEntityValidationInfo(dependencyItemSet);
    }
}

