/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.dao.assistance;

import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.CrudRepository;
import org.springframework.stereotype.Repository;
import org.thingsboard.trendz.dao.assistance.TokenUsageDto;

@Repository
public interface TokenUsageRepository
extends CrudRepository<TokenUsageDto, UUID> {
    @Query(value="SELECT tud\nFROM view_assistance_token_usage tud\nWHERE tud.tenantId = :tenantId\n    AND tud.startOfMonthTs = :startOfMonthTs\n    AND tud.isSystemModel = :isSystemModel\n")
    public List<TokenUsageDto> findAllByTenantAndMonthAndSystemModelFlag(UUID var1, long var2, boolean var4);

    @Query(nativeQuery=true, value="SELECT\n    tud.id,\n    tud.tenant_id,\n    tud.input_token_used,\n    tud.output_token_used,\n    tud.model_name,\n    tud.start_of_month_ts,\n    tud.is_system_model\nFROM view_assistance_token_usage tud\nWHERE tud.tenant_id = :tenantId\n    AND tud.start_of_month_ts = :startOfMonthTs\n    AND tud.model_name = :modelName\n    AND tud.is_system_model = :isSystemModel\nFOR UPDATE\n")
    public Optional<String> findByTenantAndMonthAndModelNameAndSystemModelFlag(UUID var1, long var2, String var4, boolean var5);

    @Query(value="SELECT new org.thingsboard.trendz.dao.assistance.TokenUsageDto(\n    SUM(tud.inputTokenUsed),\n    SUM(tud.outputTokenUsed),\n    tud.modelName,\n    :startOfMonthTs\n)\nFROM view_assistance_token_usage tud\nWHERE tud.startOfMonthTs = :startOfMonthTs\n    AND tud.isSystemModel = :isSystemModel\nGROUP BY tud.modelName\n")
    public List<TokenUsageDto> findTotalByMonthAndSystemModelFlag(long var1, boolean var3);
}

