/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.dao.assistance;

import jakarta.transaction.Transactional;
import java.util.List;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.dao.assistance.TokenUsageDto;
import org.thingsboard.trendz.dao.assistance.TokenUsageRepository;
import org.thingsboard.trendz.domain.assistance.model.TokenUsageRecord;

@Service
@Transactional
public class TokenUsageDao {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TokenUsageDao.class);
    private final TokenUsageRepository tokenUsageRepository;

    @Autowired
    public TokenUsageDao(TokenUsageRepository tokenUsageRepository) {
        this.tokenUsageRepository = tokenUsageRepository;
    }

    public List<TokenUsageRecord> findTotalTokenUsageForCurrentMonth(long startOfCurrentMonth, boolean isSystemModel) {
        return this.tokenUsageRepository.findTotalByMonthAndSystemModelFlag(startOfCurrentMonth, isSystemModel).stream().map(TokenUsageDto::toData).toList();
    }

    public List<TokenUsageRecord> findAllTokenUsageForCurrentMonthForTenant(UUID tenantId, long startOfCurrentMonth, boolean isSystemModel) {
        return this.tokenUsageRepository.findAllByTenantAndMonthAndSystemModelFlag(tenantId, startOfCurrentMonth, isSystemModel).stream().map(TokenUsageDto::toData).toList();
    }

    public void save(TokenUsageRecord tokenUsageRecord) {
        long startOfMonthTs = tokenUsageRecord.getStartOfMonthTs();
        UUID tenantId = tokenUsageRecord.getTenantId();
        String modelName = tokenUsageRecord.getModelName();
        boolean isSystemModel = tokenUsageRecord.isSystemModel();
        TokenUsageDto tokenUsageDto = this.tokenUsageRepository.findByTenantAndMonthAndModelNameAndSystemModelFlag(tenantId, startOfMonthTs, modelName, isSystemModel).map(result -> result.split(",")).map(objects -> TokenUsageDto.builder().id(UUID.fromString(objects[0])).tenantId(UUID.fromString(objects[1])).inputTokenUsed(Long.parseLong(objects[2])).outputTokenUsed(Long.parseLong(objects[3])).modelName(objects[4]).startOfMonthTs(Long.parseLong(objects[5])).isSystemModel(Boolean.parseBoolean(objects[6])).build()).orElseGet(() -> TokenUsageDto.builder().id(UUID.randomUUID()).tenantId(tenantId).modelName(modelName).startOfMonthTs(startOfMonthTs).isSystemModel(isSystemModel).build());
        tokenUsageDto.setInputTokenUsed(tokenUsageDto.getInputTokenUsed() + tokenUsageRecord.getInputUsed());
        tokenUsageDto.setOutputTokenUsed(tokenUsageDto.getOutputTokenUsed() + tokenUsageRecord.getOutputUsed());
        this.tokenUsageRepository.save((Object)tokenUsageDto);
    }
}

