/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.dao.assistance;

import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.CrudRepository;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;
import org.thingsboard.trendz.dao.assistance.AgentAiDto;

@Repository
public interface AgentAiRepository
extends CrudRepository<AgentAiDto, UUID> {
    @Query(value="select aa from agent_ai aa where aa.agentType = :type order by version desc limit 1")
    public Optional<AgentAiDto> findByTypeWithLatestVersion(@Param(value="type") String var1);

    @Query(value="select aa from agent_ai aa where aa.agentType = :type")
    public List<AgentAiDto> findAllByType(@Param(value="type") String var1);

    @Query(value="select aa from agent_ai aa where aa.version = :version order by aa.agentType")
    public List<AgentAiDto> findAllByVersion(@Param(value="version") int var1);

    @Query(value="select aa\nfrom agent_ai aa\nwhere aa.version = (\n    select max(sq.version)\n    from agent_ai sq\n    where sq.agentType = aa.agentType\n)\norder by aa.agentType\n")
    public List<AgentAiDto> findAllWithLatestVersion();

    @Query(value="select aa from agent_ai aa where aa.version = :version and aa.agentType = :type")
    public List<AgentAiDto> findAllByTypeAndVersion(@Param(value="type") String var1, @Param(value="version") int var2);
}

