/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.controller;

import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.thingsboard.trendz.controller.BaseController;
import org.thingsboard.trendz.service.translation.TranslationService;

@RestController
@RequestMapping(value={"/apiTrendz/translations"})
public class TranslationsController
extends BaseController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TranslationsController.class);
    private final TranslationService translationService;

    @Autowired
    public TranslationsController(TranslationService translationService) {
        this.translationService = translationService;
    }

    @GetMapping(produces={"application/json"})
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    public ResponseEntity<String> getTranslationsAfterLogin(@RequestParam(value="lang") String lang) {
        String translation = this.translationService.getTranslationAfterLogin(lang, this.getSecurityUser());
        return ResponseEntity.ok((Object)translation);
    }
}

