/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.controller;

import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import lombok.Generated;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.thingsboard.trendz.controller.BaseController;
import org.thingsboard.trendz.exception.service.provider.TbWebClientException;
import org.thingsboard.trendz.service.mfa.TbMfaProxyService;

@RestController
@RequestMapping(value={"/apiTrendz/auth/2fa"})
public class TbMfaProxyController
extends BaseController {
    private final TbMfaProxyService tbMfaProxyService;

    @RequestMapping(value={"/**"}, produces={"application/json"})
    @PreAuthorize(value="hasAuthority('PRE_VERIFICATION_TOKEN')")
    public ResponseEntity<?> forwardRequestsToTb(HttpServletRequest request) {
        try {
            return ResponseEntity.ok((Object)this.tbMfaProxyService.forwardRequest(request));
        }
        catch (IOException e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)"Internal Server error");
        }
        catch (TbWebClientException e) {
            if (e.getCause() instanceof WebClientResponseException) {
                String tbErrorMsg = ((WebClientResponseException)e.getCause()).getResponseBodyAsString();
                return ResponseEntity.badRequest().body((Object)tbErrorMsg);
            }
            throw e;
        }
    }

    @Generated
    public TbMfaProxyController(TbMfaProxyService tbMfaProxyService) {
        this.tbMfaProxyService = tbMfaProxyService;
    }
}

