/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.controller;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.validation.Valid;
import java.util.List;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.thingsboard.trendz.controller.BaseController;
import org.thingsboard.trendz.domain.tb.dashboard.entity.DashboardData;
import org.thingsboard.trendz.domain.tb.dashboard.request.DashboardExportRequest;
import org.thingsboard.trendz.domain.tb.dashboard.request.DashboardExportViewsRequest;
import org.thingsboard.trendz.domain.tb.dashboard.response.DashboardExportResponse;
import org.thingsboard.trendz.domain.tb.info.TbInfo;
import org.thingsboard.trendz.domain.tb.widget.base.TbResourceStatus;
import org.thingsboard.trendz.domain.tb.widget.base.UploadTbResourceStatus;
import org.thingsboard.trendz.domain.tb.widget.base.UploadWidgetBundleRequest;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.service.provider.version.TbVersionChecker;
import org.thingsboard.trendz.service.tb.dashboard.DashboardService;
import org.thingsboard.trendz.service.tb.module.TbModuleService;
import org.thingsboard.trendz.service.tb.widget.NativeWidgetBundleService;
import org.thingsboard.trendz.service.tb.widget.NativeWidgetBundleServiceComposite;

@RestController
@RequestMapping(value={"/apiTrendz/tb"})
public class TbController
extends BaseController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TbController.class);
    private final NativeWidgetBundleService nativeWidgetBundleService;
    private final DashboardService dashboardService;
    private final TbModuleService tbModuleService;
    private final TbVersionChecker tbVersionChecker;

    @Autowired
    public TbController(NativeWidgetBundleServiceComposite nativeWidgetBundleService, DashboardService dashboardService, TbModuleService tbModuleService, TbVersionChecker tbVersionChecker) {
        this.nativeWidgetBundleService = nativeWidgetBundleService;
        this.dashboardService = dashboardService;
        this.tbModuleService = tbModuleService;
        this.tbVersionChecker = tbVersionChecker;
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @GetMapping(value={"/bundle-exists"})
    @ResponseBody
    public ResponseEntity<?> bundleExists() {
        JwtSecurityUser user = this.getSecurityUser();
        boolean bundleExists = this.nativeWidgetBundleService.bundleExists(user);
        log.info("Widget bundle exists: {}", (Object)bundleExists);
        return ResponseEntity.ok((Object)bundleExists);
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN')")
    @PostMapping(value={"/get-bundle-status"})
    @ResponseBody
    public ResponseEntity<?> getWidgetBundleStatus(HttpServletRequest request, @RequestBody UploadWidgetBundleRequest bundleRequest) {
        JwtSecurityUser user = this.getSecurityUser();
        String domain = request.getServerName();
        String externalUrl = bundleRequest.getTrendzUrl();
        log.info("Widget bundle status request, domain: {}, external URL: {}", (Object)domain, (Object)externalUrl);
        TbResourceStatus bundleStatus = this.nativeWidgetBundleService.getBundleStatus(user, domain, externalUrl);
        log.info("Widget bundle status: {}", (Object)bundleStatus);
        return ResponseEntity.ok((Object)bundleStatus);
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN')")
    @PostMapping(value={"/upload-native-widget-bundle"})
    @ResponseBody
    public ResponseEntity<?> uploadNativeWidgetBundle(HttpServletRequest request, @RequestBody UploadWidgetBundleRequest bundleRequest) {
        JwtSecurityUser user = this.getSecurityUser();
        String domain = request.getServerName();
        String externalUrl = bundleRequest.getTrendzUrl();
        log.info("Widget bundle update request, domain: {}, external URL: {}", (Object)domain, (Object)externalUrl);
        UploadTbResourceStatus bundleStatus = this.nativeWidgetBundleService.uploadNativeWidgetBundle(user, domain, externalUrl);
        return ResponseEntity.ok((Object)bundleStatus);
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN')")
    @GetMapping(value={"/get-module-status"})
    @ResponseBody
    public ResponseEntity<?> getModuleStatus(HttpServletRequest request) {
        String domain = request.getServerName();
        JwtSecurityUser user = this.getSecurityUser();
        TbResourceStatus resourceStatus = this.tbModuleService.getModuleStatus(user, domain);
        return ResponseEntity.ok((Object)resourceStatus);
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN')")
    @PostMapping(value={"/upload-module"})
    @ResponseBody
    public ResponseEntity<?> uploadModule(HttpServletRequest request) {
        String domain = request.getServerName();
        JwtSecurityUser user = this.getSecurityUser();
        UploadTbResourceStatus resourceStatus = this.tbModuleService.uploadModule(user, domain);
        return ResponseEntity.ok((Object)resourceStatus);
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @GetMapping(value={"/load-all-dashboard-labels"})
    @ResponseBody
    public ResponseEntity<?> getAllDashboardLabels() {
        JwtSecurityUser user = this.getSecurityUser();
        List allDashboardLites = this.dashboardService.getAllDashboardLabels(user);
        return ResponseEntity.ok((Object)allDashboardLites);
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @GetMapping(value={"/load-dashboard/{dashboardId}"})
    @ResponseBody
    public ResponseEntity<?> getDashboard(@PathVariable(value="dashboardId") UUID dashboardId) {
        DashboardData dashboard = this.dashboardService.loadSelectedDashboard(dashboardId, this.getSecurityUser());
        return ResponseEntity.ok((Object)dashboard);
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @PostMapping(value={"/export-view-to-dashboard"})
    @ResponseBody
    public ResponseEntity<?> exportCurrentViewOnDashboard(HttpServletRequest request, @Valid @RequestBody DashboardExportRequest dashboardExportRequest) {
        String domain = request.getServerName();
        JwtSecurityUser user = this.getSecurityUser();
        DashboardExportResponse result = this.dashboardService.exportCurrentViewOnDashboard(dashboardExportRequest.getIsNewDashboard().booleanValue(), dashboardExportRequest.getDashboardName(), dashboardExportRequest.getDashboardId(), dashboardExportRequest.getDashboardState(), dashboardExportRequest.getEntityId(), user, domain, dashboardExportRequest.getUrl(), dashboardExportRequest.getViewConfigId(), dashboardExportRequest.getFilterName());
        return ResponseEntity.ok((Object)result);
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @PostMapping(value={"/export-views-to-dashboard"})
    @ResponseBody
    public ResponseEntity<?> exportSelectedViewsOnDashboard(HttpServletRequest request, @Valid @RequestBody DashboardExportViewsRequest dashboardExportViewsRequest) {
        String domain = request.getServerName();
        DashboardExportResponse result = this.dashboardService.exportSelectedViewsOnDashboard(dashboardExportViewsRequest, domain, this.getSecurityUser());
        return ResponseEntity.ok((Object)result);
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @GetMapping(value={"/info"})
    @ResponseBody
    public ResponseEntity<?> getTbInfo() {
        JwtSecurityUser user = this.getSecurityUser();
        TbInfo tbInfo = this.tbVersionChecker.getTbInfo(user);
        return ResponseEntity.ok((Object)tbInfo);
    }
}

