/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.controller;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.validation.Valid;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.thingsboard.trendz.controller.BaseController;
import org.thingsboard.trendz.domain.customize.CustomViewSettings;
import org.thingsboard.trendz.security.entity.AuthToken;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.service.cache.CachedTelemetryService;
import org.thingsboard.trendz.service.customize.CustomizationService;
import org.thingsboard.trendz.service.provider.cache.CacheService;
import org.thingsboard.trendz.service.system.SigningKeySetupService;
import org.thingsboard.trendz.service.system.SysadminCredentials;
import org.thingsboard.trendz.service.system.SysadminTokenRequest;
import org.thingsboard.trendz.subscription.LicenceService;
import org.thingsboard.trendz.subscription.TrendzLicenceInfo;
import org.thingsboard.trendz.tools.DonReactive;
import reactor.core.publisher.Mono;

@RestController
@RequestMapping(value={"/apiTrendz/system"})
public class SystemController
extends BaseController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SystemController.class);
    private final CachedTelemetryService cachedTelemetryService;
    private final CacheService cacheService;
    private final LicenceService licenceService;
    private final CustomizationService customizationService;
    private final SigningKeySetupService signingKeySetupService;

    @Autowired
    public SystemController(CachedTelemetryService cachedTelemetryService, CacheService cacheService, LicenceService licenceService, CustomizationService customizationService, SigningKeySetupService signingKeySetupService) {
        this.cachedTelemetryService = cachedTelemetryService;
        this.cacheService = cacheService;
        this.licenceService = licenceService;
        this.customizationService = customizationService;
        this.signingKeySetupService = signingKeySetupService;
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @PostMapping(value={"/caches/telemetry/remove"})
    @ResponseBody
    public boolean removeTelemetryCaches() {
        DonReactive.block((Mono)this.cachedTelemetryService.removeAllCacheByTenantId(this.getSecurityUser().getTenant()));
        return true;
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @PostMapping(value={"/caches/local/remove"})
    @ResponseBody
    public boolean removeLocalCaches() {
        this.cacheService.clearCaches();
        return true;
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @GetMapping(value={"/licence/info"})
    @ResponseBody
    public ResponseEntity<?> provideLicenceInfo() {
        JwtSecurityUser user = this.getSecurityUser();
        TrendzLicenceInfo licenceInfo = this.licenceService.provideLicenceInfo(user);
        return ResponseEntity.ok((Object)licenceInfo);
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @GetMapping(value={"/customization/get"})
    @ResponseBody
    public ResponseEntity<?> provideCustomViewSettings(HttpServletRequest request) {
        String domain = request.getServerName();
        JwtSecurityUser user = this.getSecurityUser();
        CustomViewSettings customizationData = this.customizationService.getCustomViewSettings(domain, user);
        return ResponseEntity.ok((Object)customizationData);
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN')")
    @PostMapping(value={"/customization/set"})
    @ResponseBody
    public ResponseEntity<?> setupCustomViewSettings(@RequestBody CustomViewSettings customizationData, HttpServletRequest request) {
        String domain = request.getServerName();
        CustomViewSettings settings = this.customizationService.setupCustomViewSettings(customizationData, domain, this.getSecurityUser());
        return ResponseEntity.ok((Object)settings);
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN')")
    @GetMapping(value={"/customization/access"})
    @ResponseBody
    public ResponseEntity<?> checkAccessOfWhitelabeling() {
        JwtSecurityUser user = this.getSecurityUser();
        boolean enabled = this.customizationService.checkAccessOfWhiteLabeling(user);
        return ResponseEntity.ok((Object)enabled);
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN')")
    @PostMapping(value={"/customization/detach"})
    @ResponseBody
    public ResponseEntity<?> detachFromDomains(HttpServletRequest request) {
        String domain = request.getServerName();
        JwtSecurityUser user = this.getSecurityUser();
        this.customizationService.detachFromDomains(user, domain);
        return ResponseEntity.ok((Object)"OK");
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @GetMapping(value={"/user-language"})
    @ResponseBody
    public ResponseEntity<?> fetchUserLanguage() {
        JwtSecurityUser securityUser = this.getSecurityUser();
        String userLanguage = this.customizationService.fetchUserLanguage(securityUser);
        return ResponseEntity.ok((Object)userLanguage);
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN')")
    @PostMapping(value={"/signingKey/login"})
    @ResponseBody
    public ResponseEntity<?> loginAsSysadmin(@Valid @RequestBody SysadminCredentials credentials) {
        JwtSecurityUser securityUser = this.getSecurityUser();
        AuthToken authToken = this.signingKeySetupService.loginAsSysadmin(securityUser, credentials);
        return ResponseEntity.ok((Object)authToken);
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN')")
    @PostMapping(value={"/signingKey/setup"})
    @ResponseBody
    public ResponseEntity<?> setupSigningKey(@Valid @RequestBody SysadminTokenRequest sysadminJwtToken) {
        JwtSecurityUser securityUser = this.getSecurityUser();
        this.signingKeySetupService.setupSigningKey(securityUser, sysadminJwtToken);
        return ResponseEntity.ok((Object)true);
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN')")
    @GetMapping(value={"/signingKey/check"})
    @ResponseBody
    public ResponseEntity<?> checkSigningKey() {
        JwtSecurityUser securityUser = this.getSecurityUser();
        boolean isValid = this.signingKeySetupService.checkSigningKey(securityUser);
        return ResponseEntity.ok((Object)isValid);
    }
}

