/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.controller;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.validation.Valid;
import java.util.concurrent.Executor;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ClassPathResource;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.context.request.async.DeferredResult;
import org.thingsboard.trendz.controller.BaseController;
import org.thingsboard.trendz.domain.customize.CustomViewSettings;
import org.thingsboard.trendz.domain.simple.BuildViewByReferenceTask;
import org.thingsboard.trendz.domain.simple.SimpleApiTask;
import org.thingsboard.trendz.domain.simple.SimpleViewReport;
import org.thingsboard.trendz.domain.simple.ViewConfigReference;
import org.thingsboard.trendz.domain.tb.configuration.SyncCheckRequest;
import org.thingsboard.trendz.domain.tb.configuration.SyncInitRequest;
import org.thingsboard.trendz.domain.tb.configuration.SyncResponse;
import org.thingsboard.trendz.domain.version.TrendzVersion;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.service.customize.CustomizationService;
import org.thingsboard.trendz.service.simple.SimpleApiServiceRateLimiter;
import org.thingsboard.trendz.service.tb.configuration.TbConfigurationService;
import org.thingsboard.trendz.service.translation.TranslationService;
import org.thingsboard.trendz.service.version.TrendzVersionService;
import org.thingsboard.trendz.tools.DonReactive;
import reactor.core.publisher.Mono;

@Controller
@RequestMapping(value={"/apiTrendz/publicApi"})
public class PublicApiController
extends BaseController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PublicApiController.class);
    private final CustomizationService customizationService;
    private final TranslationService translationService;
    private final TrendzVersionService trendzVersionService;
    private final TbConfigurationService tbConfigurationService;
    private final SimpleApiServiceRateLimiter simpleApiServiceRateLimiter;

    @Autowired
    public PublicApiController(CustomizationService customizationService, TranslationService translationService, TrendzVersionService trendzVersionService, TbConfigurationService tbConfigurationService, SimpleApiServiceRateLimiter simpleApiServiceRateLimiter) {
        this.customizationService = customizationService;
        this.translationService = translationService;
        this.trendzVersionService = trendzVersionService;
        this.tbConfigurationService = tbConfigurationService;
        this.simpleApiServiceRateLimiter = simpleApiServiceRateLimiter;
    }

    @GetMapping(value={"/info"})
    @ResponseBody
    public ResponseEntity<?> getSystemVersionInfo() {
        TrendzVersion trendzVersion = this.trendzVersionService.getTrendzVersion();
        return ResponseEntity.ok((Object)trendzVersion);
    }

    @PostMapping(value={"/download/ai-summary-module.js"})
    @ResponseBody
    public ResponseEntity<?> downloadTrendzAiSummary() {
        ClassPathResource resource = new ClassPathResource("modules/ai-summary-module.js");
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Content-Disposition", new String[]{"attachment; filename=ai-summary-module.js"})).contentType(MediaType.APPLICATION_OCTET_STREAM).body((Object)resource);
    }

    @PostMapping(value={"/sync/init"})
    @ResponseBody
    public DeferredResult<ResponseEntity<SyncResponse>> doSynchronization(@Valid @RequestBody SyncInitRequest request, HttpServletRequest httpServletRequest) {
        return this.tbConfigurationService.doSynchronization(request, httpServletRequest.getServerName());
    }

    @PostMapping(value={"/sync/check"})
    @ResponseBody
    public ResponseEntity<SyncResponse> doHealthCheck(@RequestBody SyncCheckRequest request) {
        SyncResponse status = (SyncResponse)DonReactive.block((Mono)this.tbConfigurationService.doHealthCheck(request));
        return ResponseEntity.ok((Object)status);
    }

    @GetMapping(value={"/translations"}, produces={"application/json"})
    public ResponseEntity<String> getTranslationsBeforeLogin(@RequestParam(value="lang") String lang) {
        String translation = this.translationService.getTranslationsBeforeLogin(lang);
        return ResponseEntity.ok((Object)translation);
    }

    @GetMapping(value={"/customization/get"})
    @ResponseBody
    public ResponseEntity<?> provideCustomViewSettingsPublic(HttpServletRequest request) {
        String domain = request.getServerName();
        JwtSecurityUser securityUser = JwtSecurityUser.NOT_USER;
        CustomViewSettings customizationData = this.customizationService.getCustomViewSettings(domain, securityUser);
        return ResponseEntity.ok((Object)customizationData);
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @PostMapping(value={"/buildReport"}, produces={"application/json"})
    @ResponseBody
    public DeferredResult<ResponseEntity<SimpleViewReport>> buildViewByReference(@RequestBody ViewConfigReference viewConfigReference) {
        JwtSecurityUser user = this.getSecurityUser();
        BuildViewByReferenceTask task = BuildViewByReferenceTask.builder().reference(viewConfigReference).securityUser(user).build();
        DeferredResult result = new DeferredResult();
        ListenableFuture simpleApiTaskListenableFuture = this.simpleApiServiceRateLimiter.submitTask((SimpleApiTask)task);
        Futures.addCallback((ListenableFuture)simpleApiTaskListenableFuture, (FutureCallback)new /* Unavailable Anonymous Inner Class!! */, (Executor)MoreExecutors.directExecutor());
        return result;
    }
}

