/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.controller;

import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.thingsboard.trendz.controller.BaseController;
import org.thingsboard.trendz.exception.model.prediction.PredictionModelNotFoundByEntityFieldException;
import org.thingsboard.trendz.exception.model.prediction.PredictionModelNotFoundException;
import org.thingsboard.trendz.exception.task.TaskNotFoundException;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.service.definition.ChangeEntityValidationInfo;
import org.thingsboard.trendz.service.model.prediction.PredictionModel;
import org.thingsboard.trendz.service.model.prediction.PredictionModelConfig;
import org.thingsboard.trendz.service.model.prediction.PredictionModelFilteringField;
import org.thingsboard.trendz.service.model.prediction.PredictionModelService;
import org.thingsboard.trendz.service.model.prediction.PredictionModelSortingField;
import org.thingsboard.trendz.service.model.prediction.PredictionModelTaskData;
import org.thingsboard.trendz.service.task.TaskService;
import org.thingsboard.trendz.service.task.model.Task;
import org.thingsboard.trendz.service.task.model.TaskReference;
import org.thingsboard.trendz.service.task.model.TaskReferencedEntityType;
import org.thingsboard.trendz.tools.PaginationPage;
import org.thingsboard.trendz.tools.UUIDUtils;

@RestController
@RequestMapping(value={"/apiTrendz/model/prediction"})
public class PredictionModelController
extends BaseController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PredictionModelController.class);
    private final PredictionModelService predictionModelService;
    private final TaskService taskService;

    @Autowired
    public PredictionModelController(PredictionModelService predictionModelService, TaskService taskService) {
        this.predictionModelService = predictionModelService;
        this.taskService = taskService;
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/all"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<?> getAll(@RequestParam(value="page", required=false, defaultValue="0") String pageStr, @RequestParam(value="pageSize", required=false, defaultValue="1000") String pageSizeStr, @RequestParam(value="filter", required=false, defaultValue="") List<String> filter, @RequestParam(value="sort", required=false, defaultValue="createdTs:desc") List<String> sort) {
        JwtSecurityUser user = this.getSecurityUser();
        int page = Integer.parseInt(pageStr);
        int pageSize = Integer.parseInt(pageSizeStr);
        List filteringFields = filter.stream().map(PredictionModelFilteringField::fromString).collect(Collectors.toList());
        List sortingFields = sort.stream().map(PredictionModelSortingField::fromString).collect(Collectors.toList());
        Page all = this.predictionModelService.getAllLite(page, pageSize, user, filteringFields, sortingFields);
        PaginationPage allPage = new PaginationPage(all);
        return ResponseEntity.ok((Object)allPage);
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/{modelId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<?> getById(@PathVariable(value="modelId") String modelIdStr) {
        JwtSecurityUser user = this.getSecurityUser();
        UUID modelId = UUIDUtils.parse((String)modelIdStr);
        PredictionModel predictionModel = (PredictionModel)this.predictionModelService.findById(user, modelId, true).orElseThrow(() -> new PredictionModelNotFoundException(modelId));
        return ResponseEntity.ok((Object)predictionModel);
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/delete/{modelId}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseEntity<?> deleteById(@PathVariable(value="modelId") String modelIdStr) {
        JwtSecurityUser user = this.getSecurityUser();
        UUID modelId = UUIDUtils.parse((String)modelIdStr);
        this.predictionModelService.deleteById(user, modelId);
        return ResponseEntity.ok((Object)true);
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/save"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<?> saveAndTrain(@RequestBody PredictionModelConfig config) {
        JwtSecurityUser user = this.getSecurityUser();
        PredictionModel model = this.predictionModelService.saveModel(user, config);
        TaskReference trainTaskReference = new TaskReference(TaskReferencedEntityType.PREDICTION_MODEL_TRAIN, model.getId().toString());
        TaskReference accuracyTaskReference = new TaskReference(TaskReferencedEntityType.PREDICTION_MODEL_ACCURACY, model.getId().toString());
        TaskReference refreshTaskReference = new TaskReference(TaskReferencedEntityType.PREDICTION_MODEL_REFRESH, model.getId().toString());
        Task trainTask = (Task)this.taskService.findTaskByReferencedEntity(user, trainTaskReference).orElseThrow(() -> new TaskNotFoundException(trainTaskReference));
        Task accuracyTask = (Task)this.taskService.findTaskByReferencedEntity(user, accuracyTaskReference).orElseThrow(() -> new TaskNotFoundException(accuracyTaskReference));
        Task refreshTask = (Task)this.taskService.findTaskByReferencedEntity(user, refreshTaskReference).orElseThrow(() -> new TaskNotFoundException(refreshTaskReference));
        this.taskService.cancelExecutionsByTaskId(user, accuracyTask.getId());
        this.taskService.cancelExecutionsByTaskId(user, refreshTask.getId());
        UUID executionId = this.taskService.runExecution(user, trainTask.getId(), true);
        return ResponseEntity.ok((Object)executionId);
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/taskData/{modelId}"}, method={RequestMethod.GET})
    public ResponseEntity<?> getTaskData(@PathVariable(value="modelId") String modelIdStr) {
        JwtSecurityUser user = this.getSecurityUser();
        UUID modelId = UUIDUtils.parse((String)modelIdStr);
        PredictionModelTaskData taskData = this.predictionModelService.getTaskData(user, modelId);
        return ResponseEntity.ok((Object)taskData);
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/taskData"}, method={RequestMethod.POST})
    public ResponseEntity<?> saveTaskData(@RequestBody PredictionModelTaskData taskData) {
        JwtSecurityUser user = this.getSecurityUser();
        PredictionModelTaskData result = this.predictionModelService.saveTaskData(user, taskData, false);
        return ResponseEntity.ok((Object)result);
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/byEntityField/{entityFieldId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<?> getModelByBusinessEntityFieldId(@PathVariable(value="entityFieldId") String entityFieldIdStr) {
        JwtSecurityUser user = this.getSecurityUser();
        UUID entityFieldId = UUIDUtils.parse((String)entityFieldIdStr);
        PredictionModel predictionModel = (PredictionModel)this.predictionModelService.findFieldByEntityFieldId(entityFieldId, user, true).orElseThrow(() -> new PredictionModelNotFoundByEntityFieldException(entityFieldId));
        return ResponseEntity.ok((Object)predictionModel);
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/dependedEntities/{fieldId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<?> findDependedEntities(@PathVariable(value="fieldId") String strFieldId) {
        JwtSecurityUser securityUser = this.getSecurityUser();
        UUID fieldId = UUIDUtils.parse((String)strFieldId);
        ChangeEntityValidationInfo dependedEntitiesInfo = this.predictionModelService.findDependedEntities(securityUser, fieldId);
        return ResponseEntity.ok((Object)dependedEntitiesInfo);
    }
}

