/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.controller;

import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.thingsboard.trendz.controller.BaseController;
import org.thingsboard.trendz.domain.chat.ChatType;
import org.thingsboard.trendz.domain.metric.CalculationCreationRequest;
import org.thingsboard.trendz.domain.metric.MetricCalculationRequest;
import org.thingsboard.trendz.domain.metric.MetricDefinition;
import org.thingsboard.trendz.domain.metric.MetricDefinitionCalculationStatus;
import org.thingsboard.trendz.domain.metric.MetricDefinitionCreationRequest;
import org.thingsboard.trendz.domain.metric.MetricDefinitionFilteringField;
import org.thingsboard.trendz.domain.metric.MetricDefinitionModificationRequest;
import org.thingsboard.trendz.domain.metric.MetricDefinitionSortingField;
import org.thingsboard.trendz.domain.metric.MetricFinderRequest;
import org.thingsboard.trendz.domain.metric.exploration.MetricExplorationSaveRequest;
import org.thingsboard.trendz.exception.task.TaskNotFoundException;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.service.assistance.llm.LlmService;
import org.thingsboard.trendz.service.metric.MetricDefinitionService;
import org.thingsboard.trendz.service.metric.MetricExplorationService;
import org.thingsboard.trendz.service.task.TaskJob;
import org.thingsboard.trendz.service.task.TaskService;
import org.thingsboard.trendz.service.task.job.metric.MetricDefinitionGenerateJob;
import org.thingsboard.trendz.service.task.job.metric.MetricDefinitionImplementationJob;
import org.thingsboard.trendz.service.task.model.Task;
import org.thingsboard.trendz.service.task.model.TaskReference;
import org.thingsboard.trendz.service.task.model.TaskReferencedEntityType;
import org.thingsboard.trendz.tools.PaginationPage;
import org.thingsboard.trendz.tools.UUIDUtils;

@RestController
@RequestMapping(value={"/apiTrendz/metric/explorer"})
public class MetricExplorationController
extends BaseController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MetricExplorationController.class);
    private final MetricDefinitionService metricDefinitionService;
    private final MetricExplorationService metricExplorationService;
    private final TaskService taskService;
    private final LlmService llmService;

    @Autowired
    public MetricExplorationController(MetricDefinitionService metricDefinitionService, MetricExplorationService metricExplorationService, TaskService taskService, LlmService llmService) {
        this.metricDefinitionService = metricDefinitionService;
        this.metricExplorationService = metricExplorationService;
        this.taskService = taskService;
        this.llmService = llmService;
    }

    @ResponseBody
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/{businessEntityIdString}/generate/{itemIdString}"}, method={RequestMethod.POST})
    public ResponseEntity<UUID> generate(@PathVariable(value="businessEntityIdString") String businessEntityIdString, @PathVariable(value="itemIdString") String itemIdString, @RequestBody MetricFinderRequest metricFinderRequest) {
        this.llmService.validateChatTypeForUser(this.getSecurityUser(), ChatType.METRIC_CODE_ASSISTANT);
        UUID businessEntityId = UUIDUtils.parse((String)businessEntityIdString);
        UUID itemId = UUIDUtils.parse((String)itemIdString);
        JwtSecurityUser user = this.getSecurityUser();
        TaskReference reference = new TaskReference(TaskReferencedEntityType.METRIC_DEFINITION_GENERATE, user.getTenantCustomerKey());
        MetricDefinitionGenerateJob metricFinderJob = MetricDefinitionGenerateJob.builder().businessEntityId(businessEntityId).itemId(itemId).metricFinderRequest(metricFinderRequest).build();
        Task task = (Task)this.taskService.findTaskByReferencedEntity(user, reference, true).orElseThrow(() -> new TaskNotFoundException(reference));
        UUID executionId = this.taskService.runExecution(user, task.getId(), (TaskJob)metricFinderJob, false);
        return ResponseEntity.ok((Object)executionId);
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/metrics"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<PaginationPage<MetricDefinition>> getAllMetricDefinitions(@RequestParam(value="page", required=false, defaultValue="0") String pageStr, @RequestParam(value="pageSize", required=false, defaultValue="1000") String pageSizeStr, @RequestParam(value="filter", required=false, defaultValue="") List<String> filter, @RequestParam(value="sort", required=false, defaultValue="createdTs:desc") List<String> sort) {
        JwtSecurityUser user = this.getSecurityUser();
        int page = Integer.parseInt(pageStr);
        int pageSize = Integer.parseInt(pageSizeStr);
        List filteringFields = filter.stream().map(MetricDefinitionFilteringField::fromString).collect(Collectors.toList());
        List sortingFields = sort.stream().map(MetricDefinitionSortingField::fromString).collect(Collectors.toList());
        Page all = this.metricDefinitionService.getAllMetricDefinitions(page, pageSize, user, filteringFields, sortingFields);
        PaginationPage allPage = new PaginationPage(all);
        return ResponseEntity.ok((Object)allPage);
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/metrics/{metricDefinitionId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<MetricDefinition> getMetricDefinitionById(@PathVariable(value="metricDefinitionId") String metricDefinitionIdStr) {
        UUID metricDefinitionId = UUIDUtils.parse((String)metricDefinitionIdStr);
        MetricDefinition metricDefinition = this.metricDefinitionService.getMetricDefinitionById(metricDefinitionId, this.getSecurityUser());
        return ResponseEntity.ok((Object)metricDefinition);
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/metrics/{metricDefinitionId}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseEntity<?> deleteMetricDefinitionById(@PathVariable(value="metricDefinitionId") String metricDefinitionIdStr) {
        UUID metricDefinitionId = UUIDUtils.parse((String)metricDefinitionIdStr);
        this.metricDefinitionService.deleteMetricDefinitionById(metricDefinitionId, this.getSecurityUser());
        return ResponseEntity.ok((Object)"");
    }

    @ResponseBody
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/metrics"}, method={RequestMethod.POST})
    public ResponseEntity<MetricDefinition> create(@RequestBody MetricDefinitionCreationRequest creationRequest) {
        MetricDefinition metricDefinition = this.metricDefinitionService.create(creationRequest, this.getSecurityUser());
        return ResponseEntity.ok((Object)metricDefinition);
    }

    @ResponseBody
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/metrics/{metricDefinitionId}"}, method={RequestMethod.PUT})
    public ResponseEntity<MetricDefinition> modify(@PathVariable(value="metricDefinitionId") String metricDefinitionIdString, @RequestBody MetricDefinitionModificationRequest modificationRequest) {
        UUID metricDefinitionId = UUIDUtils.parse((String)metricDefinitionIdString);
        MetricDefinition metricDefinition = this.metricDefinitionService.modify(metricDefinitionId, modificationRequest, this.getSecurityUser());
        return ResponseEntity.ok((Object)metricDefinition);
    }

    @ResponseBody
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/metrics/{metricDefinitionId}/calculate"}, method={RequestMethod.POST})
    public ResponseEntity<UUID> calculate(@PathVariable(value="metricDefinitionId") String metricDefinitionIdString, @RequestBody MetricCalculationRequest metricCalculationRequest) {
        this.llmService.validateChatTypeForUser(this.getSecurityUser(), ChatType.METRIC_CODE_ASSISTANT);
        JwtSecurityUser user = this.getSecurityUser();
        UUID metricDefinitionId = UUIDUtils.parse((String)metricDefinitionIdString);
        TaskReference reference = new TaskReference(TaskReferencedEntityType.METRIC_DEFINITION_IMPLEMENT, user.getTenantCustomerKey());
        MetricDefinitionImplementationJob job = MetricDefinitionImplementationJob.builder().datePickerConfig(metricCalculationRequest.getDatePickerConfig()).tzName(metricCalculationRequest.getTzName()).metricDefinitionId(metricDefinitionId).build();
        Task task = (Task)this.taskService.findTaskByReferencedEntity(user, reference, true).orElseThrow(() -> new TaskNotFoundException(reference));
        UUID executionId = this.taskService.runExecution(user, task.getId(), (TaskJob)job, false);
        return ResponseEntity.ok((Object)executionId);
    }

    @ResponseBody
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/metrics/{metricDefinitionId}/calculation/create"}, method={RequestMethod.POST})
    public ResponseEntity<UUID> createCalculation(@PathVariable(value="metricDefinitionId") String metricDefinitionIdString, @RequestBody CalculationCreationRequest calculationCreationRequest) {
        UUID metricDefinitionId = UUIDUtils.parse((String)metricDefinitionIdString);
        UUID calculationFieldId = this.metricDefinitionService.createCalculationBasedOnMetricDefinition(metricDefinitionId, this.getSecurityUser(), calculationCreationRequest);
        return ResponseEntity.ok((Object)calculationFieldId);
    }

    @ResponseBody
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/metrics/{metricDefinitionId}/calculation/check"}, method={RequestMethod.GET})
    public ResponseEntity<MetricDefinitionCalculationStatus> checkCalculation(@PathVariable(value="metricDefinitionId") String metricDefinitionIdString) {
        UUID metricDefinitionId = UUIDUtils.parse((String)metricDefinitionIdString);
        MetricDefinitionCalculationStatus status = this.metricDefinitionService.getMetricDefinitionCalculationStatus(metricDefinitionId, this.getSecurityUser());
        return ResponseEntity.ok((Object)status);
    }

    @ResponseBody
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/explorations"}, method={RequestMethod.POST})
    public ResponseEntity<?> saveExploration(@RequestBody MetricExplorationSaveRequest request) {
        this.metricExplorationService.saveExploration(this.getSecurityUser(), request);
        return ResponseEntity.ok((Object)"");
    }
}

